//
//  CategoryTableView.m
//  redstar
//
//  Created by admin on 15/12/6.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "CategoryTableView.h"
#import "HttpClient.h"

@interface CategoryTableView ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) NSMutableArray *titleArray;
@property (nonatomic, strong) NSMutableArray *categoryArray;
@property (nonatomic, strong) NSMutableDictionary *questionDict;

@property (nonatomic, strong) NSString *cateStr;

@end
@implementation CategoryTableView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}


- (instancetype)initWithFrame:(CGRect)frame style:(UITableViewStyle)style
{
    self = [super initWithFrame:frame style:style];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup
{
    
    self.questionDict = [NSMutableDictionary dictionary];
    [_questionDict setObject:[NSArray arrayWithObjects:@"15分钟退单",@"便民服务",@"基础管理",@"轻松购系统",@"营运物料",@"服务承诺",@"人员形象",@"全员服务",@"其他", nil] forKey:@"服务"];
    [_questionDict setObject:[NSArray arrayWithObjects:@"导视系统",@"背景音乐",@"物料规范",@"儿童区",@"休息区",@"其他", nil] forKey:@"环境企划"];
    [_questionDict setObject:[NSArray arrayWithObjects:@"基础环境",@"物料标识",@"停车场",@"卫生间",@"硬件改造",@"人员",@"其他", nil] forKey:@"环境物业"];
    [_questionDict setObject:[NSArray arrayWithObjects:@"七折管理",@"价签物料",@"其他", nil] forKey:@"价格"];
    [_questionDict setObject:[NSArray arrayWithObjects:@"绿色陈展",@"三年质保",@"其他", nil] forKey:@"质量"];
    [_questionDict setObject:[NSArray arrayWithObjects:@"商户信用分类", nil] forKey:@"商户信用分类"];
    [_questionDict setObject:[NSArray arrayWithObjects:@"审批、比价、采购", nil] forKey:@"审批比价采购"];
    [_questionDict setObject:[NSArray arrayWithObjects:@"送货跟单", nil] forKey:@"送货跟单"];
    [_questionDict setObject:[NSArray arrayWithObjects:@"指标", nil] forKey:@"指标"];
    [_questionDict setObject:[NSArray arrayWithObjects:@"其他", nil] forKey:@"其他"];
    
    self.delegate = self;
    self.dataSource = self;
    self.titleArray = [NSMutableArray arrayWithArray:[NSArray arrayWithObjects:@"15分钟退单",@"便民服务",@"基础管理",@"轻松购系统",@"营运物料",@"服务承诺",@"人员形象",@"全员服务",@"其他", nil]];
    self.categoryArray = [NSMutableArray array];
    
    NSInteger selectedIndex = 0;
    NSIndexPath *selectedIndexPath = [NSIndexPath indexPathForRow:selectedIndex inSection:0];
    [self selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];

    //注册通知
   [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(reloadCurrentTableView:) name:kQuestionGroupNotification object:nil];
}

- (void)reloadCurrentTableView:(NSNotification *)notification
{
    _cateStr = [NSString stringWithFormat:@"%@",notification.userInfo[@"groupName"]];
    NSArray *selectArray = [NSArray arrayWithArray:[_questionDict objectForKey:_cateStr]];
    _titleArray = [NSMutableArray arrayWithArray:selectArray];
    [self reloadData];
    
//    NSString *url = [NSString stringWithFormat:@"%@%@%@",kRedStarURL, kQuestionCategoryURL, notification.userInfo[@"groupName"]];
//    url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
//    HttpClient *http = [[HttpClient alloc] initWithUrl:url];
//    [http getQuestionCategoryWithCompletion:^(id response, NSError *error) {
//        NSLog(@"分类categaory response= %@", response);
//        if (response[@"success"]) {
//            NSDictionary *dictData = response[@"data"];
//            NSArray *array = dictData[@"records"];
//            NSMutableArray *groupArray = [NSMutableArray array];
//            NSMutableArray *categoryArray = [NSMutableArray array];
//            for (NSDictionary *dict in array) {
//                NSString *category = [NSString stringWithFormat:@"%@", dict[@"name"]];
//                NSString *group = [NSString stringWithFormat:@"%@", dict[@"groupName"]];
//                [categoryArray addObject:category];
//                [groupArray addObject:group];
//
//            }
//            _titleArray = categoryArray;
//            _categoryArray = categoryArray;
//            [self reloadData];
//        }
//    }];
}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:kQuestionGroupNotification object:nil];
}


#pragma mark - TableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _titleArray.count;
}


// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"categoryCell"];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:@"categoryCell"];
    }
    cell.textLabel.text = _titleArray[indexPath.row];
    cell.textLabel.font = [UIFont systemFontOfSize:14.0];

    return cell;
}

// cell点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
   // NSString *cateName = _categoryArray[indexPath.row];
    NSString *group = _titleArray[indexPath.row];
    if (_categroyDeleagte && [_categroyDeleagte respondsToSelector:@selector(categoryTableViewClick:GroupTitle:)]) {
        [_categroyDeleagte categoryTableViewClick:_cateStr GroupTitle:group];
    }
}


// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}


@end
