//
//  PictureTextTableCell.m
//  redstar
//
//  Created by admin on 15/12/11.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "PictureTextTableCell.h"

@interface PictureTextTableCell ()
@property (nonatomic, assign) CGFloat bigH;
@end

@implementation PictureTextTableCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        _bigH = 170;
    }
    return self;
}

- (UIImageView *)bigImageView
{
    if (!_bigImageView) {
        _bigImageView = [[UIImageView alloc] init];
        _bigImageView.translatesAutoresizingMaskIntoConstraints = NO;
        _bigImageView.userInteractionEnabled = YES;
//        _bigImageView.contentMode = UIViewContentModeScaleAspectFit;
//        _bigImageView.autoresizesSubviews = YES;
//        _bigImageView.autoresizingMask =
//        UIViewAutoresizingFlexibleLeftMargin | UIViewAutoresizingFlexibleTopMargin | UIViewAutoresizingFlexibleHeight | UIViewAutoresizingFlexibleWidth;
        [_bigImageView setContentScaleFactor:[[UIScreen mainScreen] scale]];
        _bigImageView.contentMode =  UIViewContentModeScaleAspectFill;
        _bigImageView.autoresizingMask = UIViewAutoresizingFlexibleHeight;
        _bigImageView.clipsToBounds  = YES;
        [self.contentView addSubview:_bigImageView];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_bigImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_bigImageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_bigImageView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:titleRight];
        
        // 高度
//        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_bigImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:170];
//        [self.contentView addConstraint:titleHeight];
        
        self.bigHeight = [NSLayoutConstraint constraintWithItem:_bigImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:_bigH];
        [self.contentView addConstraint:_bigHeight];

    }
    return _bigImageView;
}


//- (UIButton *)bigImageView
//{
//    if (!_bigImageView) {
//        _bigImageView = [[UIButton alloc] init];
//        _bigImageView.translatesAutoresizingMaskIntoConstraints = NO;
//        [self.contentView addSubview:_bigImageView];
//        
//        // 顶端
//        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_bigImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
//        [self.contentView addConstraint:titleTop];
//        
//        // 左边
//        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_bigImageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
//        [self.contentView addConstraint:titleLeft];
//        
//        // 右边
//        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_bigImageView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
//        [self.contentView addConstraint:titleRight];
//        
//        // 高度
//        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_bigImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:170];
//        [self.contentView addConstraint:titleHeight];
//    }
//    return _bigImageView;
//}


- (UILabel *)descriptionLabel
{
    if (!_descriptionLabel) {
        _descriptionLabel = [[UILabel alloc] init];
        _descriptionLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _descriptionLabel.font = [UIFont systemFontOfSize:15.0];
        _descriptionLabel.textColor = kLightBlack;
        _descriptionLabel.numberOfLines = 0;
        [self.contentView addSubview:_descriptionLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_descriptionLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.bigImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_descriptionLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_descriptionLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:titleRight];
        
        // 高度
        NSLayoutConstraint *titleBottom = [NSLayoutConstraint constraintWithItem:_descriptionLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-0];
        [self.contentView addConstraint:titleBottom];
    }
    return _descriptionLabel;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
