//
//  LookOnLineDetailView.m
//  redstar
//
//  Created by admin on 15/11/28.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "LookOnLineDetailView.h"
#import "LookOnLineModel.h"

@interface LookOnLineDetailView ()
@property (nonatomic, strong) UILabel *shopname; // 商店名称
@property (nonatomic, strong) UILabel *overDate; // 截止时间
@property (nonatomic, strong) UILabel *people; // 截止时间
@property (nonatomic, strong) UILabel *startDate; // 起始时间
@property (nonatomic, strong) UILabel *taskContent; // 起始时间

@property (nonatomic, strong) UILabel *surplus; // 剩余
@property (nonatomic, strong) UILabel *day; // 天
@property (nonatomic, strong) UIImageView *number; // 天

@property (nonatomic, strong) UILabel *pictureLabel; // 起始时间

@end

@implementation LookOnLineDetailView



- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup
{
    
}

- (void)setLookOnLine:(LookOnLineModel *)lookOnLine
{
    _lookOnLine = lookOnLine;
    
    self.titleLabel.text = [NSString stringWithFormat:@"%@", lookOnLine.title];
    
    self.bgView.backgroundColor = [UIColor whiteColor];
    self.shopname.text = @"商场名称";
    self.overDate.text = @"截止时间";
    self.people.text = @"发起人";
    self.startDate.text = @"发起时间";
    self.taskContent.text = @"任务内容";
    
    self.shopnameLabel.text = [NSString stringWithFormat:@"%@", lookOnLine.store_name];
    self.overDateLabel.text = [NSString stringWithFormat:@"%@", lookOnLine.endDate];
    self.peopleLabel.text = @"王XX 集团X领导";
    self.startDateLabel.text = [NSString stringWithFormat:@"%@", lookOnLine.reportTime];
    
    NSString *intro = [NSString stringWithFormat:@"%@", lookOnLine.content];
    NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc] initWithString:intro];
    NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
    [paragraphStyle setLineSpacing:5];
    [attributedString addAttribute:NSParagraphStyleAttributeName value:paragraphStyle range:NSMakeRange(0, intro.length)];
    [self.taskContentLabel setAttributedText:attributedString];
    
    self.day.text = @"天";
    self.number.image = [UIImage imageNamed:@"figure_bg"];
    self.surplus.text = @"剩余";
    
    self.dayLabel.text = @"2";
    
    self.pictureLabel.text = @"现场照片";
}


- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _titleLabel.textAlignment = NSTextAlignmentCenter;
        _titleLabel.textColor = kAnnounceTextColor;
        _titleLabel.backgroundColor = kSectionBackGroundColor;
        _titleLabel.font = [UIFont systemFontOfSize:18.0];
        [self addSubview:_titleLabel];

        NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self addConstraint:titleLabelTop];

        NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:titleLabelLeft];

        NSLayoutConstraint *titleLabelWidth = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:titleLabelWidth];

        NSLayoutConstraint *titleLabelHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:46];
        [self addConstraint:titleLabelHeight];
    }
    return _titleLabel;
}

- (UIView *)bgView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] init];
        _bgView.translatesAutoresizingMaskIntoConstraints = NO;
        _bgView.layer.borderWidth = 0.5;
        _bgView.layer.borderColor = kSeparateLineCGColor;
        [self addSubview:_bgView];

        NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:_bgView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:titleLabelTop];

        NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:_bgView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:titleLabelLeft];

        NSLayoutConstraint *titleLabelWidth = [NSLayoutConstraint constraintWithItem:_bgView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:titleLabelWidth];

        NSLayoutConstraint *titleLabelBottom = [NSLayoutConstraint constraintWithItem:_bgView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-40];
        [self addConstraint:titleLabelBottom];
    }
    return _bgView;
}
- (UILabel *)shopname
{
    if (!_shopname) {
        _shopname = [[UILabel alloc] init];
        _shopname.font = [UIFont systemFontOfSize:15.0];
        _shopname.textColor = kLightGray;
        _shopname.translatesAutoresizingMaskIntoConstraints = NO;
        [self.bgView addSubview:_shopname];

        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_shopname attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self.bgView addConstraint:Top];

        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_shopname attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.bgView addConstraint:Left];

        NSLayoutConstraint *Width = [NSLayoutConstraint constraintWithItem:_shopname attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self.bgView addConstraint:Width];

        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_shopname attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.bgView  addConstraint:Height];
    }
    return _shopname;
}


- (UILabel *)overDate
{
    if (!_overDate) {
        _overDate = [[UILabel alloc] init];
        _overDate.font = [UIFont systemFontOfSize:15.0];
        _overDate.textColor = kLightGray;
        _overDate.translatesAutoresizingMaskIntoConstraints = NO;
        [self.bgView  addSubview:_overDate];

        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopname attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.bgView  addConstraint:Top];

        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.bgView  attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.bgView  addConstraint:Left];

        NSLayoutConstraint *Width = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self.bgView  addConstraint:Width];

        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.bgView  addConstraint:Height];
    }
    return _overDate;
}

- (UILabel *)people
{
    if (!_people) {
        _people = [[UILabel alloc] init];
        _people.font = [UIFont systemFontOfSize:15.0];
        _people.textColor = kLightGray;
        _people.translatesAutoresizingMaskIntoConstraints = NO;
        [self.bgView  addSubview:_people];

        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_people attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.bgView  addConstraint:Top];

        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_people attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.bgView  attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.bgView  addConstraint:Left];

        NSLayoutConstraint *Width = [NSLayoutConstraint constraintWithItem:_people attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self.bgView  addConstraint:Width];

        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_people attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.bgView  addConstraint:Height];
    }
    return _people;
}

- (UILabel *)startDate
{
    if (!_startDate) {
        _startDate = [[UILabel alloc] init];
        _startDate.font = [UIFont systemFontOfSize:15.0];
        _startDate.textColor = kLightGray;
        _startDate.translatesAutoresizingMaskIntoConstraints = NO;
        [self.bgView  addSubview:_startDate];

        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.people attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.bgView  addConstraint:Top];

        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.bgView  attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.bgView  addConstraint:Left];

        NSLayoutConstraint *Width = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self.bgView  addConstraint:Width];

        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.bgView  addConstraint:Height];
    }
    return _startDate;
}

- (UILabel *)taskContent
{
    if (!_taskContent) {
        _taskContent = [[UILabel alloc] init];
        _taskContent.font = [UIFont systemFontOfSize:15.0];
        _taskContent.textColor = kLightGray;
        _taskContent.translatesAutoresizingMaskIntoConstraints = NO;
        [self.bgView addSubview:_taskContent];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_taskContent attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.startDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.bgView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_taskContent attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.bgView  attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.bgView addConstraint:Left];
        
        NSLayoutConstraint *Width = [NSLayoutConstraint constraintWithItem:_taskContent attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self.bgView addConstraint:Width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_taskContent attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.bgView addConstraint:Height];
    }
    return _taskContent;
}

- (UILabel *)shopnameLabel
{
    if (!_shopnameLabel) {
        _shopnameLabel = [[UILabel alloc] init];
        _shopnameLabel.font = [UIFont systemFontOfSize:15.0];
        _shopnameLabel.textColor = kLightBlack;
        _shopnameLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.bgView addSubview:_shopnameLabel];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self.bgView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.shopname attribute:NSLayoutAttributeRight multiplier:1.0 constant:15];
        [self.bgView addConstraint:Left];
        
      
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.bgView addConstraint:Height];
    }
    return _shopnameLabel;
}


- (UILabel *)day
{
    if (!_day) {
        _day = [[UILabel alloc] init];
        _day.font = [UIFont systemFontOfSize:15.0];
        _day.textColor = kLightBlack;
        _day.textAlignment = NSTextAlignmentCenter;
        _day.translatesAutoresizingMaskIntoConstraints = NO;
        [self.bgView addSubview:_day];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_day attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopnameLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.bgView addConstraint:Top];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_day attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.bgView addConstraint:Right];
        
        NSLayoutConstraint *width = [NSLayoutConstraint constraintWithItem:_day attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.bgView addConstraint:width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_day attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.bgView addConstraint:Height];
    }
    return _day;
}


- (UIImageView *)number
{
    if (!_number) {
        _number = [[UIImageView alloc] init];
        _number.translatesAutoresizingMaskIntoConstraints = NO;
        [self.bgView addSubview:_number];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_number attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopnameLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.bgView addConstraint:Top];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_number attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.day attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.bgView addConstraint:Right];
        
        NSLayoutConstraint *width = [NSLayoutConstraint constraintWithItem:_number attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:26];
        [self.bgView addConstraint:width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_number attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.bgView addConstraint:Height];
    }
    return _number;
}

- (UILabel *)surplus
{
    if (!_surplus) {
        _surplus = [[UILabel alloc] init];
        _surplus.font = [UIFont systemFontOfSize:15.0];
        _surplus.textColor = kLightBlack;
        _surplus.textAlignment = NSTextAlignmentCenter;
        _surplus.translatesAutoresizingMaskIntoConstraints = NO;
        [self.bgView addSubview:_surplus];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_surplus attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopnameLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.bgView addConstraint:Top];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_surplus attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.number attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.bgView addConstraint:Right];
        
        NSLayoutConstraint *width = [NSLayoutConstraint constraintWithItem:_surplus attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
        [self.bgView addConstraint:width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_surplus attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.bgView addConstraint:Height];
    }
    return _surplus;
}


- (UILabel *)overDateLabel
{
    if (!_overDateLabel) {
        _overDateLabel = [[UILabel alloc] init];
        _overDateLabel.font = [UIFont systemFontOfSize:15.0];
        _overDateLabel.textColor = kLightBlack;
        _overDateLabel.textAlignment = NSTextAlignmentLeft;
        _overDateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.bgView addSubview:_overDateLabel];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_overDateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopnameLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.bgView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_overDateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:100];
        [self.bgView addConstraint:Left];
        
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_overDateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.bgView addConstraint:Height];
    }
    return _overDateLabel;
}


- (UILabel *)peopleLabel
{
    if (!_peopleLabel) {
        _peopleLabel = [[UILabel alloc] init];
        _peopleLabel.font = [UIFont systemFontOfSize:15.0];
        _peopleLabel.textColor = kLightBlack;
        _peopleLabel.textAlignment = NSTextAlignmentLeft;
        _peopleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.bgView addSubview:_peopleLabel];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDateLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.bgView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:100];
        [self.bgView addConstraint:Left];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.bgView addConstraint:Right];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.bgView addConstraint:Height];
    }
    return _peopleLabel;
}

- (UILabel *)startDateLabel
{
    if (!_startDateLabel) {
        _startDateLabel = [[UILabel alloc] init];
        _startDateLabel.font = [UIFont systemFontOfSize:15.0];
        _startDateLabel.textColor = kLightBlack;
        _startDateLabel.textAlignment = NSTextAlignmentLeft;
        _startDateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.bgView addSubview:_startDateLabel];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_startDateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.peopleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.bgView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_startDateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:100];
        [self.bgView addConstraint:Left];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_startDateLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.bgView addConstraint:Right];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_startDateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.bgView addConstraint:Height];
    }
    return _startDateLabel;
}


- (UILabel *)taskContentLabel
{
    if (!_taskContentLabel) {
        _taskContentLabel = [[UILabel alloc] init];
        _taskContentLabel.font = [UIFont systemFontOfSize:15.0];
        _taskContentLabel.textColor = kLightBlack;
        _taskContentLabel.textAlignment = NSTextAlignmentLeft;
        _taskContentLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _taskContentLabel.numberOfLines = 0;
        [self.bgView addSubview:_taskContentLabel];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_taskContentLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.startDateLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:10];
        [self.bgView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_taskContentLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:100];
        [self.bgView addConstraint:Left];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_taskContentLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.bgView addConstraint:Right];
    }
    return _taskContentLabel;
}

- (UILabel *)dayLabel
{
    if (!_dayLabel) {
        _dayLabel = [[UILabel alloc] init];
        _dayLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _dayLabel.textColor = kProgressUnSettledColor;
        _dayLabel.textAlignment = NSTextAlignmentCenter;
        _dayLabel.font = [UIFont boldSystemFontOfSize:20.0];
        [self.number addSubview:_dayLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_dayLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.number attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.number addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_dayLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.number attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.number addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_dayLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.number attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.number addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_dayLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.number attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.number addConstraint:overDateHeight];
    }
    return _dayLabel;
}


- (UILabel *)pictureLabel
{
    if(!_pictureLabel) {
        _pictureLabel = [[UILabel alloc] init];
        _pictureLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _pictureLabel.font = [UIFont systemFontOfSize:15.0];
        _pictureLabel.textColor = kLightBlack;
        [self addSubview:_pictureLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.bgView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:overDateHeight];
    }
    return _pictureLabel;
}


@end
