//
//  InspectHeaderView.m
//  redstar
//
//  Created by admin on 15/11/12.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "InspectHeaderView.h"
#import "TaskGroup.h"

@interface InspectHeaderView ()
{
    UIButton *_bgButton;
    UIImageView *_arrowImageView;
   // UIView *_lineView;
    UIView *_lineView1;
}
@end

@implementation InspectHeaderView

+ (instancetype)headViewWithTableView:(UITableView *)tableView
{
    static NSString *headIdentifier = @"header";
    
    InspectHeaderView *headView = (InspectHeaderView *)[tableView dequeueReusableCellWithIdentifier:headIdentifier];
    if (headView == nil) {
        headView = [[InspectHeaderView alloc] initWithReuseIdentifier:headIdentifier];
    }
    
    return headView;
}

- (id)initWithReuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithReuseIdentifier:reuseIdentifier]) {
        UIButton *bgButton = [UIButton buttonWithType:UIButtonTypeCustom];
        bgButton.backgroundColor = [UIColor whiteColor];
        bgButton.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
        bgButton.contentEdgeInsets = UIEdgeInsetsMake(0, 0, 0, 10);
        bgButton.titleEdgeInsets = UIEdgeInsetsMake(0, 20, 0, 0);
        [bgButton addTarget:self action:@selector(headBtnClick) forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:bgButton];
        _bgButton = bgButton;
        
        UIImageView *arrowIMView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"arrow_down"]];
        [self addSubview:arrowIMView];
        _arrowImageView = arrowIMView;
        
//        UIView *lineView = [[UIView alloc] init];
//        lineView.backgroundColor = kSeparateLineColor;
//        [self addSubview:lineView];
//        _lineView = lineView;
        
        UIView *lineView1 = [[UIView alloc] init];
        lineView1.backgroundColor = kSeparateLineColor;
        [self addSubview:lineView1];
        _lineView1 = lineView1;
    }
    return self;
}

- (void)headBtnClick
{
    _taskGroup.opened = !_taskGroup.isOpened;
    if ([_delegate respondsToSelector:@selector(clickHeadView)]) {
        [_delegate clickHeadView];
    }
}

- (void)setTaskGroup:(TaskGroup *)taskGroup
{
    _taskGroup = taskGroup;
    NSString *nameStr = [NSString stringWithFormat:@"模块 -- %@(%d/%d)", taskGroup.category, taskGroup.reportCount, taskGroup.questionCount];
    NSMutableAttributedString *nameAttr = [[NSMutableAttributedString alloc] initWithString:nameStr];
    [nameAttr addAttributes:@{NSForegroundColorAttributeName:kLightBlack,NSFontAttributeName:[UIFont systemFontOfSize:17.0f]} range:NSMakeRange(0,nameStr.length)];
    [_bgButton setAttributedTitle:nameAttr forState:UIControlStateNormal];
}



- (void)didMoveToSuperview
{
    _arrowImageView.transform = _taskGroup.isOpened ? CGAffineTransformMakeRotation(M_PI) : CGAffineTransformMakeRotation(0);
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    
    _bgButton.frame = self.bounds;
    _arrowImageView.frame = CGRectMake(self.frame.size.width - 33, (self.frame.size.height - 8) / 2, 13, 8);
    //_lineView.frame = CGRectMake(0, self.frame.size.height - 1, self.frame.size.width, 1);
    _lineView1.frame = CGRectMake(0, 0, self.frame.size.width, 1);

}


@end
