//
//
//  redstar
//
//  Created by admin on 15/11/27.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "InpectPictureCell.h"

@implementation InpectPictureCell

#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

#pragma mark - Private Methods
- (void)setup
{
    self.contentView.backgroundColor = [UIColor colorWithRed:239 / 255.0 green:239 / 255.0 blue:239 / 255.0 alpha:239 / 255.0];
}

- (UIButton *)photoButton1
{
    if (!_photoButton1) {
        _photoButton1 = [[UIButton alloc] init];
        _photoButton1.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_photoButton1];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint
                                           constraintWithItem:_photoButton1
                                           attribute:NSLayoutAttributeTop
                                           relatedBy:NSLayoutRelationEqual
                                           toItem:self.contentView
                                           attribute:NSLayoutAttributeTop
                                           multiplier:1.0
                                           constant:5];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint
                                            constraintWithItem:_photoButton1
                                            attribute:NSLayoutAttributeLeft
                                            relatedBy:NSLayoutRelationEqual
                                            toItem:self.contentView
                                            attribute:NSLayoutAttributeLeft
                                            multiplier:1.0
                                            constant:20];
        [self.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint
                                             constraintWithItem:_photoButton1
                                             attribute:NSLayoutAttributeRight
                                             relatedBy:NSLayoutRelationEqual
                                             toItem:self.contentView
                                             attribute:NSLayoutAttributeRight
                                             multiplier:1.0
                                             constant:-(kScreenWidth / 2 + 10)];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint
                                             constraintWithItem:_photoButton1
                                             attribute:NSLayoutAttributeHeight
                                             relatedBy:NSLayoutRelationEqual
                                             toItem:nil
                                             attribute:NSLayoutAttributeNotAnAttribute
                                             multiplier:1.0
                                             constant:90];
        [self.contentView addConstraint:overDateHeight];
        
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint
                                              constraintWithItem:_photoButton1
                                              attribute:NSLayoutAttributeBottom
                                              relatedBy:NSLayoutRelationEqual
                                              toItem:self.contentView
                                              attribute:NSLayoutAttributeBottom
                                              multiplier:1.0
                                              constant:-5];
        [self.contentView addConstraint:overDateBottom];
    }
    return _photoButton1;
}

- (UIButton *)photoButton2
{
    if (!_photoButton2) {
        _photoButton2 = [[UIButton alloc] init];
        _photoButton2.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_photoButton2];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint
                                           constraintWithItem:_photoButton2
                                           attribute:NSLayoutAttributeTop
                                           relatedBy:NSLayoutRelationEqual
                                           toItem:self.contentView
                                           attribute:NSLayoutAttributeTop
                                           multiplier:1.0
                                           constant:5];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint
                                            constraintWithItem:_photoButton2
                                            attribute:NSLayoutAttributeLeft
                                            relatedBy:NSLayoutRelationEqual
                                            toItem:self.contentView
                                            attribute:NSLayoutAttributeLeft
                                            multiplier:1.0
                                            constant:kScreenWidth / 2 + 10];
        [self.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint
                                             constraintWithItem:_photoButton2
                                             attribute:NSLayoutAttributeRight
                                             relatedBy:NSLayoutRelationEqual
                                             toItem:self.contentView
                                             attribute:NSLayoutAttributeRight
                                             multiplier:1.0
                                             constant:-20];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint
                                              constraintWithItem:_photoButton2
                                              attribute:NSLayoutAttributeHeight
                                              relatedBy:NSLayoutRelationEqual
                                              toItem:nil
                                              attribute:NSLayoutAttributeNotAnAttribute
                                              multiplier:1.0
                                              constant:90];
        [self.contentView addConstraint:overDateHeight];
        
    }
    return _photoButton2;
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
