//
//  AddButtonTableViewCell.m
//  redstar
//
//  Created by admin on 15/12/19.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "AddButtonTableViewCell.h"

@implementation AddButtonTableViewCell

- (UIButton *)addButton
{
    if (!_addButton) {
        _addButton = [[UIButton alloc] init];
        _addButton.translatesAutoresizingMaskIntoConstraints = NO;
        [_addButton setTitle:@"添加图片文字" forState:UIControlStateNormal];
        [_addButton setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        _addButton.titleLabel.font = [UIFont systemFontOfSize:15.0];
        [self.contentView addSubview:_addButton];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_addButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_addButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:kScreenWidth - 130];
        [self.contentView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_addButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_addButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentView addConstraint:contentHeight];
        
        NSLayoutConstraint *contentBottom = [NSLayoutConstraint constraintWithItem:_addButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:contentBottom];
    }
    return _addButton;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
