//
//  LookOnLineTableViewCell.m
//  redstar
//
//  Created by admin on 15/11/28.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "LookOnLineTableViewCell.h"

@implementation LookOnLineTableViewCell

- (void)setLookOnLine:(LookOnLineModel *)lookOnLine
{
    _lookOnLine = lookOnLine;
    self.titleLabel.text = [NSString stringWithFormat:@"%@", lookOnLine.title];
    //self.peopleLabel.text = [NSString stringWithFormat:@"发起人：%@", lookOnLine.]
    self.peopleLabel.text = @"发起人：王XX 集团XX总";
    self.startDate.text = [NSString stringWithFormat:@"发起时间：%@", lookOnLine.reportTime];
    self.overDate.text = [NSString stringWithFormat:@"截止时间：%@", lookOnLine.endDate];
    self.progressLabel.text = @"临检进度：进行中";
    
    if ([lookOnLine.state isEqualToString:@"initial"]) {
        NSString *str = [NSString stringWithFormat:@"临检进度：未处理"];
        NSMutableAttributedString *strAttr = [[NSMutableAttributedString alloc] initWithString:str];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kCellDetailColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,5)];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kProgressUnSettledColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(5,str.length - 5)];
        [self.progressLabel setAttributedText:strAttr];
    } else if ([lookOnLine.state isEqualToString:@"reported"]) {
        NSString *str = [NSString stringWithFormat:@"临检进度：已上报"];
        NSMutableAttributedString *strAttr = [[NSMutableAttributedString alloc] initWithString:str];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kCellDetailColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,5)];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kProgressDealWithColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(5,str.length - 5)];
        [self.progressLabel setAttributedText:strAttr];
    } else if ([lookOnLine.state isEqualToString:@"finished"]) {
        NSString *str = [NSString stringWithFormat:@"临检进度：已完成"];
        NSMutableAttributedString *strAttr = [[NSMutableAttributedString alloc] initWithString:str];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kCellDetailColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,5)];
        [strAttr addAttributes:@{NSForegroundColorAttributeName:kProgressDealWithColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(5,str.length - 5)];
        [self.progressLabel setAttributedText:strAttr];
    } else {
        NSString *str = [NSString stringWithFormat:@"临检进度："];
        self.progressLabel.text = str;
    }
}


#pragma mark - lazy Loading
- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.textColor = kCellTitleColor;
        _titleLabel.font = [UIFont systemFontOfSize:19.0];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_titleLabel];
        
        NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:8];
        [self.contentView addConstraint:titleLabelTop];
        
        NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLabelLeft];
        
        NSLayoutConstraint *startDateRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:startDateRight];
        
        NSLayoutConstraint *titleLabelHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentView addConstraint:titleLabelHeight];
    }
    return _titleLabel;
}

- (UILabel *)peopleLabel
{
    if (!_peopleLabel) {
        _peopleLabel = [[UILabel alloc] init];
        _peopleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _peopleLabel.font = [UIFont systemFontOfSize:14.0];
        _peopleLabel.textColor = kCellDetailColor;
        [self.contentView addSubview:_peopleLabel];
        
        NSLayoutConstraint *startDateTop = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:2];
        [self.contentView addConstraint:startDateTop];
        
        NSLayoutConstraint *startDateLeft = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:startDateLeft];
        
        NSLayoutConstraint *startDateRight = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:startDateRight];
        
        NSLayoutConstraint *startDateHeight = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:startDateHeight];
        
    }
    return _peopleLabel;

}

- (UILabel *)startDate
{
    if (!_startDate) {
        _startDate = [[UILabel alloc] init];
        _startDate.translatesAutoresizingMaskIntoConstraints = NO;
        _startDate.font = [UIFont systemFontOfSize:14.0];
        _startDate.textColor = kCellDetailColor;
        [self.contentView addSubview:_startDate];
        
        NSLayoutConstraint *startDateTop = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.peopleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:2];
        [self.contentView addConstraint:startDateTop];
        
        NSLayoutConstraint *startDateLeft = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:startDateLeft];
        
        NSLayoutConstraint *startDateRight = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:startDateRight];
        
        NSLayoutConstraint *startDateHeight = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:startDateHeight];
        
    }
    return _startDate;
}

- (UILabel *)overDate
{
    if (!_overDate) {
        _overDate = [[UILabel alloc] init];
        _overDate.font = [UIFont systemFontOfSize:14.0];
        _overDate.textColor = kCellDetailColor;
        _overDate.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_overDate];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.startDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:2];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateHeight];
    }
    return _overDate;
}

- (UILabel *)progressLabel
{
    if (!_progressLabel) {
        _progressLabel = [[UILabel alloc] init];
        _progressLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _progressLabel.font = [UIFont systemFontOfSize:14.0];
        _progressLabel.textColor = kCellDetailColor;
        [self.contentView addSubview:_progressLabel];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_progressLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:2];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:_progressLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateLeft];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_progressLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:overDateRight];

        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_progressLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:overDateHeight];
        
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint constraintWithItem:_progressLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-8];
        [self.contentView addConstraint:overDateBottom];
    }
    return _progressLabel;
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
}

@end
