//
//  OnLineTableViewCell.m
//  redstar
//
//  Created by admin on 15/11/1.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "OnLineTableViewCell.h"

@implementation OnLineTableViewCell
#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
    
    // Configure the view for the selected state
}

#pragma mark - Private Methods
- (void)setup
{
    self.titleLabel.textColor = kOnLineCellTitleColor;
    
}

#pragma mark - lazy loading
- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _titleLabel.font = [UIFont systemFontOfSize:16.0];
        [self.contentView addSubview:_titleLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self.contentView addConstraint:titleRight];
        
        // 高度
        NSLayoutConstraint *titleBottom = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleBottom];
        // 高度
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
        [self.contentView addConstraint:titleHeight];

    }
    return _titleLabel;
}

#pragma mark - lazy loading
- (UILabel *)selectLabel
{
    if (!_selectLabel) {
        _selectLabel = [[UILabel alloc] init];
        _selectLabel.textColor = kOnLineCellDetailColor;
        _selectLabel.textAlignment = NSTextAlignmentRight;
        _selectLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _selectLabel.font = [UIFont systemFontOfSize:15.0];
        [self.contentView addSubview:_selectLabel];
        
        // 顶端
        NSLayoutConstraint *selectTop = [NSLayoutConstraint constraintWithItem:_selectLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:selectTop];
        
        // 左边
        NSLayoutConstraint *selectRight = [NSLayoutConstraint constraintWithItem:_selectLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-10];
        [self.contentView addConstraint:selectRight];
        
         // 右边
        NSLayoutConstraint *selectWidth = [NSLayoutConstraint constraintWithItem:_selectLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeRight multiplier:1.0 constant:10];
        [self.contentView addConstraint:selectWidth];
//
        // 高度
        NSLayoutConstraint *selectBottom = [NSLayoutConstraint constraintWithItem:_selectLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:selectBottom];
    }
    return _selectLabel;
}

- (UIButton *)storeBtn
{
    if (!_storeBtn) {
        _storeBtn = [[UIButton alloc] init];
        _storeBtn.tag = 323228;
        [_storeBtn setTitleColor:kOnLineCellTitleColor forState:UIControlStateNormal];
        _storeBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_storeBtn setTitle:@"商场得分" forState:UIControlStateNormal];
        [_storeBtn setImage:[UIImage imageNamed:@"select_box"] forState:UIControlStateNormal];
        [_storeBtn setImage:[UIImage imageNamed:@"no_select_box"] forState:UIControlStateSelected];
        _storeBtn.titleLabel.font = [UIFont systemFontOfSize:15.0f];
        _storeBtn.imageEdgeInsets = UIEdgeInsetsMake(0, 0, 0, 20);
        _storeBtn.titleEdgeInsets = UIEdgeInsetsMake(0, 5, 0, 0);
        _storeBtn.imageView.contentMode = UIViewContentModeRight;
        _storeBtn.titleLabel.contentMode = UIViewContentModeLeft;
        [self.contentView addSubview:_storeBtn];
        
        // 顶端
        NSLayoutConstraint *selectTop = [NSLayoutConstraint constraintWithItem:_storeBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:selectTop];
        
        // 左边
        NSLayoutConstraint *selectRight = [NSLayoutConstraint constraintWithItem:_storeBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-122];
        [self.contentView addConstraint:selectRight];
        
        // 右边
        NSLayoutConstraint *selectWidth = [NSLayoutConstraint constraintWithItem:_storeBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
        [self.contentView addConstraint:selectWidth];
        
        // 高度
        NSLayoutConstraint *selectBottom = [NSLayoutConstraint constraintWithItem:_storeBtn attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:selectBottom];
    }
    return _storeBtn;
}


- (UIButton *)averageBtn
{
    if (!_averageBtn) {
        _averageBtn = [[UIButton alloc] init];
        _averageBtn.tag = 323229;
        [_averageBtn setTitleColor:kOnLineCellTitleColor forState:UIControlStateNormal];
        _averageBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_averageBtn setTitle:@"区域平均分" forState:UIControlStateNormal];
        [_averageBtn setImage:[UIImage imageNamed:@"select_box"] forState:UIControlStateNormal];
        [_averageBtn setImage:[UIImage imageNamed:@"no_select_box"] forState:UIControlStateSelected];
        _averageBtn.titleLabel.font = [UIFont systemFontOfSize:15.0f];
        _averageBtn.imageEdgeInsets = UIEdgeInsetsMake(0, 0, 0, 20);
        _averageBtn.titleEdgeInsets = UIEdgeInsetsMake(0, 5, 0, 0);
        _averageBtn.imageView.contentMode = UIViewContentModeRight;
        _averageBtn.titleLabel.contentMode = UIViewContentModeLeft;
        [self.contentView addSubview:_averageBtn];
        
        // 顶端
        NSLayoutConstraint *selectTop = [NSLayoutConstraint constraintWithItem:_averageBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:selectTop];
        
        // 左边
        NSLayoutConstraint *selectRight = [NSLayoutConstraint constraintWithItem:_averageBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-18];
        [self.contentView addConstraint:selectRight];
        
        // 右边
        NSLayoutConstraint *selectWidth = [NSLayoutConstraint constraintWithItem:_averageBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:95];
        [self.contentView addConstraint:selectWidth];
        
        // 高度
        NSLayoutConstraint *selectBottom = [NSLayoutConstraint constraintWithItem:_averageBtn attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:selectBottom];

    }
    return _averageBtn;
}
@end
