//
//  AnnounceModel.m
//  redstar
//
//  Created by admin on 15/11/30.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "AnnounceModel.h"

@implementation AnnounceModel
+ (instancetype)announceModelWithDict:(NSDictionary *)dict
{
    return [[self alloc] initWithDict:dict];
}

- (instancetype)initWithDict:(NSDictionary *)dict
{
    if (self = [super init]) {
        [self setValuesForKeysWithDictionary:dict];
    }
    return self;
}
- (void)setValuesForKeysWithDictionary:(NSDictionary<NSString *,id> *)keyedValues{
    Class cls = self.class;
    for (NSString *key in keyedValues.allKeys) {
        NSString *varName = [NSString stringWithFormat:@"_%@", key];
        const char *c_key = [varName cStringUsingEncoding:NSUTF8StringEncoding];
        Ivar var = class_getInstanceVariable(cls, c_key);
        if (var) {
            [self setValue:[keyedValues objectForKey:key] forKey:key];
        }
    }
}
@end
