//
//  ScreenView.h
//  redstar
//
//  Created by admin on 15/11/11.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "GroupTabBar.h"
#import "InspectTableView.h"

@protocol ScreenTableDelegate <NSObject>

- (void)tableViewDidSelectRow:(NSInteger)row;

@end

@interface ScreenView : UIView

@property (nonatomic, strong) GroupTabBar *groupTabBar; // 重置

@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) UITextView *textView;
@property (nonatomic, strong) InspectTableView *inspectTableView;

@property (nonatomic, strong) UIButton *resetBtn; // 重置
@property (nonatomic, strong) UIButton *submitBtn; // 提交

@property (nonatomic, weak) id <ScreenTableDelegate> delegate;

- (instancetype)initWithTitleArray:(NSArray *)titleArray;


@end
