//
//  HttpClient.h
//  redstar
//
//  Created by admin on 15/11/7.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AFNetworking.h>

typedef void (^completionBlock) (id response, NSError *error);


@interface HttpClient : NSObject
// 初始化
- (id)initWithUrl:(NSString *)url;

// 登陆初始化
- (id)initWithLogin;

// 登陆
- (void)loginWithUsername:(NSString *)username password:(NSString *)password completion:(completionBlock)completion;

// 检查更新版本
- (void)checkAndUpdateCurrentVersionWithCompletion:(completionBlock)completion;

// 获取问题列表
- (void)getQuestionListWithParameters:(id)parameters completion:(completionBlock)completion;

// 获取问题详情
- (void)getQuestionDetailWithParameters:(id)parameters completion:(completionBlock)completion;

// 获取巡检列表
- (void)getInspectListWithParameters:(id)parameters completion:(completionBlock)completion;

// 获取巡检排名
- (void)getRankingListWithParameters:(id)parameters completion:(completionBlock)completion;

// 获取口碑巡检明细
- (void)getPraiseDetailWithParameters:(id)parameters completion:(completionBlock)completion;

// 提交评论
- (void)submitCommentWithParameters:(id)parameters completion:(completionBlock)completion;

// 提交评论
- (void)likeCountWithParameters:(id)parameters completion:(completionBlock)completion;

// 取消点赞
- (void)cancelLikeCountWithParameters:(id)parameters completion:(completionBlock)completion;

// 上传新问题
- (void)uploadNewQuestionWithParameters:(id)parameters completion:(completionBlock)completion;

// 上传新检查点
- (void)uploadInspectResultWithParameters:(id)parameters completion:(completionBlock)completion;

// 获取公告列表
- (void)getAnnounceListWithCompletion:(completionBlock)completion;

// 获取公告详情
- (void)getAnnounceDetailWithCompletion:(completionBlock)completion;

// 提交公告已读状态
- (void)settingAnnounceYetReadWithCompletion:(completionBlock)completion;

// 获取管理层的抽查任务的列表
- (void)getManageSportCheckListWithParameters:(id)parameters completion:(completionBlock)completion;

// 获取商场的抽查列表
- (void)getStoreSportCheckListWithParameters:(id)parameters completion:(completionBlock)completion;


// 发起抽查
- (void)saveSportCheckWithParameters:(id)parameters completion:(completionBlock)completion;

// 抽查任务的明细
- (void)getSportCheckDetailWithCompletion:(completionBlock)completion;

// 上报抽查结果
- (void)reportCheckResultWithParameters:(id)parameters completion:(completionBlock)completion;

// 抽查评分
- (void)gradeCheckResultWithParameters:(id)parameters completion:(completionBlock)completion;

// 获取问题专业组
- (void)getQuestionGroupWithCompletion:(completionBlock)completion;

// 获取问题专业组
- (void)getQuestionCategoryWithCompletion:(completionBlock)completion;

/**
 *  口碑现场相关URL
 */

// 保存口碑现场
- (void)savePicturePraiseWithParameters:(id)parameters completion:(completionBlock)completion;

// 上传口碑图片
- (void)upLoadPraisePictureWithParameters:(id)parameters completion:(completionBlock)completion;

// 提交口碑现场
- (void)submitPicturePraiseWithCompletion:(completionBlock)completion;

// 查询口碑现场
- (void)queryPicturePraiseWithParameters:(id)parameters completion:(completionBlock)completion;

// 口碑现场明细
- (void)getPicturePraiseDetailWithCompletion:(completionBlock)completion;

// 口碑点赞
- (void)getLikePicturePraiseWithCompletion:(completionBlock)completion;

// 口碑取消点赞
- (void)cancelLikePicturePraiseWithCompletion:(completionBlock)completion;
/**
 *  口碑排名（新）
 */

// 获取口碑列表
- (void)queryShortPraiseWithCompletion:(completionBlock)completion;

// 查询下级参数
- (void)queryLowerOrgsWithParameters:(id)parameters completion:(completionBlock)completion;

// 获取口碑标准的附件列表
- (void)getAttachmentsWithParameters:(id)parameters completion:(completionBlock)completion;

// 提交问题处理结果
- (void)submitQuestionResultWithParameters:(id)parameters completion:(completionBlock)completion;
@end
