//
//  MineViewController.m
//  redstar
//
//  Created by admin on 15/10/23.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "MineViewController.h"
#import "MineTableHeaderView.h"
#import "MineTableFooterView.h"
#define kMineTableViewCell @"mineTableViewCell"

#import "AboutMeViewController.h"

#import "HttpClient.h"

@interface MineViewController () <UITableViewDelegate, UITableViewDataSource, UIAlertViewDelegate, UIActionSheetDelegate>

@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSMutableArray *titleArray;

@property (nonatomic, strong) UIButton *quitButton;

@property (nonatomic, strong) MineTableHeaderView *headView;
@property (nonatomic, strong) MineTableFooterView *footView;

@property (nonatomic, copy) NSString *jumpURL;

@property (nonatomic, strong) UIActionSheet *numberActionSheet;

@end

@implementation MineViewController
#pragma mark - ViewDidLoad
- (void)viewDidLoad
{
    [super viewDidLoad];
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"我的"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
    
    
    
    self.view.backgroundColor = kSectionBackGroundColor;
    self.titleArray = [NSMutableArray arrayWithObjects:@"配置",@"关于",@"检查版本更新",@"清除缓存",nil];
    
    
    [self setupTableView];
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBar.hidden = NO;
    self.tabBarController.tabBar.hidden = YES;
    
}

#pragma mark - Prative Methods

// 返回上一页面
- (void)doBack:(UIBarButtonItem *)sender
{
    [self.navigationController popToViewController:[self.navigationController.viewControllers objectAtIndex:0] animated:YES];
}

- (void)setupTableView
{
    [self.tableView registerClass:[UITableViewCell class] forCellReuseIdentifier:kMineTableViewCell];
    
    _tableView.tableFooterView = self.footView;
    _tableView.tableHeaderView = self.headView;
    [_footView.quitButton addTarget:self action:@selector(quitLoginClick:) forControlEvents:UIControlEventTouchUpInside];
}



- (void)quitLoginClick:(UIButton *)sender
{
    
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您确定要退出登录吗？" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确定", nil];
    alert.tag = 7838347;
    [alert show];
    
    
}

- (void)clear
{
    
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
                    NSString *cachPath = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask, YES) objectAtIndex:0];
                    NSArray *files = [[NSFileManager defaultManager] subpathsAtPath:cachPath];
                    for (NSString *p in files) {
                    NSError *error;
                    NSString *path = [cachPath stringByAppendingPathComponent:p];
                if ([[NSFileManager defaultManager] fileExistsAtPath:path]) {
                        [[NSFileManager defaultManager] removeItemAtPath:path error:&error];
                    }
                }
    [self performSelectorOnMainThread:@selector(clearCacheSuccess) withObject:nil waitUntilDone:YES];
    });
}

- (void)clearCacheSuccess
{
    UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"提示" message:@"清除缓存成功" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
    [alertView show];
}


#pragma mark - UIAlertViewDelegate
-(void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex
{
    if (alertView.tag == 7838347) {
        if (buttonIndex == 0) {
            return;
        } else {
            NSUserDefaults *userDefault = [NSUserDefaults standardUserDefaults];
            [userDefault removeObjectForKey:@"loginMessage"];
            [userDefault removeObjectForKey:@"username"];
            [userDefault removeObjectForKey:@"password"];
            
            [self.tabBarController dismissViewControllerAnimated:YES completion:nil];
        }
    }
    
    if (buttonIndex == 1 && alertView.tag == 3058284) {
        NSString *url = self.jumpURL;
        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:url]];
    }
}

#pragma mark - Private Methods
// 获取版本
- (void)getVersion
{
    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:[NSString stringWithFormat:@"%@%@", kRedStarURL, kCheckUpdateURL]];
    [httpCilent checkAndUpdateCurrentVersionWithCompletion:^(id response, NSError *error) {
        if (response[@"data"] == nil || response[@"data"] == NULL || [response[@"data"] isEqual:[NSNull null]] || response[@"data"] == Nil) {
            return;
        } else {
            NSDictionary *dict = response[@"data"];
            NSString *newVersion = [NSString stringWithFormat:@"%@", dict[@"version"]];
            self.jumpURL = [NSString stringWithFormat:@"%@", dict[@"url"]];
            [self checkAppUpdate:newVersion];
        }
    }];
}

- (void)checkAppUpdate:(NSString *)newVersion
{
    // 获取当前版本
    NSDictionary *infoDic = [[NSBundle mainBundle] infoDictionary];
    NSString *currentVersion = [NSString stringWithFormat:@"%@",infoDic[@"CFBundleShortVersionString"]];
    
    if (![currentVersion isEqualToString:newVersion]) {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示！" message:[NSString stringWithFormat:@"发现新版本：%@", newVersion] delegate:self cancelButtonTitle:@"稍后再说" otherButtonTitles:@"前往更新", nil];
        alert.delegate = self;
        [alert show];
        alert.tag = 3058284;
    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示！" message:[NSString stringWithFormat:@"当前已经是最新版本！"] delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
    }
}



#pragma mark - TableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _titleArray.count;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kMineTableViewCell];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kMineTableViewCell];
    }
    // 设置cell右边有个小箭头
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    cell.textLabel.text = _titleArray[indexPath.row];
    cell.textLabel.font = [UIFont systemFontOfSize:15.0];
    cell.textLabel.textColor = kLightBlack;
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 2) {
        [self getVersion];
    } else if (indexPath.row == 1) {
        AboutMeViewController *about = [[AboutMeViewController alloc] init];
        [self.navigationController pushViewController:about animated:YES];
    } else if (indexPath.row == 0){
        self.numberActionSheet = [[UIActionSheet alloc] initWithTitle:@"列表请求数量设置" delegate:self cancelButtonTitle:@"取消" destructiveButtonTitle:nil otherButtonTitles:@"10",@"20",@"30",@"40", @"50", nil];
        [_numberActionSheet showInView:self.view];

    } else {
        [self clear];
    }
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 45;
}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 20;
}

#pragma mark - UIActionSheetDelegate

- (void)actionSheet:(UIActionSheet *)actionSheet didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    if (buttonIndex == 0) {
        [[NSUserDefaults standardUserDefaults] setObject:@(10) forKey:@"requestNumber"];
    } else if (buttonIndex == 1){
        [[NSUserDefaults standardUserDefaults] setObject:@(20) forKey:@"requestNumber"];
    } else if (buttonIndex == 2){
        [[NSUserDefaults standardUserDefaults] setObject:@(30) forKey:@"requestNumber"];
    } else if (buttonIndex == 3){
        [[NSUserDefaults standardUserDefaults] setObject:@(40) forKey:@"requestNumber"];
    } else if (buttonIndex == 4){
        [[NSUserDefaults standardUserDefaults] setObject:@(50) forKey:@"requestNumber"];
    }
}


#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] init];
    }
    _tableView.delegate = self;
    _tableView.dataSource = self;
    _tableView.translatesAutoresizingMaskIntoConstraints = NO;
    _tableView.backgroundColor = kMineBackGroundColor;
    [self.view addSubview:_tableView];
    
    NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [self.view addConstraint:tableTop];
    
    NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [self.view addConstraint:tableLeft];
    
    NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self.view addConstraint:tableRight];
    
    NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self.view addConstraint:tableBottom];
    
    return _tableView;
}


- (MineTableHeaderView *)headView
{
    if (!_headView) {
        _headView = [[MineTableHeaderView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 150)];
    }
    return _headView;
}

- (MineTableFooterView *)footView
{
    if (!_footView) {
        _footView = [[MineTableFooterView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, kScreenHeight - 64 - 150 - 20 - 45 * 5)];
    }
    return _footView;
}





@end
