//
//  SearchViewController.m
//  redstar
//
//  Created by admin on 15/12/2.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "SearchViewController.h"
#import "InspectListViewController.h"
#import "RankingListViewController.h"
#import "OnLineViewController.h"
#import "PictureViewController.h"
#import "QuestionViewController.h"

#import "HomeCellItem.h"
#import "NoDataView.h"

#import "PictureTableCell.h"
#define kHomePictureListCell @"homePictureListCell"
#import "PictureStoryViewController.h"

#import "HomeTitleTableCell.h"
#define kHomeTitleTableCell @"homeTitleTableCell"
#import "RankingListCell.h"
#define kHomeRankingListCell @"homeRankingListsCell"
#import "RankDetailViewController.h"
#import "RankListModel.h"
#import "RankCommentCell.h"

#import "QuestionListTableCell.h"
#define kHomeQuestionListTableCell @"homeQuestionListTableCell"
#import "QuestionModel.h"
#import "QuestionDetailViewController.h"
#define kQuestionTag 387428

#import "InspectListCell.h"
#define kHomeInspectListCell @"homeInspectListsCell"
#import "InspectTaskViewController.h"
#import "TaskListModel.h"

#import "SpotCheckOnLineViewController.h"

#import "LookOnLineViewController.h"

#import "StandardViewController.h"

#import "HttpClient.h"
#import <MBProgressHUD.h>

#import <MJRefresh.h>
#import "SearchViewController.h"
#import "PicCategoryViewController.h"

#import "LookOnLineModel.h"
#import "LookOnLineTableViewCell.h"
#define kSearchLookOnLineCell @"searchLookOnLineTableViewCell.h"

#import "SpotCheckModel.h"
#import "SpotCheckTableViewCell.h"
#define kSearchSpotCehcekCell @"searchSpotCheckCell"

#import "OnLineCompleteViewController.h"
#import "LookOnLineDetailViewController.h"


@interface SearchViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;

@property (nonatomic, strong) NSMutableArray *sectionArray; // section标题
@property (nonatomic, strong) NSMutableArray *allQuestionArray; // 问题与知识
@property (nonatomic, strong) NSMutableArray *taskListDataArray; // 问题与知识
@property (nonatomic, strong) NSMutableArray *allRankListArray;
@property (nonatomic, strong) NSMutableArray *allPraiseListArray;

@property (nonatomic, strong) NSMutableArray *allExcellentCaseArray; // 口碑报道
@property (nonatomic, strong) NSMutableArray *allPatrolReportArray; // 巡店报告
@property (nonatomic, strong) NSMutableArray *allLookOnLineList; //
@property (nonatomic, strong) NSMutableArray *allSpotCheckList; //
@property (nonatomic, strong) NoDataView *noDataView;

@end

@implementation SearchViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    self.sectionArray = [NSMutableArray arrayWithObjects:@"口碑报告",@"口碑随手拍",@"口碑报道",@"口碑巡店", @"问题知识",@"口碑巡检",@"在线抽查", @"查看抽查",nil];
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:self.customStr];
    customLab.textAlignment = NSTextAlignmentCenter;
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }

    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    
    
    
    NSArray *permissions = [[NSUserDefaults standardUserDefaults] objectForKey:@"permissions"];
    
    // 口碑报告 口碑随手拍 口碑现场 口碑标准  问题知识 口碑巡检
    
    if ([permissions containsObject:@"500201"]) {
        [self requestRankingList];
    } else {
        [_sectionArray removeObject:@"口碑报告"];
    }
    
    NSArray *typeArray = [NSArray arrayWithObjects:@"store", @"casus",@"report",nil];
    
    // 口碑随手拍
    [self requestPicturePraiseWithType:typeArray[0]];
    // 优秀案例
    [self requestPicturePraiseWithType:typeArray[1]];
    // 巡店报告
    [self requestPicturePraiseWithType:typeArray[2]];
    
    
    if ([permissions containsObject:@"500501"] || [permissions containsObject:@"500502"]) {
        [self requestQuestionList];
    }else {
        [_sectionArray removeObject:@"问题知识"];
    }
    
    if ([permissions containsObject:@"500101"] || [permissions containsObject:@"500102"]) {
        [self requestInspectList];
    }else {
        [_sectionArray removeObject:@"口碑巡检"];
    }

    if ([permissions containsObject:@"500701"]) {
        [self requestSpotCheckList];
    } else {
        [_sectionArray removeObject:@"在线抽查"];
    }
    
    if ([permissions containsObject:@"500702"]) {
        [self requestLookOnLineList];
    } else {
        [_sectionArray removeObject:@"查看抽查"];
    }

    self.allRankListArray = [NSMutableArray array];
    self.taskListDataArray = [NSMutableArray array];
    self.allQuestionArray = [NSMutableArray array];
    self.allPraiseListArray = [NSMutableArray array];
    self.allExcellentCaseArray = [NSMutableArray array];
    self.allPatrolReportArray = [NSMutableArray array];
    self.allLookOnLineList = [NSMutableArray array];
    self.allSpotCheckList = [NSMutableArray array];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBar.hidden = NO;
    self.tabBarController.tabBar.hidden = YES;
    
}

#pragma mark - Prative Methods
// 更多按钮点击事件
- (void)moreButtonClick:(UIButton *)sender
{
    NSInteger section = sender.tag - 332892;
    UINavigationController *nav;
    if ([_sectionArray[section] isEqualToString:@"在线抽查"]) {
        SpotCheckOnLineViewController *spotOnline = [[SpotCheckOnLineViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:spotOnline];
    } else if ([_sectionArray[section] isEqualToString:@"口碑巡检"]) {
        InspectListViewController *inspectListVC = [[InspectListViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:inspectListVC];
    } else if ([_sectionArray[section] isEqualToString:@"口碑标准"]) {
        StandardViewController *standardVC = [[StandardViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:standardVC];
    } else if ([_sectionArray[section] isEqualToString:@"口碑现场"]) {
        PicCategoryViewController *pictureVC = [[PicCategoryViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:pictureVC];
    } else if ([_sectionArray[section] isEqualToString:@"问题知识"]) {
        QuestionViewController *questionVC = [[QuestionViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:questionVC];
    } else if ([_sectionArray[section] isEqualToString:@"口碑报告"]){
        RankingListViewController *rankingListVC = [[RankingListViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:rankingListVC];
    } else if ([_sectionArray[section] isEqualToString:@"查看抽查"]){
        LookOnLineViewController *lookOnLine = [[LookOnLineViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:lookOnLine];
    } else if ([_sectionArray[section] isEqualToString:@"口碑随手拍"]) {
        PictureViewController *pic = [[PictureViewController alloc] init];
        pic.come = @"首页";
        pic.category = @"store";
        nav = [[UINavigationController alloc] initWithRootViewController:pic];
    }
    
    [nav.navigationBar setBarTintColor:kNavigationBarColor];
    [nav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
    [self presentViewController:nav animated:YES completion:nil];
    
}

#pragma mark - 请求数据
//- (void)requestRankingList
//{
//    
//    NSString *url = [NSString stringWithFormat:@"%@%@", kRedStarURL, kRankingListURL];
//    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:url];
//    NSNumber *pageSize = [[NSUserDefaults standardUserDefaults] objectForKey:@"requestNumber"];
//
//    NSDictionary *parameters = @{@"keyword":self.customStr,
//                                 @"praiseUuid":@"",
//                                 @"statisMode":@(0),
//                                 @"pageNumber":@(0),
//                                 @"pageSize":pageSize
//                                 };
//    
//    [httpCilent getRankingListWithParameters:parameters completion:^(id response, NSError *error) {
//        NSLog(@"口碑报告response = %@", response);
//        NSDictionary *dataDict = response[@"data"];
//        NSArray *dataArray = dataDict[@"records"];
//        
//        NSMutableArray *tgArray = [NSMutableArray array];
//        
//        for (NSDictionary *ListDict in dataArray) {
//            RankListModel *rankList = [RankListModel rankListModelWithDict:ListDict];
//            [tgArray addObject:rankList];
//        }
//        _allRankListArray = (NSMutableArray *)[self sortRankListWithRankListArray:tgArray];
//        
//        for (int i = 0 ; i < _allRankListArray.count; i++) {
//            RankListModel *rank = _allRankListArray[i];
//            if (i == 0) {
//                rank.index = i + 1;
//            } else {
//                RankListModel *prevRank = _allRankListArray[i-1];
//                rank.index = rank.score == prevRank.score ? prevRank.index: i + 1;
//            }
//        }
//        if (_allRankListArray.count != 0) {
//            [_sectionArray addObject:@"口碑报告"];
//        }
//        [self.tableView reloadData];
//        [MBProgressHUD hideHUDForView:self.view animated:YES];
//        
//        
//        
//    }];
//}
//
//- (NSArray *)sortRankListWithRankListArray:(NSMutableArray *)allRanking
//{
//    NSArray *sortedArray = [allRanking sortedArrayUsingComparator:^NSComparisonResult(RankListModel *p1, RankListModel *p2){
//        //return [p2.score compare:p1.score];
//        return [@(p2.score) compare:@(p1.score)];
//        
//    }];
//    return sortedArray;
//}
//
//
//
//- (void)requestInspectList
//{
//    
//    NSString *url = [NSString stringWithFormat:@"%@%@", kRedStarURL, kInspectListURL];
//    NSLog(@"uuuurl = %@", url);
//    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:url];
//    NSNumber *pageSize = [[NSUserDefaults standardUserDefaults] objectForKey:@"requestNumber"];
//    
//    NSDictionary *parameters = @{@"keyword":self.customStr,
//                                 @"userUuid":[[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"],
//                                 @"queryOrders":@[@{@"field":@"lastModifyInfo", @"direction":@"desc"}],
//                                 @"pageNumber":@(0),
//                                 @"pageSize":pageSize
//                                 };
//    NSLog(@"parrrrr = %@", parameters);
//    [httpCilent getInspectListWithParameters:parameters completion:^(id response, NSError *error) {
//        
//        NSLog(@"巡检列表%@", response);
//        NSLog(@"error = %@", error);
//        NSDictionary *dataDict = response[@"data"];
//        NSArray *dataArray = dataDict[@"records"];
//        for (NSDictionary *dict in dataArray) {
//            TaskListModel *taskList = [[TaskListModel alloc] init];
//            [taskList setValuesForKeysWithDictionary:dict];
//            [_taskListDataArray addObject:taskList];
//        }
//        if (_taskListDataArray.count != 0) {
//            [_sectionArray addObject:@"口碑巡检"];
//        }
//        [self.tableView reloadData];
//        [MBProgressHUD hideHUDForView:self.view animated:YES];
//        
//    }];
//    
//}
//
//- (void)requestQuestionList
//{
//    // 初始化数组
//    // 请求地址
//    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
//    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
//    NSNumber *pageSize = [[NSUserDefaults standardUserDefaults] objectForKey:@"requestNumber"];
//    NSDictionary *parameters = @{@"keyword":self.customStr,
//                                 @"user":user_uuid,
//                                 @"scope":@"all",
//                                 @"pageNumber":@(0),
//                                 @"pageSize":pageSize
//                                 };
//    // 发起请求
//    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
//    //
//    
//    // 请求问题列表
//    [httpClient getQuestionListWithParameters:parameters completion:^(id response, NSError *error) {
//        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
//        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
//        NSLog(@"问题与知识列表recods = %@", response);
//        NSLog(@"error = %@", error);
//        for (NSDictionary *questionDict in recordsDict) {
//            QuestionModel *question = [[QuestionModel alloc] init];
//            [question setValuesForKeysWithDictionary:questionDict];
//            [_allQuestionArray addObject:question];
//        }
//        if (_allQuestionArray.count != 0) {
//            [_sectionArray addObject:@"问题知识"];
//        }
//        [self.tableView reloadData];
//        
//        [MBProgressHUD hideHUDForView:self.view animated:YES];
//    }];
//}
//
//- (void)requestPicturePraise
//{
//    
//    // 请求地址
//    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQueryPicturePraiseURL];
//    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
//    NSNumber *pageSize = [[NSUserDefaults standardUserDefaults] objectForKey:@"requestNumber"];
//
//    NSDictionary *parameters = @{
//                                 @"keyword":self.customStr,
//                                 @"scope":@"all",
//                                 @"user":user_uuid,
//                                 @"type":@"store",
//                                 @"pageNumber":@(0),
//                                 @"pageSize":pageSize
//                                 };
//    
//    // 发起请求
//    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
//    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
//    
//    // 请求问题列表
//    [httpClient queryPicturePraiseWithParameters:parameters completion:^(id response, NSError *error) {
//        NSLog(@"口碑现场 response = %@   error = %@" , response, error);
//        NSDictionary *dataDict = response[@"data"];
//        NSArray *dataArray = dataDict[@"records"];
//        NSMutableArray *tempArray = [NSMutableArray array];
//        for (NSDictionary *dict in dataArray) {
//            PictureListModel *picList = [[PictureListModel alloc] init];
//            [picList setValuesForKeysWithDictionary:dict];
//            [tempArray addObject:picList];
//        }
//        _allPraiseListArray = tempArray;
//        if (_allPraiseListArray.count != 0) {
//            [_sectionArray addObject:@"口碑随手拍"];
//        }
//        [self.tableView reloadData];
//        [MBProgressHUD hideHUDForView:self.view animated:YES];
//    }];
//    
//}


#pragma mark - 请求数据
- (void)requestRankingList
{
    
    NSString *url = [NSString stringWithFormat:@"%@%@", kRedStarURL, kRankingListURL];
    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:url];
    NSDictionary *parameters = @{@"praiseUuid":@"",
                                 @"keyword":self.customStr,
                                 @"statisMode":@(0),
                                 @"pageNumber":@(0),
                                 @"pageSize":@(3)
                                 };
    
    [httpCilent getRankingListWithParameters:parameters completion:^(id response, NSError *error) {
        
        
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        
        NSMutableArray *tgArray = [NSMutableArray array];
        
        for (NSDictionary *ListDict in dataArray) {
            RankListModel *rankList = [RankListModel rankListModelWithDict:ListDict];
            [tgArray addObject:rankList];
        }
        _allRankListArray = (NSMutableArray *)[self sortRankListWithRankListArray:tgArray];
        
        for (int i = 0 ; i < _allRankListArray.count; i++) {
            RankListModel *rank = _allRankListArray[i];
            if (i == 0) {
                rank.index = i + 1;
            } else {
                RankListModel *prevRank = _allRankListArray[i-1];
                rank.index = rank.score == prevRank.score ? prevRank.index: i + 1;
            }
        }
        if (_allRankListArray.count == 0) {
            [_sectionArray removeObject:@"口碑报告"];
        }
        
        if (_sectionArray.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            self.noDataView.backgroundColor = [UIColor whiteColor];
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            [self.tableView reloadData];
        }
        
        [MBProgressHUD hideHUDForView:self.view animated:YES];
        
        
        
    }];
}

- (NSArray *)sortRankListWithRankListArray:(NSMutableArray *)allRanking
{
    NSArray *sortedArray = [allRanking sortedArrayUsingComparator:^NSComparisonResult(RankListModel *p1, RankListModel *p2){
        //return [p2.score compare:p1.score];
        return [@(p2.score) compare:@(p1.score)];
        
    }];
    return sortedArray;
}



- (void)requestInspectList
{
    
    NSString *url = [NSString stringWithFormat:@"%@%@", kRedStarURL, kInspectListURL];
    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:url];
    
    
    NSDictionary *parameters = @{
                                 @"userUuid":[[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"],
                                 @"queryOrders":@[@{@"field":@"lastModifyInfo", @"direction":@"desc"}],
                                 @"pageNumber":@(0),
                                 @"keyword":self.customStr,
                                 @"pageSize":@(2)
                                 };
    [httpCilent getInspectListWithParameters:parameters completion:^(id response, NSError *error) {
        
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *dict in dataArray) {
            TaskListModel *taskList = [[TaskListModel alloc] init];
            [taskList setValuesForKeysWithDictionary:dict];
            [tempArray addObject:taskList];
        }
        _taskListDataArray = [NSMutableArray arrayWithArray:tempArray];
        
        if (_taskListDataArray.count == 0) {
            [_sectionArray removeObject:@"口碑巡检"];
        }
        if (_sectionArray.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            self.noDataView.backgroundColor = [UIColor whiteColor];
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            [self.tableView reloadData];
        }
        [MBProgressHUD hideHUDForView:self.view animated:YES];
        
    }];
    
}

- (void)requestQuestionList
{
    // 初始化数组
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    // 请求参数
    NSDictionary *parameters = @{@"user":user_uuid,
                                 @"scope":@"all",
                                 @"pageNumber":@(0),
                                 @"keyword":self.customStr,
                                 @"pageSize":@(2)
                                 };
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    
    // 请求问题列表
    [httpClient getQuestionListWithParameters:parameters completion:^(id response, NSError *error) {
        
        // [self requestInspectList];
        
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *questionDict in recordsDict) {
            QuestionModel *question = [[QuestionModel alloc] init];
            [question setValuesForKeysWithDictionary:questionDict];
            [tempArray addObject:question];
        }
        _allQuestionArray = [NSMutableArray arrayWithArray:tempArray];
        if (_allQuestionArray.count == 0) {
            [_sectionArray removeObject:@"问题知识"];
        }
        if (_sectionArray.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            self.noDataView.backgroundColor = [UIColor whiteColor];
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            [self.tableView reloadData];
        }
        [MBProgressHUD hideHUDForView:self.view animated:YES];
    }];
}


- (void)requestPicturePraiseWithType:(NSString *)type
{
    
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQueryPicturePraiseURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    NSDictionary *parameters = @{
                                 @"scope":@"all",
                                 @"user":user_uuid,
                                 @"type":type,
                                 @"keyword":self.customStr,
                                 @"pageNumber":@(0),
                                 @"pageSize":@(2)
                                 };

    
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    
    // 请求问题列表
    [httpClient queryPicturePraiseWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *dict in dataArray) {
            PictureListModel *picList = [[PictureListModel alloc] init];
            [picList setValuesForKeysWithDictionary:dict];
            [tempArray addObject:picList];
        }
        
        if ([type isEqualToString:@"store"]) {
            _allPraiseListArray = [NSMutableArray arrayWithArray:tempArray];
            if (_allPraiseListArray.count == 0) {
                [_sectionArray removeObject:@"口碑随手拍"];
            }
        } else if ([type isEqualToString:@"casus"]) {
            _allExcellentCaseArray = [NSMutableArray arrayWithArray:tempArray];
            if (_allExcellentCaseArray.count == 0) {
                [_sectionArray removeObject:@"口碑报道"];
            }
        } else {
            _allPatrolReportArray = [NSMutableArray arrayWithArray:tempArray];
            if (_allPatrolReportArray.count == 0) {
                [_sectionArray removeObject:@"口碑巡店"];
            }
        }
        
        if (_sectionArray.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            self.noDataView.backgroundColor = [UIColor whiteColor];
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            [self.tableView reloadData];
        }
        
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];
    }];
    
}

- (void)requestSpotCheckList
{
    HttpClient *http = [[HttpClient alloc] initWithUrl:[NSString stringWithFormat:@"%@%@", kRedStarURL, kManageSportcheckURL]];
    
    // 相关参数
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    NSDictionary *parameters = @{@"userUuid":user_uuid,
                                 @"keyword":self.customStr,
                                 @"pageNumber":@(0),
                                 @"pageSize":@(2)
                                 };
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    [http getManageSportCheckListWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = response[@"data"];
        NSArray *recordsArray = dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];
        
        for (NSDictionary *dict in recordsArray) {
            SpotCheckModel *spot = [[SpotCheckModel alloc] init];
            [spot setValuesForKeysWithDictionary:dict];
            [tempArray addObject:spot];
        }
        _allSpotCheckList = [NSMutableArray arrayWithArray:tempArray];
        
        if (_allSpotCheckList.count == 0) {
            [_sectionArray removeObject:@"在线抽查"];
        }
        
        if (_sectionArray.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            self.noDataView.backgroundColor = [UIColor whiteColor];
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            [self.tableView reloadData];
        }
        
        
        
        [MBProgressHUD hideHUDForView:self.view animated:YES];
    }];
}



- (void)requestLookOnLineList
{
    HttpClient *http = [[HttpClient alloc] initWithUrl:[NSString stringWithFormat:@"%@%@", kRedStarURL, kStoreSportcheckURL]];
    // 相关参数
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    
    NSDictionary *parameters = @{@"userUuid":user_uuid,
                                 @"pageNumber":@(0),
                                 @"keyword":self.customStr,
                                 @"pageSize":@(2)
                                 };
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    [http getStoreSportCheckListWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = response[@"data"];
        NSArray *recordsArray = dataDict[@"records"];
        NSMutableArray *tempArray = [NSMutableArray array];
        
        for (NSDictionary *dict in recordsArray) {
            LookOnLineModel *lookOnline = [[LookOnLineModel alloc] init];
            [lookOnline setValuesForKeysWithDictionary:dict];
            [tempArray addObject:lookOnline];
        }
        _allLookOnLineList = [NSMutableArray arrayWithArray:tempArray];
        
        if (_allLookOnLineList.count == 0) {
            [_sectionArray removeObject:@"查看抽查"];
        }
        
        if (_sectionArray.count == 0) {
            if (_tableView) {
                [_tableView removeFromSuperview];
                _tableView = nil;
            }
            self.noDataView.backgroundColor = [UIColor whiteColor];
        } else {
            if (_noDataView) {
                [_noDataView removeFromSuperview];
                _noDataView = nil;
            }
            [self.tableView reloadData];
        }
        
        [self.tableView reloadData];
        
        [MBProgressHUD hideHUDForView:self.view animated:YES];
    }];
}


// 返回上一页面
- (void)doBack:(UIBarButtonItem *)sender
{
    [self.navigationController popViewControllerAnimated:YES];
}


#pragma mark - TableView Delegate/DataSource
#pragma mark - TableView Delegate/DataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return _sectionArray.count;
}


//- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
//{
//    NSUInteger s2 = [_sectionArray indexOfObject:@"口碑报告"];
//    NSUInteger s4 = [_sectionArray indexOfObject:@"口碑随手拍"];
//    NSUInteger s3 = [_sectionArray indexOfObject:@"问题知识"];
//    NSUInteger s1 = [_sectionArray indexOfObject:@"口碑巡检"];
//    
//    if ([_sectionArray[section] isEqualToString:@"口碑巡检"] && section == s1) {
//        return _taskListDataArray.count;
//    } else if ([_sectionArray[section] isEqualToString:@"口碑报告"] && section == s2) {
//        return _allRankListArray.count + 1;
//    } else if ([_sectionArray[section] isEqualToString:@"问题知识"] && section == s3) {
//        return _allQuestionArray.count;
//    } else if ([_sectionArray[section] isEqualToString:@"口碑随手拍"] && section == s4) {
//        return _allPraiseListArray.count;
//    } else {
//        return 0;
//    }
//}
//
//
//// cell显示的内容
//- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
//{
//    NSUInteger s2 = [_sectionArray indexOfObject:@"口碑报告"];
//    NSUInteger s4 = [_sectionArray indexOfObject:@"商场风采"];
//    NSUInteger s3 = [_sectionArray indexOfObject:@"问题知识"];
//    NSUInteger s1 = [_sectionArray indexOfObject:@"口碑巡检"];
//    
//    if ([_sectionArray[indexPath.section] isEqualToString:@"口碑巡检"] && indexPath.section == s1) {
//        InspectListCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomeInspectListCell];
//        if (!cell) {
//            cell = [[InspectListCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeInspectListCell];
//        }
//        TaskListModel *taskList = _taskListDataArray[indexPath.row];
//        cell.taskList = taskList;
//        cell.selectionStyle = UITableViewCellSelectionStyleNone;
//        cell.allView.backgroundColor = kProgressViewAllBackColor;
//        UIImage *image = [UIImage imageNamed:@"progress-bar"];
//        image = [image resizableImageWithCapInsets:UIEdgeInsetsZero resizingMode:UIImageResizingModeTile];
//        cell.alreadyView.image = image;
//        return cell;
//    } else if ([_sectionArray[indexPath.section] isEqualToString:@"口碑报告"] && indexPath.section == s2) {
//        if (indexPath.row == 0) {
//            HomeTitleTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomeTitleTableCell];
//            if (!cell) {
//                cell = [[HomeTitleTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeTitleTableCell];
//            }
//            cell.selectionStyle = UITableViewCellSelectionStyleNone;
//            return cell;
//        } else {
//            RankingListCell *cell = [tableView dequeueReusableCellWithIdentifier:kHomeRankingListCell];
//            if (!cell) {
//                cell = [[RankingListCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeRankingListCell];
//            }
//            RankListModel *rankList = _allRankListArray[indexPath.row - 1];
//            cell.rankList = rankList;
//            cell.gradeImageView.image = [UIImage imageNamed:[NSString stringWithFormat:@"medal_0%d", rankList.index]];
//            cell.selectionStyle = UITableViewCellSelectionStyleNone;
//            return cell;
//        }
//    } else if ([_sectionArray[indexPath.section] isEqualToString:@"问题知识"] && indexPath.section == s3) {
//        // 问题与知识
//        QuestionListTableCell *cell = [tableView dequeueReusableCellWithIdentifier:kHomeQuestionListTableCell];
//        if (!cell) {
//            cell = [[QuestionListTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeQuestionListTableCell];
//        }
//        cell.selectionStyle = UITableViewCellSelectionStyleNone;
//        QuestionModel *question = _allQuestionArray[indexPath.row];
//        cell.question = question;
//        return cell;
//    } else if ([_sectionArray[indexPath.section] isEqualToString:@"商场风采"] && indexPath.section == s4) {
//        PictureTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomePictureListCell];
//        if (!cell) {
//            cell = [[PictureTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomePictureListCell];
//        }
//        cell.pictureList = _allPraiseListArray[indexPath.row];
//        return cell;
//    } else {
//        return nil;
//    }
//    
//    
//    
//    
//}
//
//// cell点击事件
//- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
//{
//    NSUInteger s2 = [_sectionArray indexOfObject:@"口碑报告"];
//    NSUInteger s4 = [_sectionArray indexOfObject:@"商场风采"];
//    NSUInteger s3 = [_sectionArray indexOfObject:@"问题知识"];
//    NSUInteger s1 = [_sectionArray indexOfObject:@"口碑巡检"];
//    if ([_sectionArray[indexPath.section] isEqualToString:@"口碑巡检"] && indexPath.section == s1) {
//        InspectTaskViewController *inspectTaskVC = [[InspectTaskViewController alloc] init];
//        TaskListModel *taskList = self.taskListDataArray[indexPath.row];
//        inspectTaskVC.uuid = taskList.uuid;
//        inspectTaskVC.store_uuid = taskList.store_uuid;
//        inspectTaskVC.multiplier = (CGFloat)taskList.reportCount / taskList.questionCount ;
//        self.hidesBottomBarWhenPushed = YES;
//        [self.navigationController pushViewController:inspectTaskVC animated:YES];
//    } else if ([_sectionArray[indexPath.section] isEqualToString:@"口碑报告"] && indexPath.section == s2) {
//        if (indexPath.row == 0) {
//            return;
//        }
//        RankListModel *rankList = _allRankListArray[indexPath.row - 1];
//        RankDetailViewController *rankDetailVC = [[RankDetailViewController alloc] init];
//        rankDetailVC.indexRow = rankList.index;
//        rankDetailVC.uuid = rankList.uuid;
//        rankDetailVC.store_uuid = rankList.store_uuid;
//        rankDetailVC.storeAddress = rankList.storeAddress;
//        rankDetailVC.storePictures = rankList.storePictures;
//        self.hidesBottomBarWhenPushed = YES;
//        [self.navigationController pushViewController:rankDetailVC animated:YES];
//    } else if ([_sectionArray[indexPath.section] isEqualToString:@"问题知识"] && indexPath.section == s3) {
//        QuestionDetailViewController *questionDetailVC = [[QuestionDetailViewController alloc] init];
//        QuestionModel *question = self.allQuestionArray[indexPath.row];
//        questionDetailVC.questionUuid = question.uuid;
//        self.hidesBottomBarWhenPushed = YES;
//        [self.navigationController pushViewController:questionDetailVC animated:YES];
//    } else if ([_sectionArray[indexPath.section] isEqualToString:@"商场风采"] && indexPath.section == s4) {
//        PictureListModel *picList = _allPraiseListArray[indexPath.row];
//        PictureStoryViewController *storyVC = [[PictureStoryViewController alloc] init];
//        storyVC.uuid = picList.uuid;
//        self.hidesBottomBarWhenPushed = YES;
//        [self.navigationController pushViewController:storyVC animated:YES];
//    } else {
//        return;
//    }
//}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSUInteger s2 = [_sectionArray indexOfObject:@"口碑报告"];
    NSUInteger s4 = [_sectionArray indexOfObject:@"口碑随手拍"];
    NSUInteger s3 = [_sectionArray indexOfObject:@"问题知识"];
    NSUInteger s1 = [_sectionArray indexOfObject:@"口碑巡检"];
    NSUInteger s5 = [_sectionArray indexOfObject:@"口碑报道"];
    NSUInteger s6 = [_sectionArray indexOfObject:@"口碑巡店"];
    NSUInteger s7 = [_sectionArray indexOfObject:@"在线抽查"];
    NSUInteger s8 = [_sectionArray indexOfObject:@"查看抽查"];
    
    if ([_sectionArray[section] isEqualToString:@"口碑巡检"] && section == s1) {
        return _taskListDataArray.count;
    } else if ([_sectionArray[section] isEqualToString:@"口碑报告"] && section == s2) {
        return _allRankListArray.count + 1;
    } else if ([_sectionArray[section] isEqualToString:@"问题知识"] && section == s3) {
        return _allQuestionArray.count;
    } else if ([_sectionArray[section] isEqualToString:@"口碑随手拍"] && section == s4) {
        return _allPraiseListArray.count;
    } else if ([_sectionArray[section] isEqualToString:@"口碑报道"] && section == s5) {
        return _allExcellentCaseArray.count;
    } else if ([_sectionArray[section] isEqualToString:@"口碑巡店"] && section == s6) {
        return _allPatrolReportArray.count;
    } else if ([_sectionArray[section] isEqualToString:@"在线抽查"] && section == s7) {
        return _allSpotCheckList.count;
    } else if ([_sectionArray[section] isEqualToString:@"查看抽查"] && section == s8) {
        return _allLookOnLineList.count;
    } else {
        return 0;
    }
}


// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSUInteger s2 = [_sectionArray indexOfObject:@"口碑报告"];
    NSUInteger s4 = [_sectionArray indexOfObject:@"口碑随手拍"];
    NSUInteger s3 = [_sectionArray indexOfObject:@"问题知识"];
    NSUInteger s1 = [_sectionArray indexOfObject:@"口碑巡检"];
    NSUInteger s5 = [_sectionArray indexOfObject:@"口碑报道"];
    NSUInteger s6 = [_sectionArray indexOfObject:@"口碑巡店"];
    NSUInteger s7 = [_sectionArray indexOfObject:@"在线抽查"];
    NSUInteger s8 = [_sectionArray indexOfObject:@"查看抽查"];
    
    if ([_sectionArray[indexPath.section] isEqualToString:@"口碑巡检"] && indexPath.section == s1) {
        InspectListCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomeInspectListCell];
        if (!cell) {
            cell = [[InspectListCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeInspectListCell];
        }
        TaskListModel *taskList = _taskListDataArray[indexPath.row];
        cell.taskList = taskList;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.allView.backgroundColor = kProgressViewAllBackColor;
        UIImage *image = [UIImage imageNamed:@"progress-bar"];
        image = [image resizableImageWithCapInsets:UIEdgeInsetsZero resizingMode:UIImageResizingModeTile];
        cell.alreadyView.image = image;
        return cell;
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"口碑报告"] && indexPath.section == s2) {
        if (indexPath.row == 0) {
            HomeTitleTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomeTitleTableCell];
            if (!cell) {
                cell = [[HomeTitleTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeTitleTableCell];
            }
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            return cell;
        } else {
            RankingListCell *cell = [tableView dequeueReusableCellWithIdentifier:kHomeRankingListCell];
            if (!cell) {
                cell = [[RankingListCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeRankingListCell];
            }
            for (int i = 0 ; i < _allRankListArray.count; i++) {
                RankListModel *rank = _allRankListArray[i];
                if (i == 0) {
                    rank.index = i + 1;
                } else {
                    RankListModel *prevRank = _allRankListArray[i-1];
                    rank.index = rank.score == prevRank.score ? prevRank.index: i + 1;
                }
            }
            RankListModel *rankList = _allRankListArray[indexPath.row - 1];
            cell.rankList = rankList;
            cell.gradeImageView.image = [UIImage imageNamed:[NSString stringWithFormat:@"medal_0%d", rankList.index]];
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            return cell;
        }
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"问题知识"] && indexPath.section == s3) {
        // 问题与知识
        QuestionListTableCell *cell = [tableView dequeueReusableCellWithIdentifier:kHomeQuestionListTableCell];
        if (!cell) {
            cell = [[QuestionListTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeQuestionListTableCell];
        }
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        QuestionModel *question = _allQuestionArray[indexPath.row];
        cell.question = question;
        return cell;
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"口碑随手拍"] && indexPath.section == s4) {
        PictureTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomePictureListCell];
        if (!cell) {
            cell = [[PictureTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomePictureListCell];
        }
        cell.pictureList = _allPraiseListArray[indexPath.row];
        return cell;
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"口碑报道"] && indexPath.section == s5) {
        PictureTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomePictureListCell];
        if (!cell) {
            cell = [[PictureTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomePictureListCell];
        }
        cell.pictureList = _allExcellentCaseArray[indexPath.row];
        return cell;
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"口碑巡店"] && indexPath.section == s6) {
        PictureTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomePictureListCell];
        if (!cell) {
            cell = [[PictureTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomePictureListCell];
        }
        cell.pictureList = _allPatrolReportArray[indexPath.row];
        return cell;
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"在线抽查"] && indexPath.section == s7) {
        SpotCheckTableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kSearchSpotCehcekCell];
        if (!cell) {
            cell = [[SpotCheckTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kSearchSpotCehcekCell];
        }
        cell.spotCheck = _allSpotCheckList[indexPath.row];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        
        return cell;
        
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"查看抽查"] && indexPath.section == s8) {
        LookOnLineTableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kSearchLookOnLineCell];
        if (!cell) {
            cell = [[LookOnLineTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kSearchLookOnLineCell];
        }
        cell.lookOnLine = _allLookOnLineList[indexPath.row];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    }  else {
        return nil;
    }
    
    
    
    
}

// cell点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSUInteger s2 = [_sectionArray indexOfObject:@"口碑报告"];
    NSUInteger s4 = [_sectionArray indexOfObject:@"口碑随手拍"];
    NSUInteger s3 = [_sectionArray indexOfObject:@"问题知识"];
    NSUInteger s1 = [_sectionArray indexOfObject:@"口碑巡检"];
    NSUInteger s5 = [_sectionArray indexOfObject:@"口碑报道"];
    NSUInteger s6 = [_sectionArray indexOfObject:@"口碑巡店"];
    NSUInteger s7 = [_sectionArray indexOfObject:@"在线抽查"];
    NSUInteger s8 = [_sectionArray indexOfObject:@"查看抽查"];
    if ([_sectionArray[indexPath.section] isEqualToString:@"口碑巡检"] && indexPath.section == s1) {
        InspectTaskViewController *inspectTaskVC = [[InspectTaskViewController alloc] init];
        TaskListModel *taskList = self.taskListDataArray[indexPath.row];
        inspectTaskVC.uuid = taskList.uuid;
        inspectTaskVC.store_uuid = taskList.store_uuid;
        inspectTaskVC.multiplier = (CGFloat)taskList.reportCount / taskList.questionCount ;
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:inspectTaskVC animated:YES];
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"口碑报告"] && indexPath.section == s2) {
        if (indexPath.row == 0) {
            return;
        }
        RankListModel *rankList = _allRankListArray[indexPath.row - 1];
        RankDetailViewController *rankDetailVC = [[RankDetailViewController alloc] init];
        rankDetailVC.indexRow = rankList.index;
        rankDetailVC.uuid = rankList.uuid;
        rankDetailVC.store_uuid = rankList.store_uuid;
        rankDetailVC.storeAddress = rankList.storeAddress;
        rankDetailVC.storePictures = rankList.storePictures;
        rankDetailVC.commentId = rankList.commentId;
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:rankDetailVC animated:YES];
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"问题知识"] && indexPath.section == s3) {
        QuestionDetailViewController *questionDetailVC = [[QuestionDetailViewController alloc] init];
        QuestionModel *question = self.allQuestionArray[indexPath.row];
        questionDetailVC.questionUuid = question.uuid;
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:questionDetailVC animated:YES];
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"口碑随手拍"] && indexPath.section == s4) {
        PictureListModel *picList = _allPraiseListArray[indexPath.row];
        PictureStoryViewController *storyVC = [[PictureStoryViewController alloc] init];
        storyVC.uuid = picList.uuid;
        storyVC.titleStr = @"口碑随手拍";
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:storyVC animated:YES];
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"口碑报道"] && indexPath.section == s5) {
        PictureListModel *picList = _allExcellentCaseArray[indexPath.row];
        PictureStoryViewController *storyVC = [[PictureStoryViewController alloc] init];
        storyVC.uuid = picList.uuid;
        storyVC.titleStr = @"口碑报道";
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:storyVC animated:YES];
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"口碑巡店"] && indexPath.section == s6) {
        PictureListModel *picList = _allPatrolReportArray[indexPath.row];
        PictureStoryViewController *storyVC = [[PictureStoryViewController alloc] init];
        storyVC.uuid = picList.uuid;
        storyVC.titleStr = @"口碑巡店";
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:storyVC animated:YES];
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"在线抽查"] && indexPath.section == s7) {
        SpotCheckModel *spot = _allSpotCheckList[indexPath.row];
        OnLineCompleteViewController *completeVC = [[OnLineCompleteViewController alloc] init];
        completeVC.uuid = spot.uuid;
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:completeVC animated:YES];
    } else if ([_sectionArray[indexPath.section] isEqualToString:@"查看抽查"] && indexPath.section == s8) {
        LookOnLineModel *lookOnLine = _allLookOnLineList[indexPath.row];
        LookOnLineDetailViewController *lookDetailVC = [[LookOnLineDetailViewController alloc] init];
        lookDetailVC.lookOnLine = lookOnLine;
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:lookDetailVC animated:YES];
    }  else {
        return;
    }
}



// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 36;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 10;
}

// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    
    // 创建sectionView
    UIView *sectionView = [[UIView alloc] init];
    sectionView.userInteractionEnabled = YES;
    sectionView.backgroundColor = [UIColor whiteColor];
    
    UIView *lineView = [[UIView alloc] init];
    lineView.translatesAutoresizingMaskIntoConstraints = NO;
    lineView.backgroundColor = kSeparateLineColor;
    [sectionView addSubview:lineView];
    
    NSLayoutConstraint *lineTop = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:lineTop];
    
    NSLayoutConstraint *lineLeft = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:lineLeft];
    
    NSLayoutConstraint *lineRight = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [sectionView addConstraint:lineRight];
    
    NSLayoutConstraint *lineHeight = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:0.5];
    [sectionView addConstraint:lineHeight];
    
    // 创建标题label
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    titleLabel.textColor = kPictureCellDetailsColor;
    titleLabel.font = [UIFont systemFontOfSize:17.0];
    titleLabel.text = _sectionArray[section];
    
    
    [sectionView addSubview:titleLabel];
    
    
    // 查看更多按钮
    UIButton *moreButton = [[UIButton alloc] init];
    moreButton.tag = 332892 + section;
    moreButton.translatesAutoresizingMaskIntoConstraints = NO;
    [moreButton setTitle:@"更多" forState:UIControlStateNormal];
    [moreButton setTitleColor:kMoreButtonTextColor forState:UIControlStateNormal];
    [moreButton addTarget:self action:@selector(moreButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    moreButton.titleLabel.font = [UIFont systemFontOfSize:13.0];
    [sectionView addSubview:moreButton];
    
    // 箭头Iamge
    UIImageView *arrowIamgeView = [[UIImageView alloc] init];
    arrowIamgeView.image = [UIImage imageNamed:@"arrow_right"];
    arrowIamgeView.translatesAutoresizingMaskIntoConstraints = NO;
    [sectionView addSubview:arrowIamgeView];
    
    NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:3];
    [sectionView addConstraint:titleLabelTop];
    
    NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [sectionView addConstraint:titleLabelLeft];
    
    NSLayoutConstraint *titleLabelRight = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:moreButton attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:titleLabelRight];
    
    NSLayoutConstraint *titleLabelBottom = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:titleLabelBottom];
    
    
    
    
    
    // moreButton布局
    NSLayoutConstraint *moreButtonTop = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:3];
    [sectionView addConstraint:moreButtonTop];
    
    NSLayoutConstraint *moreButtonRight = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:arrowIamgeView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:moreButtonRight];
    
    NSLayoutConstraint *moreButtonWidth = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:35];
    [sectionView addConstraint:moreButtonWidth];
    
    NSLayoutConstraint *moreButtonBottom = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:moreButtonBottom];
    
    // arrowIamgeView布局
    NSLayoutConstraint *arrowIamgeViewTop = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:13];
    [sectionView addConstraint:arrowIamgeViewTop];
    
    NSLayoutConstraint *arrowIamgeViewRight = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
    [sectionView addConstraint:arrowIamgeViewRight];
    
    NSLayoutConstraint *arrowIamgeViewWidth = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:7];
    [sectionView addConstraint:arrowIamgeViewWidth];
    
    NSLayoutConstraint *arrowIamgeViewHeight = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:12];
    [sectionView addConstraint:arrowIamgeViewHeight];
    
    
    return sectionView;
}


- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 300.0;
        _tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 40)];
        [_tableView registerClass:[PictureTableCell class] forCellReuseIdentifier:kHomePictureListCell];
        [_tableView registerClass:[HomeTitleTableCell class] forCellReuseIdentifier:kHomeTitleTableCell];
        [_tableView registerClass:[RankingListCell class] forCellReuseIdentifier:kHomeRankingListCell];
        [_tableView registerClass:[QuestionListTableCell class] forCellReuseIdentifier:kHomeQuestionListTableCell];
        [_tableView registerClass:[SpotCheckTableViewCell class] forCellReuseIdentifier:kSearchSpotCehcekCell];
        [_tableView registerClass:[LookOnLineTableViewCell class] forCellReuseIdentifier:kSearchLookOnLineCell];

        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}


- (NoDataView *)noDataView
{
    if (!_noDataView) {
        _noDataView = [[NoDataView alloc] init];
        _noDataView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.view addSubview:_noDataView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:45];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_noDataView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _noDataView;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
