//
//  RankDetailView.m
//  redstar
//
//  Created by admin on 15/11/12.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankDetailView.h"

@interface RankDetailView ()
@property (nonatomic, strong) UIView *lineView1;
@property (nonatomic, strong) UIView *lineView2;

@property (nonatomic, strong) UIView *uplineView;
@property (nonatomic, strong) UIView *downlineView;

@end

@implementation RankDetailView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

#pragma mark - Private Methods
- (void)setup
{
    self.addressLabel.font = [UIFont systemFontOfSize:14.0];
    self.titleLabel.font = [UIFont systemFontOfSize:17.0];
    self.reportTimeLabel.font = [UIFont systemFontOfSize:14.0];
    self.lineView1.backgroundColor = kSeparateLineColor;
    self.totalScoreLabel.font =  [UIFont systemFontOfSize:14.0];
    self.lineView2.backgroundColor = kSeparateLineColor;
    self.totalGradeLabel.font = [UIFont systemFontOfSize:14.0];
    self.timeLabel.font = [UIFont systemFontOfSize:16.0];
    
    self.scoreLabel.font = [UIFont systemFontOfSize:17.0];
    self.gradeView.backgroundColor = [UIColor clearColor];
    
    self.uplineView.backgroundColor = kSeparateLineColor;
    self.downlineView.backgroundColor = kSeparateLineColor;

}

#pragma mark - Lazy Loading
- (UILabel *)addressLabel
{
    if (!_addressLabel) {
        _addressLabel = [[UILabel alloc] init];
        _addressLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _addressLabel.textColor = kDetailSmallTitleColor;
        [self addSubview:_addressLabel];
        
        NSLayoutConstraint *addressTop = [NSLayoutConstraint constraintWithItem:_addressLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [self addConstraint:addressTop];
        
        NSLayoutConstraint *addressLeft = [NSLayoutConstraint constraintWithItem:_addressLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:addressLeft];
        
        NSLayoutConstraint *addressRight = [NSLayoutConstraint constraintWithItem:_addressLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:addressRight];
        
        NSLayoutConstraint *addressHeight = [NSLayoutConstraint constraintWithItem:_addressLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
        [self addConstraint:addressHeight];
        
    }
    return _addressLabel;
}

- (UIScrollView *)showScrollView
{
    if (!_showScrollView) {
        _showScrollView = [[UIScrollView alloc] initWithFrame:CGRectMake(20, 41, kScreenWidth - 40, 70)];
        _showScrollView.showsHorizontalScrollIndicator = NO;
        _showScrollView.showsVerticalScrollIndicator = NO;
        [self addSubview:_showScrollView];
        
//        NSLayoutConstraint *showTop = [NSLayoutConstraint constraintWithItem:_showScrollView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.addressLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
//        [self addConstraint:showTop];
//        
//        NSLayoutConstraint *showLeft = [NSLayoutConstraint constraintWithItem:_showScrollView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
//        [self addConstraint:showLeft];
//        
//        NSLayoutConstraint *showRight = [NSLayoutConstraint constraintWithItem:_showScrollView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
//        [self addConstraint:showRight];
//        
//        NSLayoutConstraint *showHeight = [NSLayoutConstraint constraintWithItem:_showScrollView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:70];
//        [self addConstraint:showHeight];
    }
    return _showScrollView;
}

- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _titleLabel.textColor = kDetailBigTitleColor;
        [self addSubview:_titleLabel];
        
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.showScrollView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:7];
        [self addConstraint:titleTop];
        
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:titleLeft];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:titleRight];
        
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:23];
        [self addConstraint:titleHeight];
    }
    return _titleLabel;
}

- (UILabel *)reportTimeLabel
{
    if (!_reportTimeLabel) {
        _reportTimeLabel = [[UILabel alloc] init];
        _reportTimeLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _reportTimeLabel.textColor = kDetailSmallTitleColor;
        [self addSubview:_reportTimeLabel];
        
        NSLayoutConstraint *reportTop = [NSLayoutConstraint constraintWithItem:_reportTimeLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:10];
        [self addConstraint:reportTop];
        
        NSLayoutConstraint *reportLeft = [NSLayoutConstraint constraintWithItem:_reportTimeLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:reportLeft];
        
        NSLayoutConstraint *reportRight = [NSLayoutConstraint constraintWithItem:_reportTimeLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.lineView1 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:reportRight];
        
        NSLayoutConstraint *reportHeight = [NSLayoutConstraint constraintWithItem:_reportTimeLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self addConstraint:reportHeight];
        
        NSLayoutConstraint *reportWidth = [NSLayoutConstraint constraintWithItem:_reportTimeLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.totalScoreLabel attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self addConstraint:reportWidth];
    }
    return _reportTimeLabel;
}

- (UIView *)lineView1
{
    if (!_lineView1) {
        _lineView1 = [[UIView alloc] init];
        _lineView1.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_lineView1];
        
        NSLayoutConstraint *lineView1Top = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:12];
        [self addConstraint:lineView1Top];
        
        NSLayoutConstraint *lineView1Bottom = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-12];
        [self addConstraint:lineView1Bottom];
        
        NSLayoutConstraint *lineView1Right = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.totalScoreLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:lineView1Right];
        
        NSLayoutConstraint *lineView1Width = [NSLayoutConstraint constraintWithItem:_lineView1 attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:1];
        [self addConstraint:lineView1Width];
    }
    return _lineView1;
}

- (UILabel *)totalScoreLabel
{
    if (!_totalScoreLabel) {
        _totalScoreLabel = [[UILabel alloc] init];
        _totalScoreLabel.textAlignment = NSTextAlignmentCenter;
        _totalScoreLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _totalScoreLabel.textColor = kDetailSmallTitleColor;
        [self addSubview:_totalScoreLabel];
        
        NSLayoutConstraint *reportTop = [NSLayoutConstraint constraintWithItem:_totalScoreLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:10];
        [self addConstraint:reportTop];
        
        NSLayoutConstraint *reportRight = [NSLayoutConstraint constraintWithItem:_totalScoreLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.lineView2 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:reportRight];
        
        NSLayoutConstraint *reportHeight = [NSLayoutConstraint constraintWithItem:_totalScoreLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self addConstraint:reportHeight];
        
        NSLayoutConstraint *reportWidth = [NSLayoutConstraint constraintWithItem:_totalScoreLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.totalGradeLabel attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self addConstraint:reportWidth];
    }
    return _totalScoreLabel;
}

- (UIView *)lineView2
{
    if (!_lineView2) {
        _lineView2 = [[UIView alloc] init];
        _lineView2.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_lineView2];
        
        NSLayoutConstraint *lineView2Top = [NSLayoutConstraint constraintWithItem:_lineView2 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:12];
        [self addConstraint:lineView2Top];
        
        NSLayoutConstraint *lineView2Bottom = [NSLayoutConstraint constraintWithItem:_lineView2 attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-12];
        [self addConstraint:lineView2Bottom];
        
        NSLayoutConstraint *lineView2Right = [NSLayoutConstraint constraintWithItem:_lineView2 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.totalGradeLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:lineView2Right];
        
        NSLayoutConstraint *lineView2Width = [NSLayoutConstraint constraintWithItem:_lineView2 attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:1];
        [self addConstraint:lineView2Width];
    }
    return _lineView2;
}

- (UILabel *)totalGradeLabel
{
    if (!_totalGradeLabel) {
        _totalGradeLabel = [[UILabel alloc] init];
        _totalGradeLabel.textAlignment = NSTextAlignmentCenter;
        _totalGradeLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _totalGradeLabel.textColor = kDetailSmallTitleColor;
        [self addSubview:_totalGradeLabel];
        
        NSLayoutConstraint *totalGradeTop = [NSLayoutConstraint constraintWithItem:_totalGradeLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:10];
        [self addConstraint:totalGradeTop];
        
        NSLayoutConstraint *totalGradeRight = [NSLayoutConstraint constraintWithItem:_totalGradeLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:totalGradeRight];
        
        NSLayoutConstraint *totalGradeHeight = [NSLayoutConstraint constraintWithItem:_totalGradeLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self addConstraint:totalGradeHeight];
    }
    return _totalGradeLabel;
}

- (UILabel *)timeLabel
{
    if (!_timeLabel) {
        _timeLabel = [[UILabel alloc] init];
        _timeLabel.textColor = kDetailBigTitleColor;
        _timeLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_timeLabel];
        
        NSLayoutConstraint *timeTop = [NSLayoutConstraint constraintWithItem:_timeLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:_reportTimeLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:timeTop];
        
        NSLayoutConstraint *timeLeft = [NSLayoutConstraint constraintWithItem:_timeLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:timeLeft];
        
        NSLayoutConstraint *timeRight = [NSLayoutConstraint constraintWithItem:_timeLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.lineView1 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:timeRight];
        
        NSLayoutConstraint *timeHeight = [NSLayoutConstraint constraintWithItem:_timeLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self addConstraint:timeHeight];
    }
    return _timeLabel;
}

- (UILabel *)scoreLabel
{
    if (!_scoreLabel) {
        _scoreLabel = [[UILabel alloc] init];
        _scoreLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _scoreLabel.textColor = kNavigationBarColor;
        _scoreLabel.textAlignment = NSTextAlignmentCenter;
        [self addSubview:_scoreLabel];
        
        NSLayoutConstraint *scoreTop = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:_totalScoreLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:scoreTop];
        
        NSLayoutConstraint *scoreRight = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.lineView2 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:scoreRight];
        
        NSLayoutConstraint *scoreHeight = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self addConstraint:scoreHeight];
        
        NSLayoutConstraint *scoreWidth = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:_totalScoreLabel attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self addConstraint:scoreWidth];
        
    }
    return _scoreLabel;
}

- (UIView *)gradeView
{
    if (!_gradeView) {
        _gradeView = [[UIView alloc] init];
        _gradeView.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_gradeView];
        
        NSLayoutConstraint *totalGradeTop = [NSLayoutConstraint constraintWithItem:_gradeView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.totalGradeLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:totalGradeTop];
        
        NSLayoutConstraint *totalGradeLeft = [NSLayoutConstraint constraintWithItem:_gradeView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:_lineView2 attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:totalGradeLeft];
        
        
        NSLayoutConstraint *totalGradeRight = [NSLayoutConstraint constraintWithItem:_gradeView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:totalGradeRight];
        
        NSLayoutConstraint *totalGradeBottom = [NSLayoutConstraint constraintWithItem:_gradeView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:totalGradeBottom];
    }
    return _gradeView;
}

- (UILabel *)gradeLabel
{
    if (!_gradeLabel) {
        _gradeLabel = [[UILabel alloc] init];
        _gradeLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _gradeLabel.textAlignment = NSTextAlignmentCenter;
        [self.gradeView addSubview:_gradeLabel];
        
        //
        NSLayoutConstraint *gradeTop = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.gradeView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.gradeView addConstraint:gradeTop];
        
        NSLayoutConstraint *gradeRight = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.gradeView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.gradeView addConstraint:gradeRight];
        
        NSLayoutConstraint *gradeHeight = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.gradeView addConstraint:gradeHeight];
        
        NSLayoutConstraint *gradeLeft = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.gradeView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.gradeView addConstraint:gradeLeft];
    }
    return _gradeLabel;
}

- (UIImageView *)gradeImageView
{
    if (!_gradeImageView) {
        _gradeImageView = [[UIImageView alloc] init];
        _gradeImageView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.gradeView addSubview:_gradeImageView];
        
        //
        NSLayoutConstraint *gradeCenterX = [NSLayoutConstraint constraintWithItem:_gradeImageView attribute:NSLayoutAttributeCenterX relatedBy:NSLayoutRelationEqual toItem:self.gradeView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:0];
        [self.gradeView addConstraint:gradeCenterX];
        
        NSLayoutConstraint *gradeCenterY = [NSLayoutConstraint constraintWithItem:_gradeImageView attribute:NSLayoutAttributeCenterY relatedBy:NSLayoutRelationEqual toItem:self.gradeView attribute:NSLayoutAttributeCenterY multiplier:1.0 constant:0];
        [self.gradeView addConstraint:gradeCenterY];
        
        NSLayoutConstraint *gradeWidth = [NSLayoutConstraint constraintWithItem:_gradeImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:35];
        [self.gradeView addConstraint:gradeWidth];
        
        NSLayoutConstraint *gradeHeight = [NSLayoutConstraint constraintWithItem:_gradeImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:34];
        [self.gradeView addConstraint:gradeHeight];
    }
    return _gradeImageView;
}

- (UIView *)uplineView
{
    if (!_uplineView) {
        _uplineView = [[UIView alloc] init];
        _uplineView.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_uplineView];
        
        NSLayoutConstraint *lineView1Top = [NSLayoutConstraint constraintWithItem:_uplineView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self addConstraint:lineView1Top];
        
        NSLayoutConstraint *lineView1Height = [NSLayoutConstraint constraintWithItem:_uplineView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:1];
        [self addConstraint:lineView1Height];
        
        NSLayoutConstraint *lineView1Right = [NSLayoutConstraint constraintWithItem:_uplineView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:lineView1Right];
        
        NSLayoutConstraint *lineView1Left = [NSLayoutConstraint constraintWithItem:_uplineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:lineView1Left];;
    }
    return _uplineView;
}

- (UIView *)downlineView
{
    if (!_downlineView) {
        _downlineView = [[UIView alloc] init];
        _downlineView.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_downlineView];
        
        NSLayoutConstraint *lineView1Bottom = [NSLayoutConstraint constraintWithItem:_downlineView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:lineView1Bottom];
        
        NSLayoutConstraint *lineView1Height = [NSLayoutConstraint constraintWithItem:_downlineView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:1];
        [self addConstraint:lineView1Height];
        
        NSLayoutConstraint *lineView1Right = [NSLayoutConstraint constraintWithItem:_downlineView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:lineView1Right];
        
        NSLayoutConstraint *lineView1Left = [NSLayoutConstraint constraintWithItem:_downlineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:lineView1Left];;
    }
    return _downlineView;
}


@end
