//
//  RankSectionTableCell.m
//  redstar
//
//  Created by admin on 15/12/25.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankSectionTableCell.h"

@implementation RankSectionTableCell




- (UILabel *)categoryLabel
{
    if (!_categoryLabel) {
        _categoryLabel = [[UILabel alloc] init];
        _categoryLabel.font = [UIFont systemFontOfSize:17.0];
        _categoryLabel.textColor = kLightBlack;
        _categoryLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_categoryLabel];
        
        NSLayoutConstraint *shoppingTop = [NSLayoutConstraint constraintWithItem:_categoryLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:shoppingTop];
        
        NSLayoutConstraint *shoppingLeft = [NSLayoutConstraint constraintWithItem:_categoryLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:shoppingLeft];
        
        NSLayoutConstraint *shoppingHeight = [NSLayoutConstraint constraintWithItem:_categoryLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
        [self.contentView addConstraint:shoppingHeight];
        
        NSLayoutConstraint *shoppingBottom = [NSLayoutConstraint constraintWithItem:_categoryLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:shoppingBottom];
    }
    return _categoryLabel;
}


- (UILabel *)gradeLabel
{
    if (!_gradeLabel) {
        _gradeLabel = [[UILabel alloc] init];
        _gradeLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_gradeLabel];
        
        NSLayoutConstraint *shoppingTop = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:shoppingTop];
        
        NSLayoutConstraint *shoppingLeft = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.arrowImageView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:shoppingLeft];
        
        NSLayoutConstraint *shoppingWidth = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
        [self.contentView addConstraint:shoppingWidth];
        
        NSLayoutConstraint *shoppingBottom = [NSLayoutConstraint constraintWithItem:_gradeLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:shoppingBottom];
    }
    return _gradeLabel;
}


- (UILabel *)scoreLabel
{
    if (!_scoreLabel) {
        _scoreLabel = [[UILabel alloc] init];
        _scoreLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_scoreLabel];
        
        NSLayoutConstraint *shoppingTop = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:shoppingTop];
        
        NSLayoutConstraint *shoppingLeft = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.gradeLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:shoppingLeft];
        
        NSLayoutConstraint *shoppingWidth = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
        [self.contentView addConstraint:shoppingWidth];
        
        NSLayoutConstraint *shoppingBottom = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:shoppingBottom];
    }
    return _scoreLabel;
}

- (UIImageView *)arrowImageView
{
    if (!_arrowImageView) {
        _arrowImageView = [[UIImageView alloc] init];
        _arrowImageView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_arrowImageView];
        
        NSLayoutConstraint *shoppingTop = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:20];
        [self.contentView addConstraint:shoppingTop];
        
        NSLayoutConstraint *shoppingRight = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:shoppingRight];
        
        NSLayoutConstraint *shoppingWidth = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:12.5];
        [self.contentView addConstraint:shoppingWidth];
        
        NSLayoutConstraint *shoppingHeight = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:7.5];
        [self.contentView addConstraint:shoppingHeight];
    }
    return _arrowImageView;
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
