//
//  RankScrollTableViewCell.m
//  redstar
//
//  Created by admin on 15/12/25.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankScrollTableViewCell.h"
#import <UIButton+WebCache.h>


@implementation RankScrollTableViewCell

- (UIScrollView *)scrollView
{
    if (!_scrollView) {
        _scrollView = [[UIScrollView alloc] init];
        _scrollView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_scrollView];
        
        NSLayoutConstraint *someoneTop = [NSLayoutConstraint constraintWithItem:_scrollView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
        [self.contentView addConstraint:someoneTop];
        
        NSLayoutConstraint *someoneLeft = [NSLayoutConstraint constraintWithItem:_scrollView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:someoneLeft];
        
        NSLayoutConstraint *someoneRight = [NSLayoutConstraint constraintWithItem:_scrollView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:someoneRight];
        
        NSLayoutConstraint *someoneHeight = [NSLayoutConstraint constraintWithItem:_scrollView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self.contentView addConstraint:someoneHeight];
        
        NSLayoutConstraint *someoneBottom = [NSLayoutConstraint constraintWithItem:_scrollView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-5];
        [self.contentView addConstraint:someoneBottom];

    }
    return _scrollView;
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
}

@end
