//
//  InspectUploadedViewController.m
//  redstar
//
//  Created by admin on 15/11/24.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "InspectUploadedViewController.h"
#import "InspectNotUpLoadCell.h"
#import "InspectUpLoadFootView.h"
#import "CheckPicViewController.h"
#import "LargePictureViewController.h"

#define kInspectnotLoadTableViewCell @"InspectnotLoadTableViewCell"
#define kInspectReferencePicCell @"InspectReferencePiccell"

@interface InspectUploadedViewController ()<UITableViewDelegate, UITableViewDataSource,InspectUpLoadFootDelegate>

@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) InspectUpLoadFootView *footerView;

@property (nonatomic, strong) NSMutableArray *allImageURL;

@end

@implementation InspectUploadedViewController

- (void)viewDidLoad {
    [super viewDidLoad];

    self.view.backgroundColor = kSectionBackGroundColor;
    
    self.allImageURL = [NSMutableArray array];
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    customLab.textAlignment = NSTextAlignmentCenter;
    [customLab setText:[NSString stringWithFormat:@"检查点--%@(%d/%d)", self.catesgory, self.reportCount, self.questionCount]];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
    
    
    [self.tableView registerClass:[InspectNotUpLoadCell class] forCellReuseIdentifier:kInspectnotLoadTableViewCell];
    self.tableView.tableFooterView = self.footerView;
    _tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    
    
    for (int i = 0; i < self.taskModel.answerAttachments.count; i++) {
        NSDictionary *dict = (NSDictionary *)self.taskModel.answerAttachments[i];
        NSURL *imageUrl = [NSURL URLWithString:[NSString stringWithFormat:@"%@%@", kRedStarURL ,dict[@"fileUrl"]]];
        [_allImageURL addObject:imageUrl];
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - private Methods
// 返回上一页面
- (void)doBack:(UIBarButtonItem *)sender
{
    [self.navigationController popViewControllerAnimated:YES];
}



#pragma mark - TableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 1;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    InspectNotUpLoadCell *cell=[tableView dequeueReusableCellWithIdentifier:kInspectnotLoadTableViewCell];
    if (!cell) {
        cell = [[InspectNotUpLoadCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kInspectnotLoadTableViewCell];
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.titleLabel.text = [NSString stringWithFormat:@"%@", _taskModel.title];
    cell.titleDetailLabel.text = [NSString stringWithFormat:@"要求图片%d张", _taskModel.attachmentNumber];
    cell.introLabel.text = @"参考说明";
    NSString *refrer = [NSString stringWithFormat:@"%@", _taskModel.reference];
    if (refrer == nil || refrer == NULL || [refrer isEqual:[NSNull null]] || refrer == Nil || [refrer isEqualToString:@"(null)"]) {
        cell.introDetailLabel.text = @"";
    } else {
        NSString *str = [NSString stringWithFormat:@"<style> html{ font-size: 15px; color: #444444 } </style>%@", _taskModel.reference];
        NSAttributedString * attrStr = [[NSAttributedString alloc] initWithData:[str dataUsingEncoding:NSUnicodeStringEncoding] options:@{ NSDocumentTypeDocumentAttribute: NSHTMLTextDocumentType ,NSForegroundColorAttributeName:kLightBlack,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} documentAttributes:nil error:nil];
        
        cell.introDetailLabel.attributedText = attrStr;
    }
    
    return cell;
    
}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 0;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}


#pragma mark - InspectFootDelegate
- (void)returnParentsViewController
{
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)showPicture:(UITapGestureRecognizer *)sender
{
    // 获取到点击的显示图片的按钮
    UIImageView *imageView = (UIImageView *)sender.view;
    LargePictureViewController *largeVC = [[LargePictureViewController alloc] init];
    largeVC.index = imageView.tag - 1113;
    largeVC.allImageArray = _allImageURL;
    largeVC.pictureSaveMode = PictureNetWorkMode;
    [self.navigationController pushViewController:largeVC animated:YES];
    
//    CheckPicViewController *checkVC = [[CheckPicViewController alloc] init];
//    checkVC.checkImage = imageView.image;
//    [self.navigationController pushViewController:checkVC animated:YES];
    
}


#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero];
        _tableView.backgroundColor = kSectionBackGroundColor;
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 200.0;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {
    [self.view endEditing:YES];
}

- (InspectUpLoadFootView *)footerView
{
    if (!_footerView) {
        _footerView = [[InspectUpLoadFootView alloc] initWithAnswerAttachments:self.taskModel.answerAttachments referenceAttachments:self.taskModel.referenceAttachments remark:self.taskModel.remark];
        _footerView.delegate = self;
    }
    return _footerView;
}


@end
