//
//  SolvedTypeTableViewCell.m
//  redstar
//
//  Created by admin on 16/6/6.
//  Copyright © 2016年 ZWF. All rights reserved.
//

#import "SolvedTypeTableViewCell.h"

@implementation SolvedTypeTableViewCell

- (UILabel *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
    }
    _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    _titleLabel.font = [UIFont systemFontOfSize:17.0];
    _titleLabel.textColor = kdetailCellTitleColor;
    [self.contentView addSubview:_titleLabel];
    
    // 顶端
    NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
    [self.contentView addConstraint:titleTop];
    
    // 左边
    NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:17];
    [self.contentView addConstraint:titleLeft];
    
    // 右边
    NSLayoutConstraint *titleWidth = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
    [self.contentView addConstraint:titleWidth];
    
    // 高度
    NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
    [self.contentView addConstraint:titleHeight];
    
    return _titleLabel;
}

- (UIButton *)quesBtn
{
    if (!_quesBtn) {
        _quesBtn = [[UIButton alloc] init];
        _quesBtn.selected = YES;
    }
    _quesBtn.tag = 323118;
    [_quesBtn setTitleColor:kOnLineCellTitleColor forState:UIControlStateNormal];
    _quesBtn.translatesAutoresizingMaskIntoConstraints = NO;
    [_quesBtn setTitle:@"纯问题" forState:UIControlStateNormal];
    [_quesBtn setImage:[UIImage imageNamed:@"select_box"] forState:UIControlStateNormal];
    [_quesBtn setImage:[UIImage imageNamed:@"no_select_box"] forState:UIControlStateSelected];
    _quesBtn.titleLabel.font = [UIFont systemFontOfSize:17.0f];
    _quesBtn.imageEdgeInsets = UIEdgeInsetsMake(0, 0, 0, 20);
    _quesBtn.titleEdgeInsets = UIEdgeInsetsMake(0, -8, 0, 0);
    _quesBtn.imageView.contentMode = UIViewContentModeRight;
    _quesBtn.titleLabel.contentMode = UIViewContentModeLeft;
    [_quesBtn setTitleColor:[UIColor colorWithRed:151 / 255.0 green:151 / 255.0  blue:151 / 255.0  alpha:1.0f] forState:UIControlStateNormal];
    [self.contentView addSubview:_quesBtn];
    
    // 顶端
    NSLayoutConstraint *selectTop = [NSLayoutConstraint constraintWithItem:_quesBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
    [self.contentView addConstraint:selectTop];
    
    // 左边
    NSLayoutConstraint *selectLeft = [NSLayoutConstraint constraintWithItem:_quesBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self.contentView addConstraint:selectLeft];
    
    // 右边
    NSLayoutConstraint *selectRight = [NSLayoutConstraint constraintWithItem:_quesBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.FAQBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [self.contentView addConstraint:selectRight];
    
    // 高度
    NSLayoutConstraint *selectBottom = [NSLayoutConstraint constraintWithItem:_quesBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
    [self.contentView addConstraint:selectBottom];
    
    // 高度
    NSLayoutConstraint *selectWidth = [NSLayoutConstraint constraintWithItem:_quesBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:_FAQBtn attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
    [self.contentView addConstraint:selectWidth];
    
    
    return _quesBtn;
}

- (UIButton *)FAQBtn
{
    if (!_FAQBtn) {
        _FAQBtn = [[UIButton alloc] init];
        _FAQBtn.tag = 323119;
        [_FAQBtn setTitleColor:kOnLineCellTitleColor forState:UIControlStateNormal];
        _FAQBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_FAQBtn setTitle:@"形成FAQ" forState:UIControlStateNormal];
        [_FAQBtn setImage:[UIImage imageNamed:@"select_box"] forState:UIControlStateNormal];
        [_FAQBtn setImage:[UIImage imageNamed:@"no_select_box"] forState:UIControlStateSelected];
        _FAQBtn.titleLabel.font = [UIFont systemFontOfSize:17.0f];
        _FAQBtn.imageEdgeInsets = UIEdgeInsetsMake(0, 0, 0, 20);
        _FAQBtn.titleEdgeInsets = UIEdgeInsetsMake(0, -8, 0, 0);
        _FAQBtn.imageView.contentMode = UIViewContentModeRight;
        _FAQBtn.titleLabel.contentMode = UIViewContentModeLeft;
        [_FAQBtn setTitleColor:[UIColor colorWithRed:151 / 255.0 green:151 / 255.0  blue:151 / 255.0  alpha:1.0f] forState:UIControlStateNormal];
        [self.contentView addSubview:_FAQBtn];
        
        // 顶端
        NSLayoutConstraint *selectTop = [NSLayoutConstraint constraintWithItem:_FAQBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
        [self.contentView addConstraint:selectTop];
        
        
        // 右边
        NSLayoutConstraint *selectRight = [NSLayoutConstraint constraintWithItem:_FAQBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:selectRight];
        
        // 高度
        NSLayoutConstraint *selectBottom = [NSLayoutConstraint constraintWithItem:_FAQBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
        [self.contentView addConstraint:selectBottom];
     
        
    }
    return _FAQBtn;
}

- (UIButton *)SOPBtn
{
    if (!_SOPBtn) {
        _SOPBtn = [[UIButton alloc] init];
        _SOPBtn.tag = 323120;
        [_SOPBtn setTitleColor:kOnLineCellTitleColor forState:UIControlStateNormal];
        _SOPBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_SOPBtn setTitle:@"优化SOP" forState:UIControlStateNormal];
        [_SOPBtn setImage:[UIImage imageNamed:@"select_box"] forState:UIControlStateNormal];
        [_SOPBtn setImage:[UIImage imageNamed:@"no_select_box"] forState:UIControlStateSelected];
        _SOPBtn.titleLabel.font = [UIFont systemFontOfSize:17.0f];
        _SOPBtn.imageEdgeInsets = UIEdgeInsetsMake(0, 0, 0, 20);
        _SOPBtn.titleEdgeInsets = UIEdgeInsetsMake(0, -8, 0, 0);
        _SOPBtn.imageView.contentMode = UIViewContentModeRight;
        _SOPBtn.titleLabel.contentMode = UIViewContentModeLeft;
        [_SOPBtn setTitleColor:[UIColor colorWithRed:151 / 255.0 green:151 / 255.0  blue:151 / 255.0  alpha:1.0f] forState:UIControlStateNormal];
        [self.contentView addSubview:_SOPBtn];
        
        // 顶端
        NSLayoutConstraint *selectTop = [NSLayoutConstraint constraintWithItem:_SOPBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.quesBtn attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
        [self.contentView addConstraint:selectTop];
        
        
        // 右边
        NSLayoutConstraint *selectLeft = [NSLayoutConstraint constraintWithItem:_SOPBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeRight multiplier:1.0 constant:8];
        [self.contentView addConstraint:selectLeft];
        
        // 高度
        NSLayoutConstraint *selectBottom = [NSLayoutConstraint constraintWithItem:_SOPBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
        [self.contentView addConstraint:selectBottom];
        
        // 高度
        NSLayoutConstraint *selectWidth = [NSLayoutConstraint constraintWithItem:_SOPBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:self.quesBtn attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
        [self.contentView addConstraint:selectWidth];
        
    }
    return _SOPBtn;
}


@end
