//
//  QuestionUnsolvedViewController.m
//  redstar
//
//  Created by admin on 16/6/4.
//  Copyright © 2016年 ZWF. All rights reserved.
//

#import "QuestionUnsolvedViewController.h"
#import "QuestionDetailCell.h"
#import "QuestionDescribeCell.h"
#import "LargePictureViewController.h"

#import "QuestionUnsolveTableViewCell.h"

#import "CommentView.h"
#import "HttpClient.h"
#import <MBProgressHUD.h>

#import "QuestionDetailModel.h"
#import "QuestionDealWithView.h"

#import "SolvedTypeTableViewCell.h"

#import "SelectCategaryViewController.h"
#import "HttpClient.h"

#define kQuestionDetailCell @"QuestionDetailCell" // 问题详情
#define kQuestionDescribeCell @"QuestionDescribeCell" // 问题描述

#define kQuestionUnsolveTableViewCell @"QuestionUnsolveTableViewCell" // 问题描述


@interface QuestionUnsolvedViewController ()<UITableViewDelegate, UITableViewDataSource, UIAlertViewDelegate, UITextViewDelegate, QuestionDescribeDelegate, QuestionUnsolveDelegate, QuestionDealWithDelegate>
@property (nonatomic, strong) UITableView *tableView;

@property (nonatomic, strong) UIView *backGroundView;
@property (nonatomic, strong) QuestionDetailModel *questionDetailModel;
@property (nonatomic, strong) NSMutableArray *allCommentArray;
@property (nonatomic, assign) int clickNumber;

@property (nonatomic, strong) NSMutableArray *allImageURL;

@property (nonatomic, strong) UIView *footerView;

@property (nonatomic, strong) UIView *bgView;
@property (nonatomic, strong) QuestionDealWithView *dealWithView;

@end

@implementation QuestionUnsolvedViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.allImageURL = [NSMutableArray array];
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    
    [self setupNav];
    
    // 问题详情
    [self requestQestionDetail];
    
    self.view.backgroundColor = kSectionBackGroundColor;
    
    _clickNumber = 0;
    
    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:0 inSection:2];
    
    
    
    
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBar.hidden = NO;
    
    self.tabBarController.tabBar.hidden = YES;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Methods
- (void)requestQestionDetail
{
    self.allCommentArray = [NSMutableArray array];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    
    NSString *url = [NSString stringWithFormat:@"%@%@%@?userUuid=%@", kRedStarURL, kQuestionDetailURL, _questionUuid ,user_uuid];
    
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:url];
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    [httpClient getQuestionDetailWithParameters:nil completion:^(id response, NSError *error) {
        NSDictionary *dict = response[@"data"];
        QuestionDetailModel *quesDetail = [[QuestionDetailModel alloc] init];
        [quesDetail setValuesForKeysWithDictionary:dict];
        _questionDetailModel = quesDetail;
        
        for (int i = 0; i < _questionDetailModel.attachments.count; i++) {
            UIImageView *imageView = [[UIImageView alloc] init];
            imageView.translatesAutoresizingMaskIntoConstraints = NO;
            NSDictionary *imageDict = _questionDetailModel.attachments[i];
            NSURL *imageURL = [NSURL URLWithString:[NSString stringWithFormat:@"%@%@", kRedStarURL, imageDict[@"fileUrl"]]];
            [_allImageURL addObject:imageURL];
        }
        
        [MBProgressHUD hideHUDForView:self.view animated:YES];
        [self.tableView reloadData];
    }];
}

- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"问题详情"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
    
}

// 返回上一页面
- (void)doBack:(UIBarButtonItem *)sender
{
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)dealWithProblem:(UIButton *)sender {
    NSArray *permissions = [[NSUserDefaults standardUserDefaults] objectForKey:@"permissions"];
    if ([permissions containsObject:@"500506"]) {
        [self showRedView];
    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您没有处理问题的权限！" delegate:self cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
        [alert show];
    }
}

- (void)showRedView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] initWithFrame:self.view.bounds];
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeRedView)];
        [_bgView addGestureRecognizer:tapGR];
    }
    self.dealWithView.backgroundColor = [UIColor whiteColor];
    
    [self.view addSubview:_bgView];
    [self.view insertSubview:_dealWithView aboveSubview:_bgView];
    
    _bgView.alpha = 0;
    _bgView.backgroundColor = [UIColor blackColor];
    
    [_dealWithView.quitBtn addTarget:self action:@selector(closeRedView) forControlEvents:UIControlEventTouchUpInside];

    CGRect toFrame = CGRectMake(0, kScreenHeight - 515, kScreenWidth, 515);
    CGRect fromFrame = CGRectMake(0, kScreenHeight, kScreenWidth, 515);
    
    _dealWithView.frame = fromFrame;
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = 0.6;
        _dealWithView.frame = toFrame;
    }];
    
}

- (void)tableDidSelectAtIndexPath:(NSIndexPath *)indexPath nameArray:(NSArray *)nameArray{
    SelectCategaryViewController *selectCVC = [[SelectCategaryViewController alloc] init];
    selectCVC.delegate = self.dealWithView;
    selectCVC.rowNum = indexPath.row;
    if (indexPath.row == 0) {
        selectCVC.titleStr = @"专业组";
        selectCVC.titleArray = nameArray;
    } else {
        selectCVC.titleStr = @"问题分类";
        selectCVC.titleArray = nameArray;
    }
    [self.navigationController pushViewController:selectCVC animated:YES];
}

- (void)requestProlemDealWithResultWithGroupText:(NSString *)groupText categoryText:(NSString *)categoryText solutionType:(NSString *)solutionType  optionType:(NSString *)optionType {
    
    [self closeRedView];
    
    NSDate *date = [NSDate date];
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"YYYY-MM-dd+hh:mm:ss"];
    NSString *dateString = [dateFormatter stringFromDate:date];
    
    NSString *operId = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_code"];
    NSString *operName = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_name"];
    
    NSString *url = [NSString stringWithFormat:@"%@%@%@&operId=%@&operName=%@", kRedStarURL,kSubmitQuestionResultURL,dateString, operId, operName];
    url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:url];
    
    NSDictionary *parameters = @{
                                 @"questionUuid":self.questionUuid,
                                 @"group":groupText,
                                 @"category":categoryText,
                                 @"solutionType":solutionType,
                                 @"optionType":optionType,
                                 @"feedback":self.dealWithView.titleTextView.text
                                 };
    
    [httpClient submitQuestionResultWithParameters:parameters completion:^(id response, NSError *error) {
        if ([response[@"success"] boolValue]) {
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"问题分类修改成功！" delegate:self cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
            alert.tag = 122837;
            [alert show];
        } else {
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"问题分类修改失败！" delegate:self cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
            [alert show];
        }
    }];
}

#pragma mark - UIAlertViewDelegte
- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex
{
    if (alertView.tag == 122837) {
        [self.navigationController popViewControllerAnimated:YES];
    }
}



- (void)closeRedView
{
    CGRect fromFrame = CGRectMake(0, kScreenHeight, kScreenWidth, 515);
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = .0f;
        _dealWithView.frame = fromFrame;
    } completion:^(BOOL finished) {
        [_bgView removeFromSuperview];
        [_dealWithView removeFromSuperview];
    }];
}


- (void)addZan:(ZanButton *)sender
{
    if ([_questionDetailModel.state isEqualToString:@"created"]) {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"当前问题尚未解决，暂不能点赞！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
        return;
    }
    
    _clickNumber++;
    if (_clickNumber > 4) {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您点赞过于频繁，请稍后再试！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
        return;
    }
    NSArray *permissions = [[NSUserDefaults standardUserDefaults] objectForKey:@"permissions"];
    if ([permissions containsObject:@"500505"]) {
        
        sender.selected = !sender.selected;
        
        NSDate *date = [NSDate date];
        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        [dateFormatter setDateFormat:@"YYYY-MM-dd+hh:mm:ss"];
        NSString *dateString = [dateFormatter stringFromDate:date];
        
        
        NSString *operId = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_code"];
        NSString *operName = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_name"];
        
        if (sender.selected) {
            // 点赞
            NSString *url = [NSString stringWithFormat:@"%@%@%@?time=%@&operId=%@&operName=%@", kRedStarURL, kAddLikeURL, _questionUuid, dateString, operId, operName];
            url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
            
            HttpClient *httpClient = [[HttpClient alloc] initWithUrl:url];
            [httpClient likeCountWithParameters:nil completion:^(id response, NSError *error) {
                if ([response[@"success"] boolValue]) {
                    int likeCount = [sender.titleLabel.text intValue];
                    [sender setTitle:[NSString stringWithFormat:@"%d", likeCount + 1] forState:UIControlStateNormal];
                } else {
                    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"警告" message:@"点赞失败！" delegate:self cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
                    [alert show];
                }
            }];
        } else {
            // 取消点赞
            NSString *url = [NSString stringWithFormat:@"%@%@%@?time=%@&operId=%@&operName=%@", kRedStarURL, kCancelLikeURL, _questionUuid, dateString, operId, operName];
            url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
            
            HttpClient *httpClient = [[HttpClient alloc] initWithUrl:url];
            [httpClient likeCountWithParameters:nil completion:^(id response, NSError *error) {
                if ([response[@"success"] boolValue]) {
                    int likeCount = [sender.titleLabel.text intValue];
                    [sender setTitle:[NSString stringWithFormat:@"%d", likeCount - 1] forState:UIControlStateNormal];
                } else {
                    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"警告" message:@"取消点赞失败！" delegate:self cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
                    [alert show];
                }
            }];
        }
    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您没有点赞的权限！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
    }
}

- (void)showPicture:(UITapGestureRecognizer *)sender
{
    // 获取到点击的显示图片的按钮
    UIImageView *imageView = (UIImageView *)sender.view;
    LargePictureViewController *largeVC = [[LargePictureViewController alloc] init];
    largeVC.index = imageView.tag - 1115;
    largeVC.pictureSaveMode = PictureNetWorkMode;
    
    largeVC.allImageArray = _allImageURL;
    [self.navigationController pushViewController:largeVC animated:YES];
}


#pragma mark - UITableView Delegate/DataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 2;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 1;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    if (indexPath.section == 0) {
        QuestionDetailCell *cell=[tableView dequeueReusableCellWithIdentifier:kQuestionDetailCell];
        if (!cell) {
            cell = [[QuestionDetailCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kQuestionDetailCell];
        }
        cell.questionDetail = self.questionDetailModel;
        [cell.thumbBtn addTarget:self action:@selector(addZan:) forControlEvents:UIControlEventTouchUpInside];
        return cell;
        
    } else {
     
        QuestionUnsolveTableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kQuestionUnsolveTableViewCell];
        if (!cell) {
            cell = [[QuestionUnsolveTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kQuestionUnsolveTableViewCell];
        }
        cell.delegate = self;
        cell.questionDetail = self.questionDetailModel;
        return cell;
        
    }
}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}





#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 400.0;
        _tableView.tableFooterView = self.footerView;
        [_tableView registerClass:[QuestionDetailCell class] forCellReuseIdentifier:kQuestionDetailCell];
        [_tableView registerClass:[QuestionDescribeCell class] forCellReuseIdentifier:kQuestionDescribeCell];
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}
- (UIView *)footerView {
    if (!_footerView) {
        _footerView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 80)];
        
        UIButton *button = [[UIButton alloc] init];
        button.frame = CGRectMake(20, 20, kScreenWidth - 40, 40);
        button.layer.cornerRadius = 3;
        button.backgroundColor = kNavigationBarColor;
        button.titleLabel.font = [UIFont systemFontOfSize:18.0f];
        [button setTitle:@"问题处理" forState:UIControlStateNormal];
        [button addTarget:self action:@selector(dealWithProblem:) forControlEvents:UIControlEventTouchUpInside];
        [_footerView addSubview:button];
    }
    return _footerView;
}

- (void)textViewDidBeginEditing:(UITextView *)textView
{
    CGRect fromFrame = CGRectMake(0, kScreenHeight - 750, kScreenWidth, 515);
    [UIView animateWithDuration:0.3 animations:^{
        self.dealWithView.frame = fromFrame;
    } completion:nil];

}

- (void)textViewDidEndEditing:(UITextView *)textView
{
    CGRect fromFrame = CGRectMake(0, kScreenHeight - 515, kScreenWidth, 515);
    [UIView animateWithDuration:0.3 animations:^{
        self.dealWithView.frame = fromFrame;
    } completion:nil];
}

- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text{
    if (![text isEqualToString:@""]) {
        self.dealWithView.placeholderLabel1.hidden = YES;
    }
    if ([text isEqualToString:@""] && range.location == 0 && range.length == 1) {
        self.dealWithView.placeholderLabel1.hidden = NO;
    }
    
    if ([text isEqualToString:@"\n"]) {
        [self.dealWithView.titleTextView resignFirstResponder];
        return NO;
    }
    
    if (range.location>=200) {
        return  NO;
    }
    else {
        return YES;
    }
    
    return YES;
}

- (QuestionDealWithView *)dealWithView {
    if (!_dealWithView) {
        _dealWithView = [[QuestionDealWithView alloc] init];
        _dealWithView.delegate = self;
        _dealWithView.titleTextView.delegate = self;
    }
    return _dealWithView;
}


@end
