//
//  QuestionUnsolveTableViewCell.m
//  redstar
//
//  Created by admin on 16/6/4.
//  Copyright © 2016年 ZWF. All rights reserved.
//

#import "QuestionUnsolveTableViewCell.h"
#import <UIImageView+WebCache.h>

@interface QuestionUnsolveTableViewCell ()
@property (nonatomic, strong) NSLayoutConstraint *picConstraint;

@end

@implementation QuestionUnsolveTableViewCell

#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

#pragma mark - Private Methods
- (void)setup
{
    self.titleLabel.textColor = kDetailCellDescribeTextColor;
    _titleLabel.text = @"问题与建议描述";
    
    self.pictureLabel.textColor = kDetailCellDescribeTextColor;
    _pictureLabel.text = @"照片";
    
    self.pictureView.backgroundColor = [UIColor whiteColor];
    
    
}

- (void)setQuestionDetail:(QuestionDetailModel *)questionDetail
{
    _questionDetail = questionDetail;
    
    // 问题与描述
    NSString *describeStr = [NSString stringWithFormat:@"%@", questionDetail.content];
    NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc] initWithString:describeStr];
    NSMutableParagraphStyle *paragraphStyle1 = [[NSMutableParagraphStyle alloc] init];
    paragraphStyle1.alignment = NSTextAlignmentLeft;
    paragraphStyle1.lineSpacing = 6;  //行自定义行高度
    [attributedString addAttribute:NSParagraphStyleAttributeName value:paragraphStyle1 range:NSMakeRange(0, [describeStr length])];
    self.describeLabel.attributedText = attributedString;
    
    self.pictureView.backgroundColor = [UIColor whiteColor];
    
    CGFloat imageMaginX = 20;
    CGFloat imageMaginY = 10;
    CGFloat imageW = (kScreenWidth - imageMaginX * 3) / 2;
    CGFloat imageH = 110;
    
    int count = (int)questionDetail.attachments.count;
    int k ;
    if (count % 2 == 0) {
        k = count / 2;
    } else {
        k = (count + 1) / 2;
    }
    
    self.picConstraint.constant = imageMaginY + (imageMaginY + imageH) * k;
    [self.pictureView setNeedsUpdateConstraints];
    
    for (int i = 0; i < count; i++) {
        UIImageView *imageView = [[UIImageView alloc] init];
        imageView.tag = 1115 + i;
        imageView.translatesAutoresizingMaskIntoConstraints = NO;
        NSDictionary *imageDict = questionDetail.attachments[i];
        NSURL *imageURL = [NSURL URLWithString:[NSString stringWithFormat:@"%@%@", kRedStarURL, imageDict[@"fileUrl"]]];
        [imageView sd_setImageWithURL:imageURL placeholderImage:[UIImage imageNamed:@"default_pic"]];
        
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(bigImageCilck:)];
        [imageView addGestureRecognizer:tap];
        
        [self.pictureView addSubview:imageView];
        
        int j = 0;
        if ((i + 1) % 2 == 0) {
            j = count / 2;
        } else {
            j = (count + 1) / 2;
        }
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.pictureView attribute:NSLayoutAttributeTop multiplier:1.0 constant:imageMaginY + (j - 1) * (imageH + imageMaginY)];
        [self.pictureView addConstraint:titleTop];
        
        if ((i + 1) % 2 == 0) {
            // 左边
            NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.pictureView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:imageMaginX + imageW + imageMaginX];
            [self.pictureView addConstraint:titleLeft];
        } else {
            // 左边
            NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.pictureView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:imageMaginX];
            [self.pictureView addConstraint:titleLeft];
        }
        
        
        // 右边
        NSLayoutConstraint *titleWidth = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:imageW];
        [self.pictureView addConstraint:titleWidth];
        
        // 高度
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:imageH];
        [self.pictureView addConstraint:titleHeight];
    }
    
}

- (void)bigImageCilck:(UITapGestureRecognizer *)sender
{
    if (_delegate && [_delegate respondsToSelector:@selector(showPicture:)]) {
        [_delegate showPicture:sender];
    }
}

#pragma mark - lazy loading
- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.font = [UIFont systemFontOfSize:15.0];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_titleLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:titleRight];
        
        // 高度
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:titleHeight];
    }
    return _titleLabel;
}

- (UILabel *)describeLabel
{
    if (!_describeLabel) {
        _describeLabel = [[UILabel alloc] init];
        _describeLabel.textColor = kdetailCellTitleColor;
        _describeLabel.font = [UIFont systemFontOfSize:15.0];
        _describeLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _describeLabel.numberOfLines = 0;
        [_describeLabel sizeToFit];
        [self.contentView addSubview:_describeLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_describeLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_describeLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_describeLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:titleRight];
        
    }
    return _describeLabel;
}

- (UILabel *)pictureLabel
{
    if (!_pictureLabel) {
        _pictureLabel = [[UILabel alloc] init];
        _pictureLabel.font = [UIFont systemFontOfSize:15.0];
        _pictureLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_pictureLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.describeLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:titleRight];
        
        // 高度
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentView addConstraint:titleHeight];
        
    }
    return _pictureLabel;
    
}

- (UIView *)pictureView
{
    if (!_pictureView) {
        _pictureView = [[UIView alloc] init];
        _pictureView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_pictureView];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_pictureView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.pictureLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_pictureView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_pictureView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleRight];
        
        // 高度
        self.picConstraint = [NSLayoutConstraint constraintWithItem:_pictureView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:130];
        [self.contentView addConstraint:_picConstraint];
        
        // 右边
        NSLayoutConstraint *titleBottom = [NSLayoutConstraint constraintWithItem:_pictureView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-10];
        [self.contentView addConstraint:titleBottom];
    }
    return _pictureView;
}

@end
