//
//  FeedContentTableCell.m
//  redstar
//
//  Created by admin on 16/6/6.
//  Copyright © 2016年 ZWF. All rights reserved.
//

#import "FeedContentTableCell.h"

@implementation FeedContentTableCell

- (UILabel *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
    }
    _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    _titleLabel.font = [UIFont systemFontOfSize:17.0];
    _titleLabel.textColor = kdetailCellTitleColor;
    [self.contentView addSubview:_titleLabel];
    
    // 顶端
    NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
    [self.contentView addConstraint:titleTop];
    
    // 左边
    NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:17];
    [self.contentView addConstraint:titleLeft];
    
    // 右边
    NSLayoutConstraint *titleWidth = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
    [self.contentView addConstraint:titleWidth];
    
    // 高度
    NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
    [self.contentView addConstraint:titleHeight];
    
    return _titleLabel;
}
- (UIImageView *)backImageView1
{
    if (!_backImageView1) {
        _backImageView1 = [[UIImageView alloc] init];
        _backImageView1.userInteractionEnabled = YES;
        _backImageView1.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_backImageView1];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:15];
        [self.contentView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeRight multiplier:1.0 constant:5];
        [self.contentView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:120];
        [self.contentView addConstraint:contentHeight];
        
    }
    return _backImageView1;
}

//- (UITextView *)titleTextView
//{
//    if (!_titleTextView) {
//        _titleTextView = [[UITextView alloc] init];
//        _titleTextView.tag = 1001;
//        _titleTextView.font = [UIFont systemFontOfSize:15.0];
//        _titleTextView.translatesAutoresizingMaskIntoConstraints = NO;
//        [self.backImageView1 addSubview:_titleTextView];
//        
//        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
//        [self.backImageView1 addConstraint:contentTop];
//        
//        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:1];
//        [self.backImageView1 addConstraint:contentLeft];
//        
//        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeRight multiplier:1.0 constant:-1];
//        [self.backImageView1 addConstraint:contentRight];
//        
//        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_titleTextView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
//        [self.backImageView1 addConstraint:contentHeight];
//    }
//    return _titleTextView;
//}
//
//
//
//- (UILabel *)placeholderLabel1
//{
//    if (!_placeholderLabel1) {
//        _placeholderLabel1 = [[UILabel alloc] init];
//        _placeholderLabel1.translatesAutoresizingMaskIntoConstraints = NO;
//        _placeholderLabel1.font = [UIFont systemFontOfSize:15.0];
//        _placeholderLabel1.textColor = kOnLineCellDetailColor;
//        [self.titleTextView addSubview:_placeholderLabel1];
//        
//        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleTextView attribute:NSLayoutAttributeTop multiplier:1.0 constant:2];
//        [self.titleTextView addConstraint:contentTop];
//        
//        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.titleTextView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:5];
//        [self.titleTextView addConstraint:contentLeft];
//        
//        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.titleTextView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
//        [self.titleTextView addConstraint:contentRight];
//        
//        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_placeholderLabel1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
//        [self.titleTextView addConstraint:contentHeight];
//    }
//    return _placeholderLabel1;
//}

- (UIButton *)changeBtn {
    if (!_changeBtn) {
        _changeBtn = [[UIButton alloc] init];
    }
    _changeBtn.translatesAutoresizingMaskIntoConstraints = NO;
    _changeBtn.backgroundColor = kNavigationBarColor;
    [_changeBtn setTitle:@"修改问题分类" forState:UIControlStateNormal];
    _changeBtn.titleLabel.font = [UIFont systemFontOfSize:18.0];
    _changeBtn.layer.cornerRadius = 3;
    [self.contentView addSubview:_changeBtn];
    
    // 顶端
    NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_changeBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:18];
    [self.contentView addConstraint:titleTop];
    
    // 左边
    NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_changeBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [self.contentView addConstraint:titleLeft];
    
    // 右边
    NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_changeBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:-15];
    [self.contentView addConstraint:titleRight];
    
    // 高度
    NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_changeBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
    [self.contentView addConstraint:titleHeight];


    return _changeBtn;
}

- (UIButton *)solveBtn {
    if (!_solveBtn) {
        _solveBtn = [[UIButton alloc] init];
    }
    _solveBtn.translatesAutoresizingMaskIntoConstraints = NO;
    _solveBtn.backgroundColor = kNavigationBarColor;
    _solveBtn.layer.cornerRadius = 3;
    [_solveBtn setTitle:@"解决问题" forState:UIControlStateNormal];
    _solveBtn.titleLabel.font = [UIFont systemFontOfSize:18.0];
    [self.contentView addSubview:_solveBtn];
    
    // 顶端
    NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_solveBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:18];
    [self.contentView addConstraint:titleTop];
    
    // 左边
    NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_solveBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
    [self.contentView addConstraint:titleRight];
    
    // 右边
    NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_solveBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:15];
    [self.contentView addConstraint:titleLeft];
    
    // 高度
    NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_solveBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
    [self.contentView addConstraint:titleHeight];
    

    return _solveBtn;
}
@end
