//
//  SearchToolBar.m
//  redstar
//
//  Created by admin on 15/11/10.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "SearchToolBar.h"

@implementation SearchToolBar

#pragma mark - init Methods
- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

#pragma mark - Private Methods
- (void)setup
{
    self.layer.borderColor = kPasswordBorderColor;
    self.layer.borderWidth = 1.0;
    
    self.searchTextFiled.placeholder = @"请输入问题关键字";
    [self.queryButton setTitle:@"快速查询" forState:UIControlStateNormal];
}


#pragma mark - Lazy Loading
- (UITextField *)searchTextFiled
{
    if (!_searchTextFiled) {
        _searchTextFiled = [[UITextField alloc] init];
        _searchTextFiled.font = [UIFont systemFontOfSize:14.0];
        _searchTextFiled.backgroundColor = [UIColor whiteColor];
        _searchTextFiled.translatesAutoresizingMaskIntoConstraints = NO;
        _searchTextFiled.layer.cornerRadius = 4.0;
        _searchTextFiled.layer.borderWidth = 1.0;
        _searchTextFiled.layer.borderColor = kPasswordBorderColor;
        UIImageView *imageV = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"search_icon"]];
        imageV.width += 20;
        imageV.contentMode = UIViewContentModeCenter;
        _searchTextFiled.leftView = imageV;
        _searchTextFiled.leftViewMode = UITextFieldViewModeAlways;
        [self addSubview:_searchTextFiled];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_searchTextFiled attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:8];
        [self addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_searchTextFiled attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_searchTextFiled attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.queryButton attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-10];
        [self addConstraint:titleRight];
        
        // 高度
        NSLayoutConstraint *titleBottom = [NSLayoutConstraint constraintWithItem:_searchTextFiled attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-8];
        [self addConstraint:titleBottom];
    }
    return _searchTextFiled;
}

- (UIButton *)queryButton
{
    if (!_queryButton) {
        _queryButton = [[UIButton alloc] init];
        _queryButton.titleLabel.font = [UIFont systemFontOfSize:15.0];
        _queryButton.layer.cornerRadius = 4.0;
        _queryButton.backgroundColor = kNavigationBarColor;
        _queryButton.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_queryButton];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_queryButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:9];
        [self addConstraint:titleTop];
        
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_queryButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:titleRight];
        
        // 高度
        NSLayoutConstraint *titleBottom = [NSLayoutConstraint constraintWithItem:_queryButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-9];
        [self addConstraint:titleBottom];
        
        // 宽度
        NSLayoutConstraint *titleWidth = [NSLayoutConstraint constraintWithItem:_queryButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
        [self addConstraint:titleWidth];

    }
    return _queryButton;
}



@end
