//
//  MoreTaxisView.m
//  redstar
//
//  Created by admin on 16/2/1.
//  Copyright © 2016年 ZWF. All rights reserved.
//

#import "MoreTaxisView.h"

@interface MoreTaxisView ()
@property (nonatomic, strong) NSMutableArray *buttons;

@end

@implementation MoreTaxisView
- (void)layoutSubviews
{
    self.buttons = [NSMutableArray array];
    
    CGFloat buttonW = kScreenWidth;
    NSArray *titleArray = @[@"默认排序",@"按点赞数由大到小排序",@"按点赞数由小到大排序",@"按时间顺序排序",@"按时间逆序排序"];
    CGFloat buttonH = self.frame.size.height / titleArray.count;

    
    for (int i = 0; i < titleArray.count; i++) {
        UIButton *button = [[UIButton alloc] init];
        button.titleLabel.font = [UIFont systemFontOfSize:15.0];
        button.tag = kTAxisBtnTag + i + 1;
        [button setTitleColor:kLightBlack forState:UIControlStateNormal];
        [button setTitleColor:[UIColor orangeColor] forState:UIControlStateSelected];
        button.frame = CGRectMake(0, i * buttonH, buttonW, buttonH);
        [button setTitle:titleArray[i] forState:UIControlStateNormal];
        button.layer.borderWidth = 0.5;
        button.titleEdgeInsets = UIEdgeInsetsMake(0, 20, 0, 0);
        button.layer.borderColor = kSeparateLineCGColor;
        button.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft ;
        button.titleLabel.font = [UIFont systemFontOfSize:14.0];
        [button setImage:[UIImage imageNamed:@"iconfont-duigou2"] forState:UIControlStateNormal];
        [button setImage:[UIImage imageNamed:@"iconfont-duigou"] forState:UIControlStateSelected];
        button.imageEdgeInsets = UIEdgeInsetsMake(0, kScreenWidth - 30, 0, 0);
        button.titleEdgeInsets = UIEdgeInsetsMake(0, 0, 0, 0);
        button.imageView.contentMode = UIViewContentModeRight;
        button.titleLabel.contentMode = UIViewContentModeLeft;
        [button addTarget:self action:@selector(touchDownForButton:) forControlEvents:UIControlEventTouchDown];
        button.adjustsImageWhenHighlighted = NO;
        [self addSubview:button];
        [self.buttons addObject:button];
    }
    UIButton *tempBtn = [_buttons objectAtIndex:0];
    tempBtn.selected = YES;
}


- (void)touchDownForButton:(UIButton *)button{
    for (UIButton * b in self.buttons) {
        b.selected = NO;
    }
    
    button.selected = YES;
    
    if (_delegate) {
        [_delegate moreTimeChange:button];
    }
    
}

@end
