//
//  AddQuestionFooterView.m
//  redstar
//
//  Created by admin on 15/11/6.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "AddQuestionFooterView.h"
@interface AddQuestionFooterView ()

@end

@implementation AddQuestionFooterView
- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}


- (void)setup
{
    [self.reportBtn setTitle:@"上报问题" forState:UIControlStateNormal];

}


- (UIButton *)reportBtn
{
    if (!_reportBtn) {
        _reportBtn = [[UIButton alloc] init];
        _reportBtn.translatesAutoresizingMaskIntoConstraints = NO;
        _reportBtn.titleLabel.font = [UIFont systemFontOfSize:20.0];
        _reportBtn.backgroundColor = kNavigationBarColor;
        _reportBtn.layer.cornerRadius = 5.0;
        [_reportBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [self addSubview:_reportBtn];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_reportBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:15];
        [self addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_reportBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_reportBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:tableRight];
        
        NSLayoutConstraint *tableHeight = [NSLayoutConstraint constraintWithItem:_reportBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:35];
        [self addConstraint:tableHeight];
    }
    return _reportBtn;
}


- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {
    [self endEditing:YES];
}

@end
