//
//  PictureStoryViewController.m
//  redstar
//
//  Created by admin on 15/11/16.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "PictureStoryViewController.h"
#import "PictureDetailModel.h"
#import "PicTextModel.h"
#import "PictureDetailTableCell.h"
#import "PictureTextTableCell.h"
#import "PictureCommentTableCell.h"
#import "PictureTextTableViewCell.h"
#import "UIImage+Fit.h"

#import "CheckPicViewController.h"

#import "HttpClient.h"
#import "CommentView.h"
#import <MBProgressHUD.h>
#import "CommentModel.h"
#import "CommonFunc.h"
#import "LargePictureViewController.h"

#import <UIImageView+WebCache.h>
#import <UIButton+WebCache.h>
#import <SDWebImageDownloader.h>

#import "AttachmentTableViewCell.h"
#import "AttachmentModel.h"
#import "ReaderViewController.h"

#define CategrayTitle @"口碑报道"

#define kPictureDetailTableCell @"PictureDetailTableViewCell"
#define kPictureTextTableCell @"PictureTextTableViewCell"
#define kPictureCommentTableCell @"pictureCommentTableViewCell"
#define kPictureTextTableViewCell @"pictureTextTAbleTableCell"
#define kAttachmentTableViwCell @"kattachmentTableViwCell"
@interface PictureStoryViewController () <UITableViewDelegate, UITableViewDataSource, UITextViewDelegate, SDWebImageManagerDelegate, ReaderViewControllerDelegate>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, assign) int clickNumber;
@property (nonatomic, strong) UIView *backGroundView;
@property (nonatomic, strong) CommentView *commentView;

@property (nonatomic, strong) PictureDetailModel *pictureDetail;
@property (nonatomic, strong) NSMutableArray *picTextArray;

@property (nonatomic, strong) NSMutableArray *allCommentArray;

@property (nonatomic, copy) NSString *pictureUuid;

@property (nonatomic, strong) NSMutableArray *imageNameArray;
@property (nonatomic, strong) NSMutableArray *realImageArray;
@property (nonatomic, strong) NSMutableArray *attachmentArray;
@end

@implementation PictureStoryViewController
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBar.hidden = NO;
    self.tabBarController.tabBar.hidden = YES;
    
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    
    self.attachmentArray = [NSMutableArray array];
    
    self.picTextArray = [NSMutableArray array];
    self.realImageArray = [NSMutableArray array];
    self.view.backgroundColor = [UIColor whiteColor];
    self.automaticallyAdjustsScrollViewInsets = NO;
    self.edgesForExtendedLayout = UIRectEdgeNone;
    [self setupNav];
    
    _clickNumber = 0;
    
    self.allCommentArray = [NSMutableArray array];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    
    self.imageNameArray = [NSMutableArray array];
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    [self requestPicturePraiseDetail];
}


#pragma mark - Private Methods

- (void)requestPicturePraiseDetail
{
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];

    NSString *url = [NSString stringWithFormat:@"%@%@%@?userUuid=%@", kRedStarURL, kPicturePraiseDetailURL, self.uuid, user_uuid];
    HttpClient *http = [[HttpClient alloc] initWithUrl:url];
    [http getPicturePraiseDetailWithCompletion:^(id response, NSError *error) {
    
        NSDictionary *dataDict = response[@"data"];
        
        PictureDetailModel *picDetail = [[PictureDetailModel alloc] init];
        [picDetail setValuesForKeysWithDictionary:dataDict];
        _pictureDetail = picDetail;
        _pictureUuid = picDetail.uuid;
        
        NSArray *referArray = picDetail.referAttachments;
        NSMutableArray *attaTempArray = [NSMutableArray array];
        for (NSDictionary *attaDict in referArray) {
            AttachmentModel *atta = [[AttachmentModel alloc] init];
            [atta setValuesForKeysWithDictionary:attaDict];
            [attaTempArray addObject:atta];
        }
        _attachmentArray = attaTempArray;

        NSArray *commentArray = picDetail.comments;
        for (NSDictionary *dict in commentArray) {
            CommentModel *comment = [[CommentModel alloc] init];
            [comment setValuesForKeysWithDictionary:dict];
            [_allCommentArray addObject:comment];
        }
        
        for (NSDictionary *picTextDict in picDetail.attachments) {
            
            PicTextModel *picText = [[PicTextModel alloc] init];
            [picText setValuesForKeysWithDictionary:picTextDict];
            [_picTextArray addObject:picText];
            
            if (picText.fileName.length != 0) {
                NSString *imgFileUrl = [NSString stringWithFormat:@"%@%@", kRedStarURL, picText.fileUrl];
                [_realImageArray addObject:imgFileUrl];
            }
            
            
            NSString *imageUrl = [NSString stringWithFormat:@"%@%@", kRedStarURL, picTextDict[@"fileUrl"]];
            [[SDWebImageDownloader sharedDownloader] downloadImageWithURL:[NSURL URLWithString:imageUrl] options:SDWebImageDownloaderUseNSURLCache progress:nil completed:^(UIImage *image, NSData *data, NSError *error, BOOL finished) {
                
                picText.isHavePic = finished;
                NSString *imageName = nil;
                if (image == nil) {
                    imageName = @"";
                } else {
                    imageName = [CommonFunc md5Data:data];
                    NSString *fullPath = [[NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask, YES) objectAtIndex:0] stringByAppendingPathComponent:[NSString stringWithFormat:@"%@", imageName]];
                    [data writeToFile:fullPath atomically:NO];
                }

                
                NSString *describe = nil;
                if ([picTextDict[@"description"] isEqual:[NSNull null]]) {
                    describe = @"";
                } else {
                    describe = [NSString stringWithFormat:@"%@",picTextDict[@"description"]];
                }
                
                picText.describeStr = describe;
                picText.imageName = imageName;
               
                dispatch_async(dispatch_get_main_queue(), ^{
                    [self.tableView reloadData];
                });

            }];
            
        }
        [MBProgressHUD hideHUDForView:self.view animated:YES];
        [self.tableView reloadData];
    }];
}


- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:[NSString stringWithFormat:@"%@详情", self.titleStr]];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
}

-(void)doBack:(id)sender
{
    [self clear];
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)clear
{
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        NSString *fullPath = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask, YES) objectAtIndex:0];

        for (NSString *p in _imageNameArray) {
            NSError *error;
            NSString *path = [fullPath stringByAppendingPathComponent:p];
            if ([[NSFileManager defaultManager] fileExistsAtPath:path]) {
                [[NSFileManager defaultManager] removeItemAtPath:path error:&error];
            }
        }
    });
}


- (void)addZan:(ZanButton *)sender
{
    _clickNumber++;
    if (_clickNumber > 4) {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您点赞过于频繁，请稍后再试！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
        return;
    }
    
    sender.selected = !sender.selected;
    
    NSDate *date = [NSDate date];
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"YYYY-MM-dd+hh:mm:ss"];
    NSString *dateString = [dateFormatter stringFromDate:date];
    
    
    NSString *operId = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_code"];
    NSString *operName = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_name"];
    
    if (sender.selected) {
        // 点赞
        NSString *url = [NSString stringWithFormat:@"%@%@%@?time=%@&operId=%@&operName=%@", kRedStarURL, kPicturePraiseLikeURL, self.uuid, dateString, operId, operName];
        url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
        
        HttpClient *httpClient = [[HttpClient alloc] initWithUrl:url];
        [httpClient getLikePicturePraiseWithCompletion:^(id response, NSError *error) {
            if ([response[@"success"] boolValue]) {
                int likeCount = [sender.titleLabel.text intValue];
                [sender setTitle:[NSString stringWithFormat:@"%d", likeCount + 1] forState:UIControlStateNormal];
            } else {
                UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"警告" message:@"点赞失败！" delegate:self cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
                [alert show];
            }
        }];
        
    } else {
        // 取消点赞
        NSString *url = [NSString stringWithFormat:@"%@%@%@?time=%@&operId=%@&operName=%@", kRedStarURL, kPicturePraiseCancelLikeURL, self.uuid, dateString, operId, operName];
        url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
        
        HttpClient *httpClient = [[HttpClient alloc] initWithUrl:url];
        [httpClient cancelLikePicturePraiseWithCompletion:^(id response, NSError *error) {
            if ([response[@"success"] boolValue]) {
                int likeCount = [sender.titleLabel.text intValue];
                [sender setTitle:[NSString stringWithFormat:@"%d", likeCount - 1] forState:UIControlStateNormal];
            } else {
                UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"警告" message:@"取消点赞失败！" delegate:self cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
                [alert show];
            }
        }];
    }
}

- (void)addComment:(UIButton *)sender
{
    
    NSArray *permissions = [[NSUserDefaults standardUserDefaults] objectForKey:@"permissions"];
    if ([permissions containsObject:@"500303"]) {
        if (!_backGroundView) {
            _backGroundView = [[UIView alloc] initWithFrame:self.view.bounds];
            UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeBackGroundView)];
            [_backGroundView addGestureRecognizer:tapGR];
        }
        if (!_commentView) {
            _commentView = [[CommentView alloc] init];
            _commentView.backgroundColor = [UIColor whiteColor];
        }
        _commentView.contentTextView.text = @"";
        _commentView.contentTextView.delegate = self;
        [_commentView.quitBtn addTarget:self action:@selector(closeBackGroundView) forControlEvents:UIControlEventTouchUpInside];
        [_commentView.sureBtn addTarget:self action:@selector(submitComment:) forControlEvents:UIControlEventTouchUpInside];
        [self.view insertSubview:_backGroundView aboveSubview:_tableView];
        [self.view insertSubview:_commentView aboveSubview:_backGroundView];
        
        _backGroundView.alpha = 0;
        _backGroundView.backgroundColor = [UIColor blackColor];
        
        CGRect toFrame = CGRectMake(0, self.view.frame.size.height - kCommentViewHeight, kScreenWidth, kCommentViewHeight);
        CGRect fromFrame = CGRectMake(0, kScreenHeight, kScreenWidth, kCommentViewHeight);
        
        _commentView.frame = fromFrame;
        [UIView animateWithDuration:0.3 animations:^{
            _backGroundView.alpha = 0.6;
            _commentView.frame = toFrame;
        }];
        
    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您没有添加评论的权限！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
    }
}




// 提交评论
- (void)submitComment:(UIButton *)sender
{
    // 提示框
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您确定要提交评论吗？" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确定", nil];
    alert.tag = 3652234;
    alert.delegate = self;
    [alert show];
}

- (void)closeBackGroundView
{
    CGRect fromFrame = CGRectMake(0, kScreenHeight, kScreenWidth, kCommentViewHeight);
    [UIView animateWithDuration:0.3 animations:^{
        _backGroundView.alpha = .0f;
        _commentView.frame = fromFrame;
    } completion:^(BOOL finished) {
        [_backGroundView removeFromSuperview];
        [_commentView removeFromSuperview];
    }];
}

- (void)tapClick:(UIGestureRecognizer *)sender
{
    UIImageView *showImageView = (UIImageView *)sender.view;
    PictureTextTableCell *cell = (PictureTextTableCell *)showImageView.superview.superview;
    NSIndexPath *indexPath = [_tableView indexPathForCell:cell];
    PicTextModel *picText = _picTextArray[indexPath.row];
    NSString *imageHttp = [NSString stringWithFormat:@"%@%@", kRedStarURL, picText.fileUrl];
    NSInteger index = [_realImageArray indexOfObject:imageHttp];
    
    // 获取到点击的显示图片的按钮
    LargePictureViewController *largeVC = [[LargePictureViewController alloc] init];
    largeVC.index = index;
    largeVC.pictureSaveMode = PictureNetWorkMode;
    largeVC.allImageArray = _realImageArray;
    [self.navigationController pushViewController:largeVC animated:YES];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    
    [[SDImageCache sharedImageCache] clearMemory];
    [[SDImageCache sharedImageCache] setValue:nil forKey:@"memCache"];
}

#pragma mark - UITableView DataSource/Delegate
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    if ([self.titleStr isEqualToString:CategrayTitle]) {
        return 4;
    } else {
        return 3;
    }
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (section == 0) {
        return 1;
    } else if (section == 1) {
        return _picTextArray.count;
    } else {
        if ([self.titleStr isEqualToString:CategrayTitle]) {
            if (section == 2) {
                return _attachmentArray.count;
            } else {
                return _allCommentArray.count;
            }
        }
        return _allCommentArray.count;
    }
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 0) {
        PictureDetailTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kPictureDetailTableCell];
        if (!cell) {
            cell = [[PictureDetailTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kPictureDetailTableCell];
        }
        
        // 标题
        NSString *titleLabelText = [NSString stringWithFormat:@"标题：%@", _pictureDetail.title];
        NSMutableAttributedString *titleLabelAttr = [[NSMutableAttributedString alloc] initWithString:titleLabelText];
        [titleLabelAttr addAttributes:@{NSForegroundColorAttributeName:kDetailCellDescribeTextColor,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(0,3)];
        [titleLabelAttr addAttributes:@{NSForegroundColorAttributeName:kdetailCellTitleColor,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(3,titleLabelText.length - 3)];
        [cell.titleLabel setAttributedText:titleLabelAttr];
        // 内容
        NSString *contentLabelText = [NSString stringWithFormat:@"内容：%@" , _pictureDetail.content];
        NSMutableAttributedString *contentLabelAttr = [[NSMutableAttributedString alloc] initWithString:contentLabelText];
        NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc]init];
        [paragraphStyle setLineSpacing:5];
        [contentLabelAttr addAttributes:@{NSForegroundColorAttributeName:kDetailCellDescribeTextColor,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(0,3)];
        [contentLabelAttr addAttributes:@{NSForegroundColorAttributeName:kdetailCellTitleColor,NSFontAttributeName:[UIFont systemFontOfSize:15.0f]} range:NSMakeRange(3,contentLabelAttr.length - 3)];
        [contentLabelAttr addAttribute:NSParagraphStyleAttributeName value:paragraphStyle range:NSMakeRange(0, contentLabelText.length)];

        [cell.contentLabel setAttributedText:contentLabelAttr];
        
        if (_pictureDetail.myLike) {
            cell.thumbBtn.selected = YES;
        } else {
            cell.thumbBtn.selected = NO;
        }
        [cell.thumbBtn addTarget:self action:@selector(addZan:) forControlEvents:UIControlEventTouchUpInside];
        [cell.thumbBtn setTitle:[NSString stringWithFormat:@"%d", _pictureDetail.likeCount] forState:UIControlStateNormal];

        
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    } else if (indexPath.section == 1) {
        
        PicTextModel *picText = _picTextArray[indexPath.row];
        
        if (picText.fileName.length == 0) {
            PictureTextTableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kPictureTextTableViewCell];
            if (!cell) {
                cell = [[PictureTextTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kPictureTextTableViewCell];
            }
            cell.descriptionLabel.text = [NSString stringWithFormat:@"%@", picText.descriptionText];
            return cell;
        } else {
            PictureTextTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kPictureTextTableCell];
            if (!cell) {
                cell = [[PictureTextTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kPictureTextTableCell];
            }
            NSString *imageName = picText.imageName;
            NSString *fullPath = [[NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask, YES) objectAtIndex:0] stringByAppendingPathComponent:[NSString stringWithFormat:@"%@", imageName]];

            UIImage *image = [UIImage imageWithContentsOfFile:fullPath];
            
            if (image) {
                if (picText.isHavePic) {
                    CGFloat bigImageH = (kScreenWidth - 40) / image.size.width * image.size.height;
                    cell.bigHeight.constant = bigImageH;
                    [cell.bigImageView layoutIfNeeded];
                }
                cell.bigImageView.image = image;
            } else {
                cell.bigImageView.image = [UIImage imageNamed:@"default_pic"];
            }
            
            UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tapClick:)];
            [cell.bigImageView addGestureRecognizer:tap];

            
            cell.descriptionLabel.text = picText.describeStr;
            return cell;
        }
    } else {
        // 判断当前页面是否为 口碑巡店
        if ([self.titleStr isEqualToString:CategrayTitle]) {
            // 是 口碑巡店
            if (indexPath.section == 2) {
                // 显示 附件cell
                
                AttachmentTableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kAttachmentTableViwCell];
                if (!cell) {
                    cell = [[AttachmentTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kAttachmentTableViwCell];
                }
                AttachmentModel *atta = _attachmentArray[indexPath.row];
                NSString *name = atta.fileName;
                [cell.nameBtn setTitle:name forState:UIControlStateNormal];
                cell.nameBtn.titleLabel.numberOfLines = 0;
                
                [cell.nameBtn addTarget:self action:@selector(showFile:) forControlEvents:UIControlEventTouchUpInside];
                [cell.downloadBtn addTarget:self action:@selector(downloadFile:) forControlEvents:UIControlEventTouchUpInside];
                cell.downloadBtn.tag = 998473 + indexPath.row;
                cell.nameBtn.tag = 998473 + indexPath.row;
                
                NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
                NSString *path = paths.lastObject;
                NSString *url = [NSString stringWithFormat:@"%@/%@", path, atta.fileName];

                NSFileManager *fileManager = [NSFileManager defaultManager];
                if ([fileManager fileExistsAtPath:url]) {
                    cell.downloadBtn.selected = YES;
                    cell.downloadBtn.backgroundColor = [UIColor grayColor];
                } else {
                    cell.downloadBtn.selected = NO;
                    cell.downloadBtn.backgroundColor = [UIColor colorWithRed:47 / 255.0 green:209/ 255.0 blue:92 / 255.0 alpha:1.0];
                    
                }
                return cell;
                
            } else {
                // 显示 评论cell
                PictureCommentTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kPictureCommentTableCell];
                if (!cell) {
                    cell = [[PictureCommentTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kPictureCommentTableCell];
                }
                cell.comment = _allCommentArray[indexPath.row];
                cell.selectionStyle = UITableViewCellSelectionStyleNone;
                return cell;
            }
        } else {
            // 评论
            PictureCommentTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kPictureCommentTableCell];
            if (!cell) {
                cell = [[PictureCommentTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kPictureCommentTableCell];
            }
            cell.comment = _allCommentArray[indexPath.row];
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            return cell;
        }
    }
}

- (void)showFile:(UIButton *)sender
{
    NSInteger row = sender.tag - 998473;
    AttachmentModel *atta = _attachmentArray[row];
    
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *path = paths.lastObject;
    NSString *url = [NSString stringWithFormat:@"%@/%@", path, atta.fileName];
    NSFileManager *fileManager = [NSFileManager defaultManager];
    if ([fileManager fileExistsAtPath:url]) {
        
        
        NSString *phrase = nil; // Document password (for unlocking most encrypted PDF files)
        
        ReaderDocument *document = [ReaderDocument withDocumentFilePath:url password:phrase];
        
        if (document != nil) // Must have a valid ReaderDocument object in order to proceed with things
        {
            ReaderViewController *readerViewController = [[ReaderViewController alloc] initWithReaderDocument:document];
            readerViewController.delegate = self; // Set the ReaderViewController delegate to self
            
            [self.navigationController pushViewController:readerViewController animated:YES];
        }
        
    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"文件不存在，请先下载在查看！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
    }
}

- (void)dismissReaderViewController:(ReaderViewController *)viewController
{
    
    [self.navigationController popViewControllerAnimated:YES];
    
}

- (void)downloadFile:(UIButton *)sender
{
    NSInteger row = sender.tag - 998473;
    AttachmentModel *atta = _attachmentArray[row];
    
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *path = paths.lastObject;
    
    NSString *fileName = [NSString stringWithFormat:@"%@", atta.fileName];
    [self downloadFileURL:[NSString stringWithFormat:@"%@%@", kRedStarURL, atta.fileUrl] savePath:path fileName:fileName];
}

- (void)downloadFileURL:(NSString *)aUrl savePath:(NSString *)aSavePath fileName:(NSString *)aFileName
{
    NSFileManager *fileManager = [NSFileManager defaultManager];
    
    //检查本地文件是否已存在
    NSString *fileName = [NSString stringWithFormat:@"%@/%@", aSavePath, aFileName];
    //检查附件是否存在
    if ([fileManager fileExistsAtPath:fileName]) {
    }else{
        
        //创建附件存储目录
        if (![fileManager fileExistsAtPath:aSavePath]) {
            [fileManager createDirectoryAtPath:aSavePath withIntermediateDirectories:YES attributes:nil error:nil];
        }
        //下载附件
        aUrl = [aUrl stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
        NSLog(@"uri ==%@", aUrl);
        NSURL *url = [[NSURL alloc] initWithString:aUrl];
        
        
        NSURLRequest *request = [NSURLRequest requestWithURL:url];
        
        AFHTTPRequestOperation *operation = [[AFHTTPRequestOperation alloc] initWithRequest:request];
        operation.inputStream   = [NSInputStream inputStreamWithURL:url];
        operation.outputStream  = [NSOutputStream outputStreamToFileAtPath:fileName append:NO];
        
        
        [MBProgressHUD showHUDAddedTo:self.view animated:YES];
        // 已完成下载
        [operation setCompletionBlockWithSuccess:^(AFHTTPRequestOperation *operation, id responseObject) {
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"下载成功！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
            alert.tag = 66690;
            [alert show];
            [MBProgressHUD hideHUDForView:self.view animated:YES];
            [self.tableView reloadData];
            
        } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"警告" message:@"下载失败！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
            [alert show];
            [MBProgressHUD hideHUDForView:self.view animated:YES];
            [self.tableView reloadData];
            
        }];
        
        
        
        [operation start];
    }
}

- (UIImage *)reSizeImage:(UIImage *)image toSize:(CGSize)reSize

{
    UIGraphicsBeginImageContext(CGSizeMake(reSize.width, reSize.height));
    [image drawInRect:CGRectMake(0, 0, reSize.width, reSize.height)];
    UIImage *reSizeImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    
    return reSizeImage;
    
}

- (UIImage *)scaleImage:(UIImage *)image toScale:(float)scaleSize
{
    
    UIGraphicsBeginImageContext(CGSizeMake(image.size.width * scaleSize, image.size.height * scaleSize));
                                
                                [image drawInRect:CGRectMake(0, 0, image.size.width * scaleSize, image.size.height * scaleSize)];
                                UIImage *scaledImage = UIGraphicsGetImageFromCurrentImageContext();
                                UIGraphicsEndImageContext();
                                
                                return scaledImage;
                                
                                }

// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    NSInteger num = 0;
    if ([self.titleStr isEqualToString:CategrayTitle]) {
        num = 3;
    } else {
        num = 2;
    }
    if (section == num) {
        // 创建sectionView
        UIView *sectionView = [[UIView alloc] init];
        sectionView.userInteractionEnabled = YES;
        sectionView.backgroundColor = kInspectSectionBackGroundColor;
        
        // 创建标题label
        UILabel *titleLabel = [[UILabel alloc] init];
        titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        titleLabel.textColor = kHomeSectionTitleTextColor;
        titleLabel.font = [UIFont systemFontOfSize:16.0];
        titleLabel.text = @"评论";
        [sectionView addSubview:titleLabel];
        
        NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:2];
        [sectionView addConstraint:titleLabelTop];
        
        NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [sectionView addConstraint:titleLabelLeft];
        
        NSLayoutConstraint *titleLabelWidth = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
        [sectionView addConstraint:titleLabelWidth];
        
        NSLayoutConstraint *titleLabelBottom = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [sectionView addConstraint:titleLabelBottom];
        
        // 创建标题label
        UIButton *titleBtn = [[UIButton alloc] init];
        titleBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [titleBtn setTitle:@"添加评论" forState:UIControlStateNormal];
        [titleBtn setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        titleBtn.titleLabel.font = [UIFont systemFontOfSize:14.0];
        titleBtn.layer.borderColor = kNavigationBarCGColor;
        titleBtn.layer.borderWidth = 1.0;
        titleBtn.layer.cornerRadius = 5;
        [titleBtn addTarget:self action:@selector(addComment:) forControlEvents:UIControlEventTouchUpInside];
        titleBtn.backgroundColor = [UIColor whiteColor];
        [sectionView addSubview:titleBtn];
        
        NSLayoutConstraint *titleBtnTop = [NSLayoutConstraint constraintWithItem:titleBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [sectionView addConstraint:titleBtnTop];
        
        NSLayoutConstraint *titleBtnRight = [NSLayoutConstraint constraintWithItem:titleBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [sectionView addConstraint:titleBtnRight];
        
        NSLayoutConstraint *titleBtnWidth = [NSLayoutConstraint constraintWithItem:titleBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
        [sectionView addConstraint:titleBtnWidth];
        
        NSLayoutConstraint *titleBtnBottom = [NSLayoutConstraint constraintWithItem:titleBtn attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-10];
        [sectionView addConstraint:titleBtnBottom];
        
        
        return sectionView;
    }
    else {
        return nil;
    }
}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    if ([self.titleStr isEqualToString:CategrayTitle]) {
        if (section == 3) {
            return 50;
        } else {
            return CGFLOAT_MIN;
        }
    } else {
        if (section == 2) {
            return 50;
        } else {
            return CGFLOAT_MIN;
        }
    }
    

}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

#pragma mark - UItextDelegate
- (void)textViewDidBeginEditing:(UITextView *)textView
{
    [UIView animateWithDuration:0.3 animations:^{
        _commentView.frame = CGRectMake(0, self.view.frame.size.height - kCommentViewHeight - 173, kScreenWidth, kCommentViewHeight);
    }];
}

- (void)textViewDidEndEditing:(UITextView *)textView
{
    [UIView animateWithDuration:0.3 animations:^{
        _commentView.frame = CGRectMake(0, self.view.frame.size.height - kCommentViewHeight, kScreenWidth, kCommentViewHeight);
    }];
}

- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text
{
    
    if (![text isEqualToString:@""]) {
        _commentView.placeholderLabel2.hidden = YES;
    }
    
    if ([text isEqualToString:@""] && range.location == 0 && range.length == 1) {
        _commentView.placeholderLabel2.hidden = NO;
    }
    
    if ([text isEqualToString:@"\n"]) {
        [_commentView.contentTextView resignFirstResponder];
        if (textView.text.length != 0) {
            _commentView.placeholderLabel2.hidden = YES;
        } else {
            _commentView.placeholderLabel2.hidden = NO;
        }
        return NO;
    }
    
    if (range.location>=200) {
        return  NO;
    }
    else {
        return YES;
    }
    
    return YES;
}

#pragma mark - UIAlertViewDelegate
-(void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex
{
    if (alertView.tag == 3652234) {
        if (buttonIndex == 0) {
            return;
        } else {
            // 提交数据
            NSDate *date = [NSDate date];
            NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
            [dateFormatter setDateFormat:@"YYYY-MM-dd+hh:mm:ss"];
            NSString *dateString = [dateFormatter stringFromDate:date];
            
            
            NSString *operId = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_code"];
            NSString *operName = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_name"];
            
            NSString *url  = [NSString stringWithFormat:@"%@%@?time=%@&operId=%@&operName=%@", kRedStarURL, kAddCommentURL , dateString , operId, operName];
            url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
            
            HttpClient *httpClient = [[HttpClient alloc] initWithUrl:url];
            NSDictionary *parameters = @{@"entityType":@"legendPraise",
                                         @"entityUuid":_pictureUuid,
                                         @"comment":_commentView.contentTextView.text};
            [MBProgressHUD showHUDAddedTo:self.view animated:YES];
            [httpClient submitCommentWithParameters:parameters completion:^(id response, NSError *error) {
                if ([response[@"message"] isEqualToString:@"ok"]) {
                    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"添加评论成功" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
                    alert.delegate = self;
                    alert.tag = 455232;
                    [alert show];
                    [MBProgressHUD hideHUDForView:self.view animated:YES];
                } else {
                    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"警告" message:@"添加评论失败" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
                    [alert show];
                    [MBProgressHUD hideHUDForView:self.view animated:YES];
                }
            }];
            
            [self closeBackGroundView];
        }
    } else if (alertView.tag == 455232) {
        // 刷新当前问题详情的评论列表
        if (buttonIndex == 0) {
            
            NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
            
            NSString *url = [NSString stringWithFormat:@"%@%@%@?userUuid=%@", kRedStarURL, kPicturePraiseDetailURL, self.uuid, user_uuid];
            [MBProgressHUD showHUDAddedTo:self.view animated:YES];
            HttpClient *http = [[HttpClient alloc] initWithUrl:url];
            __block PictureStoryViewController *weakSelf = self;
            [http getPicturePraiseDetailWithCompletion:^(id response, NSError *error) {
                
                NSDictionary *dataDict = response[@"data"];
                PictureDetailModel *picDetail = [[PictureDetailModel alloc] init];
                [picDetail setValuesForKeysWithDictionary:dataDict];
                _pictureDetail = picDetail;
                NSArray *commentArray = picDetail.comments;
                NSMutableArray *tempArray = [NSMutableArray array];
                for (NSDictionary *dict in commentArray) {
                    CommentModel *comment = [[CommentModel alloc] init];
                    [comment setValuesForKeysWithDictionary:dict];
                    [tempArray addObject:comment];
                }
                _allCommentArray = tempArray;
                [weakSelf.tableView reloadData];
                [MBProgressHUD hideHUDForView:self.view animated:YES];
                
            }];
            
            
            if (_delegate && [_delegate respondsToSelector:@selector(reloadList)]) {
                [_delegate reloadList];
            }
        }
    }
}


#pragma mark - lazy Laoding
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight =100.0;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.tableHeaderView=[[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, CGFLOAT_MIN)];
        _tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        [_tableView registerClass:[PictureDetailTableCell class] forCellReuseIdentifier:kPictureDetailTableCell];
        [_tableView registerClass:[PictureTextTableCell class] forCellReuseIdentifier:kPictureTextTableCell];
        [_tableView registerClass:[PictureCommentTableCell class] forCellReuseIdentifier:kPictureCommentTableCell];
        [_tableView registerClass:[PictureTextTableViewCell class] forCellReuseIdentifier:kPictureTextTableViewCell];
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}
@end
