//
//  PictureTextTableViewCell.m
//  redstar
//
//  Created by admin on 15/12/29.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "PictureTextTableViewCell.h"

@implementation PictureTextTableViewCell

- (UILabel *)descriptionLabel
{
    if (!_descriptionLabel) {
        _descriptionLabel = [[UILabel alloc] init];
        _descriptionLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _descriptionLabel.font = [UIFont systemFontOfSize:15.0];
        _descriptionLabel.textColor = kLightBlack;
        _descriptionLabel.numberOfLines = 0;
        [self.contentView addSubview:_descriptionLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_descriptionLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:2];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_descriptionLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_descriptionLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:titleRight];
        
        // 高度
        NSLayoutConstraint *titleBottom = [NSLayoutConstraint constraintWithItem:_descriptionLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-2];
        [self.contentView addConstraint:titleBottom];
    }
    return _descriptionLabel;
}
- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
