//
//  PicCategoryViewController.m
//  redstar
//
//  Created by admin on 15/12/26.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "PicCategoryViewController.h"
#import "StandardTableViewCell.h"
#import "PictureViewController.h"

#define kPicCategoryTableViewCell @"picCategoryViewCell"

@interface PicCategoryViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSArray *titleArray;
@property (nonatomic, strong) NSArray *detailTitleArray;

@end

@implementation PicCategoryViewController

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear: animated];
    [MobClick beginLogPageView:@"口碑现场"];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [MobClick endLogPageView:@"口碑现场"];
}
- (void)viewDidLoad {
    [super viewDidLoad];
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    [self setupNav];
    
    self.titleArray = [NSArray arrayWithObjects:@"口碑随手拍",@"口碑报道",@"口碑巡店", nil];
    //self.detailTitleArray = [NSArray arrayWithObjects:@"SOP:标准作业程序",@"内部精品培训课程讲义资料...",@"专家讲师精品课程视频分享...", nil];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
}

- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"口碑现场"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
}

-(void)doBack:(id)sender
{
    [self.navigationController dismissViewControllerAnimated:YES completion:nil];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - UItableView Delegate/DataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return _titleArray.count;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 1;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
//    StandardTableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kPicCategoryTableViewCell];
//    if (!cell) {
//        cell = [[StandardTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kPicCategoryTableViewCell];
//    }
    UITableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kPicCategoryTableViewCell];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kPicCategoryTableViewCell];
    }
    cell.imageView.image = [UIImage imageNamed:[NSString stringWithFormat:@"pic_0%ld",(long)indexPath.section]];
    cell.textLabel.text = [NSString stringWithFormat:@"%@", _titleArray[indexPath.section]];
    cell.textLabel.font = [UIFont systemFontOfSize:18.0];
    //cell.detailTitleLabel.text = [NSString stringWithFormat:@"%@", _detailTitleArray[indexPath.section]];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 100;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 10;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    PictureViewController *sopVC = [[PictureViewController alloc] init];
    sopVC.come = @"图说";
    sopVC.titleStr = _titleArray[indexPath.section];
    if (indexPath.section == 0) {
        sopVC.category = @"store";
        [self.navigationController pushViewController:sopVC animated:YES];
    } else if (indexPath.section == 1) {
        sopVC.category = @"casus";
        [self.navigationController pushViewController:sopVC animated:YES];
    } else {
        sopVC.category = @"report";
        [self.navigationController pushViewController:sopVC animated:YES];
    }
}

#pragma mark - lazy laoding
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.tableFooterView = [[UIView alloc] init];
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 300.0;
        [self.view addSubview:_tableView];
        [self.view insertSubview:_tableView atIndex:0];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}




@end
