//
//  TreeView.h
//  redstar
//
//  Created by admin on 15/12/18.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import <UIKit/UIKit.h>

#import "TreeNodeModel.h"
#import "TreeNodeCell.h"

@class TreeView;

@protocol TreeDelegate <NSObject>
@optional
/**
 *  @brief  将要点击折叠图标，返回YES将执行，返回NO取消执行
 *  @param  tree    所在树
 *  @param  node    所在节点
 *  @return YES-执行折叠展开操作，NO-不执行折叠展开操作
 */
-(BOOL)tree:(TreeView *)tree shouldClickFoldButtonAtNode:(TreeNodeCell *)node;

/**
 *  @brief  点击折叠图标后要执行的操作
 *  @param  tree    所在树
 *  @param  node    所在节点
 *  @return void
 */
-(void)tree:(TreeView *)tree didClickFoldButtonAtNode:(TreeNodeCell *)node;

/**
 *  @brief  点击标题后要执行的操作
 *  @param  tree    所在树
 *  @param  node    所在节点
 *  @return void
 */
-(void)tree:(TreeView *)tree didClickTitleAtNode:(TreeNodeCell *)node;
@end


@interface TreeView : UITableView<UITableViewDelegate, UITableViewDataSource, TreeNodeDelegate>

/// 节点数据资源
@property (nonatomic) TreeNodeModel *nodeData;
/// 代理
@property (nonatomic, weak) id<TreeDelegate> treeDelegate;

@property (nonatomic, strong) NSMutableArray *selectTreeArray;

@end
