//
//  TreeNodeModel.m
//  redstar
//
//  Created by admin on 15/12/18.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "TreeNodeModel.h"

@interface TreeNodeModel ()
/// 层级
@property (nonatomic) int levelDeep;
/// 孩子节点
@property (nonatomic) NSMutableArray *child;
/// 父节点
@property (nonatomic, weak) TreeNodeModel *parent;
/// 兄弟节点
@property (nonatomic, weak) TreeNodeModel *brother;

@end

@implementation TreeNodeModel
- (instancetype)init {
    self = [super init];
    if (self) {
        [self configSelf];
    }
    return self;
}

-(instancetype)initWithName:(NSString *)name {
    self = [super init];
    if (self) {
        [self configSelf];
        self.name = name;
    }
    return self;
}

-(void)configSelf {
    self.expand = NO;
    self.levelDeep = 0;
    self.child = [NSMutableArray array];
    self.parent = nil;
    self.brother = nil;
}


-(NSUInteger)nodeCount {
    NSUInteger count = 1;
    if (self.isExpand) {
        for (TreeNodeModel* node in self.child) {
            count += node.nodeCount;
        }
    }
    return count;
}


-(TreeNodeModel *)nextNode {
    if (self.isExpand && self.child.count != 0) {
        return self.child[0];
    }
    else {
        for (TreeNodeModel *node = self; node != nil; node = node.parent) {
            if (node.brother != nil) {
                return node.brother;
            }
        }
        return nil;
    }
}

-(NSArray *)nodeArray:(BOOL)includeRoot {
    NSMutableArray *array = [NSMutableArray array];
    if (includeRoot) {
        [array addObject:self];
        for (TreeNodeModel *node = [self nextNode]; node != nil && node.levelDeep > self.levelDeep; node = [node nextNode]) {
            [array addObject:node];
        }
    }
    else {
        if (self.child.count != 0) {
            for (TreeNodeModel *node = self.child[0]; node != nil && node.levelDeep > self.levelDeep; node = [node nextNode]) {
                [array addObject:node];
            }
        }
        
    }
    return [NSArray arrayWithArray:array];
}

-(void)insertChild:(TreeNodeModel *)node {
    node.levelDeep = self.levelDeep + 1;
    node.parent = self;
    node.brother = nil;
    if (self.child.count > 0) {
        ((TreeNodeModel*)self.child[self.child.count - 1]).brother = node;
    }
    [self.child addObject:node];
}

-(void)insertChild:(TreeNodeModel *)node index:(NSUInteger)indexes {
    if (indexes >= self.child.count) {
        indexes = self.child.count - 1;
    }
    node.levelDeep = self.levelDeep + 1;
    node.parent = self;
    node.brother = self.child[indexes];
    if (indexes > 0) {
        ((TreeNodeModel*)self.child[indexes - 1]).brother = node;
    }
    [self.child insertObject:node atIndex:indexes];
}

-(BOOL)removeChild:(TreeNodeModel *)node {
    for (int i = 0; i < self.child.count; i++) {
        if ([node isEqual:self.child[i]]) {
            return [self removeChildAtIndexes:i];
        }
    }
    return NO;
}

-(BOOL)removeChildAtIndexes:(NSUInteger)indexes {
    if (indexes < self.child.count) {
        if (indexes > 0) {
            if (indexes < self.child.count - 1) {
                ((TreeNodeModel *)self.child[indexes - 1]).brother = self.child[indexes + 1];
            }
            else {
                ((TreeNodeModel *)self.child[indexes - 1]).brother = nil;
            }
        }
        [self.child removeObjectAtIndex:indexes];
        return YES;
    }
    else {
        return NO;
    }
}

- (TreeNodeModel *)rootNode {
    TreeNodeModel *node = self;
    while (node.parent != nil) {
        node = node.parent;
    }
    return node;
}

-(void)clear {
    [self.child removeAllObjects];
}
-(NSString *)description

{
    
    return [NSString stringWithFormat:@"11  level = %d-----22upper: %@  33 code = %@ 44. levelDeep = %d",self.level, self.upper, self.code, self.levelDeep];
    
}

- (void)setIsChoose:(BOOL)isChoose
{
    _isChoose = isChoose;
    // 对当前的父类进行处理
    for (TreeNodeModel *model in self.parent.child) {
        if (model.isChoose == NO) {
            self.parent.isChoose = NO;
            break;
        } else {
            self.parent.isChoose = YES;
        }
    }
}
@end
