//
//  TreeNodeCell.h
//  redstar
//
//  Created by admin on 15/12/18.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "TreeNodeModel.h"
#import "CheckBoxButton.h"

@class TreeNodeCell;
@protocol TreeNodeDelegate <NSObject>
@optional
/**
 *  @brief  将要点击折叠图标，返回YES将执行，返回NO取消执行
 *  @param  tree    所在树
 *  @return YES-执行折叠展开操作，NO-不执行折叠展开操作
 */
-(BOOL)shouldClickFoldButtonAtNode:(TreeNodeCell *)node;

/**
 *  @brief  点击折叠图标后要执行的操作
 *  @param  node    所在节点
 *  @return void
 */
-(void)didClickFoldButtonAtNode:(TreeNodeCell *)node;

/**
 *  @brief  点击标题后要执行的操作
 *  @param  node    所在节点
 *  @return void
 */
-(void)didClickTitleAtNode:(TreeNodeCell *)node;
@end

@interface TreeNodeCell : UITableViewCell

@property (nonatomic, weak) TreeNodeModel *nodeData;
@property (nonatomic, weak) id<TreeNodeDelegate> nodeDelegate;
@property (nonatomic) UIButton *foldButton;
@property (nonatomic) CheckBoxButton *titleButton;
@property (nonatomic, strong) UIImageView *arrowImageView;
@end
