//
//  OnLineCompleteViewController.m
//  redstar
//
//  Created by admin on 15/11/29.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "OnLineCompleteViewController.h"
#import "OnLineCompleteCell.h"
#import "OnLineCompleteDetailCell.h"
#import "OnLineResultViewController.h"
#import "HttpClient.h"

#import "OnLineDetailModel.h"
#import "StoreDetailModel.h"

#define kOnLineCompleteCell @"onLineCompleteCell"
#define kOnLineCompleteDetailCell @"onLineCompleteDetailCell"
@interface OnLineCompleteViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) OnLineDetailModel *onLineDetail;
@property (nonatomic, assign) BOOL isOpen;

@property (nonatomic,strong) NSMutableArray *allStoreArray;
@end

@implementation OnLineCompleteViewController
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBar.hidden = NO;
    self.tabBarController.tabBar.hidden = YES;
    [self requestOnLineTaskComplete];

}
- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    [self setupNav];
    
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.allStoreArray = [NSMutableArray array];
    
    
    _isOpen = NO;
}

#pragma mark - Private Mothods
- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"任务完成情况一览"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
}

- (void)requestOnLineTaskComplete
{
    NSString *url = [NSString stringWithFormat:@"%@%@%@?fetch_parts=stores", kRedStarURL, kSportcheckDetailURL,self.uuid];
    url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
    HttpClient *httpClient= [[HttpClient alloc] initWithUrl:url];
    
    [httpClient getSportCheckDetailWithCompletion:^(id response, NSError *error) {
        NSDictionary *dataDict = response[@"data"];
        OnLineDetailModel *onlineDetail = [[OnLineDetailModel alloc] init];
        [onlineDetail setValuesForKeysWithDictionary:dataDict];
        _onLineDetail = onlineDetail;
        
        NSMutableArray *tempArray = [NSMutableArray array];
        for (NSDictionary *dict in _onLineDetail.stores) {
            StoreDetailModel *storeModel = [[StoreDetailModel alloc] init];
            [storeModel setValuesForKeysWithDictionary:dict];
            [tempArray addObject:storeModel];
        }
//        NSArray *sortedArray = [tempArray sortedArrayUsingComparator:^NSComparisonResult(StoreDetailModel *obj1, StoreDetailModel *obj2) {
//            NSDateFormatter *formatter = [[NSDateFormatter alloc] init] ;
//            [formatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
//            NSDate *otherDate = [formatter dateFromString:obj2.reportTime];
//            NSDate *currentDate = [formatter dateFromString:obj1.reportTime];
//            //默认按年龄排序
//            NSComparisonResult result = [otherDate compare:currentDate];//注意:基本数据类型要进行数据转换
//            //如果年龄一样，就按照名字排序
//            if (result == NSOrderedSame) {
//                result = [obj1.reportTime compare:obj2.reportTime];
//            }
//            return result;
//            
//        }];
//        NSLog(@"sort ==== %@", sortedArray);
        //_allStoreArray = (NSMutableArray *)sortedArray;

        _allStoreArray = tempArray;
        self.tableView.delegate = self;
        self.tableView.dataSource = self;
        [self.tableView reloadData];
        
    }];
    
}



- (void)doBack:(id)sender
{
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)unfoldCilck:(UIButton *)sender
{
    _isOpen = !_isOpen;
    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:0 inSection:0];
    [self.tableView reloadRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
    
}

#pragma mark - UITableView Delegate/DataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 2;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (section == 0) {
        return 1;
    } else {
        return _allStoreArray.count;
    }
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    NSString *indetifier = [NSString stringWithFormat:@"onLine%ld%ld",indexPath.section, indexPath.row];
    if (indexPath.section == 0) {
        OnLineCompleteDetailCell *cell = [tableView dequeueReusableCellWithIdentifier:kOnLineCompleteDetailCell];
        if (!cell) {
            cell = [[OnLineCompleteDetailCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kOnLineCompleteDetailCell];
        }
        
        cell.titleLabel.text = [NSString stringWithFormat:@"%@", _onLineDetail.title];
        
        if (_onLineDetail.create_time == nil || _onLineDetail.create_time == NULL || [_onLineDetail.create_time isEqual:[NSNull null]] || _onLineDetail.create_time == Nil || [_onLineDetail.create_time isEqualToString:@"(null)"]) {
            cell.startDate.textColor = kLightGray;
            cell.startDate.text = [NSString stringWithFormat:@"发起时间："];
        } else {
            NSString *startStr = [[NSString stringWithFormat:@"发起时间：%@", _onLineDetail.create_time] substringToIndex:15];
            NSMutableAttributedString *startAttr = [[NSMutableAttributedString alloc] initWithString:startStr];
            [startAttr addAttributes:@{NSForegroundColorAttributeName:kLightGray} range:NSMakeRange(0,5)];
            [startAttr addAttributes:@{NSForegroundColorAttributeName:kLightBlack} range:NSMakeRange(5,startStr.length  - 5)];
            cell.startDate.attributedText = startAttr;
        }

        if (_onLineDetail.endDate == nil || _onLineDetail.endDate == NULL || [_onLineDetail.endDate isEqual:[NSNull null]] || _onLineDetail.endDate == Nil || [_onLineDetail.endDate isEqualToString:@"(null)"]) {
            cell.overDate.textColor = kLightGray;
            cell.overDate.text = [NSString stringWithFormat:@"截止时间："];
        } else {
            NSString *startStr = [NSString stringWithFormat:@"截止时间：%@", _onLineDetail.endDate];
            NSMutableAttributedString *startAttr = [[NSMutableAttributedString alloc] initWithString:startStr];
            [startAttr addAttributes:@{NSForegroundColorAttributeName:kLightGray} range:NSMakeRange(0,5)];
            [startAttr addAttributes:@{NSForegroundColorAttributeName:kLightBlack} range:NSMakeRange(5,startStr.length  - 5)];
            cell.overDate.attributedText = startAttr;

            
//            cell.overDate.text = [NSString stringWithFormat:@"截止时间：%@", _onLineDetail.endDate];
        }

        
        cell.taskContent.text = @"任务内容：";
        [cell.unfoldBtn addTarget:self action:@selector(unfoldCilck:) forControlEvents:UIControlEventTouchUpInside];
        cell.arrowImageView.image = [UIImage imageNamed:@"grey-trilateral_down"];

        if (_isOpen) {
            cell.taskDetailLabel.text = [NSString stringWithFormat:@"    %@", _onLineDetail.content];
            cell.arrowImageView.transform = CGAffineTransformMakeRotation(-M_PI);
        } else {
            cell.taskDetailLabel.text = @"";
            cell.arrowImageView.transform = CGAffineTransformMakeRotation(0);
        }
        return cell;
    } else {
//        OnLineCompleteCell *cell = [tableView dequeueReusableCellWithIdentifier:kOnLineCompleteCell];
//        if (!cell) {
//            cell = [[OnLineCompleteCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kOnLineCompleteCell];
//        }
        OnLineCompleteCell *cell = [tableView dequeueReusableCellWithIdentifier:indetifier];
        if (!cell) {
            cell = [[OnLineCompleteCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:indetifier];
        }
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        cell.storeDetail = _allStoreArray[indexPath.row];
        return cell;
    }
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    if (section == 0) {
        return CGFLOAT_MIN;
    } else {
        return 45;
    }
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 0) {
        return;
    } else {
        
    
        StoreDetailModel *storeDetail = _allStoreArray[indexPath.row];
        
        if ([storeDetail.state isEqualToString:@"finished"]) {
            
        } else if ([storeDetail.state isEqualToString:@"reported"]) {
            
        } else {
            
        }
        
        
        OnLineResultViewController *onLineResult = [[OnLineResultViewController alloc] init];
        onLineResult.storeDetail = storeDetail;
        onLineResult.checkUuid = self.uuid;
        [self.navigationController pushViewController:onLineResult animated:YES];
    }
}



- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    if (section == 0) {
        return nil;
    }
    UIView *sectionView = [[UIView alloc] init];
    sectionView.backgroundColor = kSectionBackGroundColor;
    UILabel *shopList = [[UILabel alloc] init];
    shopList.translatesAutoresizingMaskIntoConstraints = NO;
    shopList.text = [NSString stringWithFormat:@"商场列表（%d/%d）", _onLineDetail.finishCount, _onLineDetail.storeCount];
    shopList.textColor = kNavigationBarColor;
    shopList.font = [UIFont systemFontOfSize:16.0];
    sectionView.layer.borderWidth = 0.5;
    sectionView.layer.borderColor = kSeparateLineCGColor;
    [sectionView addSubview:shopList];
    
    NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:shopList attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:titleLabelTop];
    
    NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:shopList attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [sectionView addConstraint:titleLabelLeft];
    
    NSLayoutConstraint *titleLabelRight = [NSLayoutConstraint constraintWithItem:shopList attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
    [sectionView addConstraint:titleLabelRight];
    
    NSLayoutConstraint *titleLabelBottom = [NSLayoutConstraint constraintWithItem:shopList attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:titleLabelBottom];
    return sectionView;
}



#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 200.0;
        //[_tableView registerClass:[OnLineCompleteCell class] forCellReuseIdentifier:kOnLineCompleteCell];
       [_tableView registerClass:[OnLineCompleteDetailCell class] forCellReuseIdentifier:kOnLineCompleteDetailCell];
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}


@end
