//
//  OnLineCompleteDetailCell.m
//  redstar
//
//  Created by admin on 15/12/9.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "OnLineCompleteDetailCell.h"

@implementation OnLineCompleteDetailCell

#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup
{
    self.taskDetailLabel.text = @"";
}

- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _titleLabel.textColor = kAnnounceTextColor;
        _titleLabel.font = [UIFont systemFontOfSize:18.0];
        [self.contentView addSubview:_titleLabel];
        
        NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self.contentView addConstraint:titleLabelTop];
        
        NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLabelLeft];
        
        NSLayoutConstraint *titleLabelWidth = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:titleLabelWidth];
        
        NSLayoutConstraint *titleLabelHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:27];
        [self.contentView addConstraint:titleLabelHeight];
    }
    return _titleLabel;
}


- (UILabel *)startDate
{
    if (!_startDate) {
        _startDate = [[UILabel alloc] init];
        _startDate.font = [UIFont systemFontOfSize:15.0];
        _startDate.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_startDate];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:Left];
        
        NSLayoutConstraint *right = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:right];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView  addConstraint:Height];
    }
    return _startDate;
}


- (UILabel *)overDate
{
    if (!_overDate) {
        _overDate = [[UILabel alloc] init];
        _overDate.font = [UIFont systemFontOfSize:15.0];
       // _overDate.textColor = kLightGray;
        _overDate.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView  addSubview:_overDate];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.startDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView  addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView  attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView  addConstraint:Left];
        
        NSLayoutConstraint *right = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:right];

        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView  addConstraint:Height];
    }
    return _overDate;
}

- (UILabel *)taskContent
{
    if (!_taskContent) {
        _taskContent = [[UILabel alloc] init];
        _taskContent.font = [UIFont systemFontOfSize:15.0];
        _taskContent.textColor = kLightGray;
        _taskContent.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_taskContent];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_taskContent attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView  addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_taskContent attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView  attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView  addConstraint:Left];
        
        NSLayoutConstraint *Width = [NSLayoutConstraint constraintWithItem:_taskContent attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
        [self.contentView  addConstraint:Width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_taskContent attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView  addConstraint:Height];
    }
    return _taskContent;
}

- (UIButton *)unfoldBtn
{
    if (!_unfoldBtn) {
        _unfoldBtn = [[UIButton alloc] init];
        _unfoldBtn.titleLabel.font = [UIFont systemFontOfSize:13.0];
        [_unfoldBtn setTitle:@"展开" forState:UIControlStateNormal];
        [_unfoldBtn setTitleColor:kLightGray forState:UIControlStateNormal];
        _unfoldBtn.tag = 2001;
        _unfoldBtn.translatesAutoresizingMaskIntoConstraints = NO;
        _unfoldBtn.contentHorizontalAlignment = UIControlContentHorizontalAlignmentRight;
        [self.contentView addSubview:_unfoldBtn];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_unfoldBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1.5];
        [self.contentView addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:_unfoldBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
        [self.contentView addConstraint:overDateWidth];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_unfoldBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.arrowImageView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-2];
        [self.contentView addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_unfoldBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:28];
        [self.contentView addConstraint:overDateHeight];
        
        
    }
    return _unfoldBtn;
}

- (UIImageView *)arrowImageView
{
    if (!_arrowImageView) {
        _arrowImageView = [[UIImageView alloc] init];
        _arrowImageView.translatesAutoresizingMaskIntoConstraints = NO;
        _arrowImageView.image = [UIImage imageNamed:@"grey-trilateral_down"];
        [self.contentView addSubview:_arrowImageView];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:8];
        [self.contentView addConstraint:Top];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:Right];
        
        NSLayoutConstraint *width = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:11];
        [self.contentView addConstraint:width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:8];
        [self.contentView addConstraint:Height];
    }
    return _arrowImageView;
}
- (UILabel *)taskDetailLabel
{
    if (!_taskDetailLabel) {
        _taskDetailLabel = [[UILabel alloc] init];
        _taskDetailLabel.font = [UIFont systemFontOfSize:15.0];
        _taskDetailLabel.numberOfLines = 0;
        _taskDetailLabel.textColor = kOnLineCompleteHeaderTextColor;
        _taskDetailLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_taskDetailLabel];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_taskDetailLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.taskContent attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView  addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_taskDetailLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView  attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView  addConstraint:Left];
        
        NSLayoutConstraint *right = [NSLayoutConstraint constraintWithItem:_taskDetailLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView  attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView  addConstraint:right];
        
        NSLayoutConstraint *overDateBottom = [NSLayoutConstraint constraintWithItem:_taskDetailLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-10];
        [self.contentView addConstraint:overDateBottom];
        _taskDetailLabel.text = @"";
    }
    return _taskDetailLabel;
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
