//
//  OnLineResultFootView.m
//  redstar
//
//  Created by admin on 15/12/10.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "OnLineResultFootView.h"
#import <UIImageView+WebCache.h>

@implementation OnLineResultFootView

- (instancetype)initWithPicArray:(NSArray *)picArray
{
    self = [super init];
    if (self) {
        [self setupWithPicArray:picArray];
    }
    return self;
}

- (void)setupWithPicArray:(NSArray *)picArray
{
    // 备注
    UILabel *remarkLanel = [[UILabel alloc] initWithFrame:CGRectMake(20, 5 ,kScreenWidth - 40, 30)];
    remarkLanel.font = [UIFont systemFontOfSize:15.0];
    remarkLanel.textColor = kLightGray;
    remarkLanel.text = @"处理说明";
    [self addSubview:remarkLanel];
    
    // 背景ImageView
    UIImageView *bgImageView = [[UIImageView alloc] init];
    bgImageView.translatesAutoresizingMaskIntoConstraints = NO;
    bgImageView.userInteractionEnabled = YES;
    UIImage *image = [UIImage imageNamed:@"textbox"];
    UIImage *resizingName = [image resizableImageWithCapInsets:UIEdgeInsetsMake(1, 1, 24, 24) resizingMode:UIImageResizingModeStretch];
    bgImageView.image = resizingName;
    [self addSubview:bgImageView];
    
    NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:bgImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:remarkLanel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self addConstraint:overDateTop];
    
    NSLayoutConstraint *overDateLeft = [NSLayoutConstraint constraintWithItem:bgImageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [self addConstraint:overDateLeft];
    
    NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:bgImageView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
    [self addConstraint:overDateRight];
    
    
    NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:bgImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:90];
    [self addConstraint:overDateWidth];
    
    // textView
    UITextView *textView = [[UITextView alloc] init];
    textView.backgroundColor = [UIColor clearColor];
    textView.translatesAutoresizingMaskIntoConstraints = NO;
    [bgImageView addSubview:textView];
    textView.delegate = self;
    _textView = textView;
    
    NSLayoutConstraint *textViewTop = [NSLayoutConstraint constraintWithItem:textView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:bgImageView attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
    [bgImageView addConstraint:textViewTop];
    
    NSLayoutConstraint *textViewLeft = [NSLayoutConstraint constraintWithItem:textView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:bgImageView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:1];
    [bgImageView addConstraint:textViewLeft];
    
    NSLayoutConstraint *textViewRight = [NSLayoutConstraint constraintWithItem:textView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:bgImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-1];
    [bgImageView addConstraint:textViewRight];
    
    
    NSLayoutConstraint *textViewWidth = [NSLayoutConstraint constraintWithItem:textView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:bgImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
    [bgImageView addConstraint:textViewWidth];
    
    UILabel *picLabel = [[UILabel alloc] init];
    picLabel.translatesAutoresizingMaskIntoConstraints = NO;
    picLabel.font = [UIFont systemFontOfSize:15.0];
    picLabel.textColor = kLightGray;
    picLabel.text = @"现场照片";
    [self addSubview:picLabel];
    
    NSLayoutConstraint *picLabelTop = [NSLayoutConstraint constraintWithItem:picLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:bgImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
    [self addConstraint:picLabelTop];
    
    NSLayoutConstraint *picLabelLeft = [NSLayoutConstraint constraintWithItem:picLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [self addConstraint:picLabelLeft];
    
    NSLayoutConstraint *picLabelRight = [NSLayoutConstraint constraintWithItem:picLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
    [self addConstraint:picLabelRight];
    
    
    NSLayoutConstraint *picLabelHeight = [NSLayoutConstraint constraintWithItem:picLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
    [self addConstraint:picLabelHeight];
    
    // 所有的现场图片
    self.backgroundColor = kSectionBackGroundColor;
    CGFloat imageMaginX = 20;
    CGFloat imageMaginY = 10;
    CGFloat imageW = (kScreenWidth - imageMaginX * 3) / 2;
    CGFloat imageH = 100;
    
    int answerCount = (int)picArray.count;
    int answerRow = 0;
    if (answerCount % 2 == 0) {
        answerRow = answerCount / 2;
    } else {
        answerRow = (answerCount + 1) / 2;
    }
    
    // 现场照片
    for (int i = 0; i < picArray.count; i++) {
        UIImageView *imageView = [[UIImageView alloc] init];
        imageView.userInteractionEnabled = YES;
        imageView.contentMode = UIViewContentModeScaleToFill;
        imageView.clipsToBounds = YES;
        imageView.tag = 1116 + i;
        NSDictionary *dict = (NSDictionary *)picArray[i];
        NSURL *imageUrl = [NSURL URLWithString:[NSString stringWithFormat:@"%@%@", kRedStarURL ,dict[@"fileUrl"]]];
        [imageView sd_setImageWithURL:imageUrl placeholderImage:[UIImage imageNamed:@"default_pic"]];
         UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(imageCilck:)];
         [imageView addGestureRecognizer:tap];
        int j = 0;
        if ((i + 1) % 2 == 0) {
            j = (i + 1) / 2;
            imageView.frame = CGRectMake(imageMaginX + (imageW + imageMaginX), 165 + (j-1) * (imageH + imageMaginY), imageW, imageH);
        } else {
            j = (i + 2) / 2;
            imageView.frame = CGRectMake(imageMaginX, 165 + (j-1) * (imageH + imageMaginY), imageW, imageH);
        }
        [self addSubview:imageView];
    }
    
    // 返回上一页
    UIButton *returnButton = [[UIButton alloc] init];
    returnButton.frame = CGRectMake(20, 175 + answerRow * (imageH + imageMaginY), kScreenWidth - 40, 35);
    returnButton.backgroundColor = kNavigationBarColor;
    returnButton.layer.cornerRadius = 4;
    [returnButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    returnButton.titleLabel.font = [UIFont systemFontOfSize:20.0];
    [self addSubview:returnButton];
    _returnButton = returnButton;
    
    self.height = 165 + answerRow * (imageH + imageMaginY) + 65;

}

- (void)imageCilck:(UITapGestureRecognizer *)sender
{
    if (_delegate && [_delegate respondsToSelector:@selector(showOnLinePicture:)]) {
        [_delegate showOnLinePicture:sender];
    }
}

#pragma mark - UItextView
- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text
{    
    if ([text isEqualToString:@"\n"]) {
        [self.textView resignFirstResponder];
        return NO;
    }
    
    return YES;
}

@end
