//
//  LookReportDetailViewController.m
//  redstar
//
//  Created by admin on 16/1/25.
//  Copyright © 2016年 ZWF. All rights reserved.
//

#import "LookReportDetailViewController.h"
#import "LookOnLineFootView.h"
#import "HttpClient.h"
#import "CommonFunc.h"
#import "OnLineDetailModel.h"
#import "UIImage+Fit.h"

#import "LargePictureViewController.h"

#import "LookOnLineDetailCell.h"
#define kLookOnLineDetailCell @"LookOnLineDetailCell"
#import "LookReportPicCell.h"
#define kLookReportPicCell @"lookReportPicCell"

#import <UIButton+WebCache.h>
#import "LookOnLineDealIntroCell.h"

#define kLookOnLineDealIntroCell @"lookOnLineDealIntroCell"

#import "PictureCommentTableCell.h"
#define kPicCommentsTableCell @"kPictuCommentsTableViewCell"

@interface LookReportDetailViewController ()<UITableViewDelegate, UITableViewDataSource, UINavigationControllerDelegate, UIImagePickerControllerDelegate, UIActionSheetDelegate, UITextViewDelegate>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) UIView *footView;
@property (nonatomic, strong) UIActionSheet *selectActionSheet;

@property (nonatomic, strong) NSMutableArray *imageNameArray;
@property (nonatomic, assign) NSInteger rowNumber;
@property (nonatomic, strong) NSMutableArray *commentsArray;
@end

@implementation LookReportDetailViewController
- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self setNav];
    
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    
    self.commentsArray = [NSMutableArray array];
    
    if (_lookOnLine.comments.count != 0) {
        for (NSDictionary *commentDict in _lookOnLine.comments) {
            [_commentsArray addObject:commentDict];
        }
    }
    
    
    if (_lookOnLine.attachments.count == 0) {
        self.imageNameArray = [NSMutableArray array];
    } else {
        self.imageNameArray = [NSMutableArray array];
        for (NSDictionary *dict in _lookOnLine.attachments) {
            NSString *imageName = [NSString stringWithFormat:@"%@%@", kRedStarURL, dict[@"fileUrl"]];
            NSURL *url = [NSURL URLWithString:imageName];
            [_imageNameArray addObject:url];
        }
    }
    
    if (_imageNameArray.count %2 == 0) {
        _rowNumber = _imageNameArray.count / 2;
    } else {
        _rowNumber = (_imageNameArray.count + 1) / 2;
    }
    
}
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBar.hidden = NO;
    self.tabBarController.tabBar.hidden = YES;
}

#pragma mark - Private Mothods
- (void)setNav
{
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
    
    
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"任务处理"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
}


- (void)reportRestult:(UIButton *)sender
{
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)doBack:(id)sender
{
    [self.navigationController popViewControllerAnimated:YES];
}




- (void)showLookOnLinePic:(UIButton *)sender
{
    LargePictureViewController *lager = [[LargePictureViewController alloc] init];
    lager.index = sender.tag - 1118;
    lager.pictureSaveMode = PictureNetWorkMode;
    lager.allImageArray = _imageNameArray;
    [self.navigationController pushViewController:lager animated:YES];
    
}


#pragma mark - UIActionSheetDelegate

- (void)actionSheet:(UIActionSheet *)actionSheet didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    if (actionSheet.tag == 999283) {
        if (buttonIndex == 0) {
            if (![UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]) {
                UIAlertView *alert = [[UIAlertView alloc] initWithTitle:nil message:@"找不到相机" delegate:nil cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
                [alert show];
            } else {
                UIImagePickerController *picker = [[UIImagePickerController alloc] init];
                picker.delegate = self;
                picker.sourceType = UIImagePickerControllerSourceTypeCamera;
                picker.modalTransitionStyle=UIModalTransitionStyleFlipHorizontal;
                picker.videoQuality = UIImagePickerControllerQualityTypeLow;
                [self presentViewController:picker animated:YES completion:nil];
            }
        } else if (buttonIndex == 1){
            UIImagePickerController *picker = [[UIImagePickerController alloc] init];
            picker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
            picker.delegate = self;
            //设置选择后的图片可被编辑
            picker.allowsEditing = YES;
            [self presentViewController:picker animated:YES completion:nil];
        }
    }
}



#pragma mark - UITableView Delegate/DataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 4;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (section == 0) {
        return 1;
    } else if (section == 1) {
        return _rowNumber;
    } else if (section == 2) {
        return 1;
    } else {
        return _commentsArray.count;
        //return 1;
    }
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 0) {
        LookOnLineDetailCell *cell=[tableView dequeueReusableCellWithIdentifier:kLookOnLineDetailCell];
        if (!cell) {
            cell = [[LookOnLineDetailCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kLookOnLineDetailCell];
        }
        cell.lookOnLine = _lookOnLine;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
        
    } else  if (indexPath.section == 1) {
        LookReportPicCell *cell = [tableView dequeueReusableCellWithIdentifier:kLookReportPicCell];
        if (!cell) {
            cell = [[LookReportPicCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kLookReportPicCell];
        }
        if (_imageNameArray.count % 2 == 1) {
            if (indexPath.row == _rowNumber - 1) {
                NSURL *imageURL = _imageNameArray[_imageNameArray.count - 1];
                [cell.photoButton1 sd_setImageWithURL:imageURL forState:UIControlStateNormal placeholderImage:[UIImage imageNamed:@"default_pic"]];
                [cell.photoButton1 addTarget:self action:@selector(showLookOnLinePic:) forControlEvents:UIControlEventTouchUpInside];
                cell.photoButton1.tag = 1118 + _imageNameArray.count - 1;
                cell.photoButton2.hidden = YES;
            } else {
                NSURL *imageURL1 = _imageNameArray[indexPath.row * 2];
                [cell.photoButton1 sd_setImageWithURL:imageURL1 forState:UIControlStateNormal placeholderImage:[UIImage imageNamed:@"default_pic"]];
                [cell.photoButton1 addTarget:self action:@selector(showLookOnLinePic:) forControlEvents:UIControlEventTouchUpInside];
                cell.photoButton1.tag = 1118 + indexPath.row * 2;
                NSURL *imageURL2 = _imageNameArray[indexPath.row * 2 + 1];
                [cell.photoButton2 sd_setImageWithURL:imageURL2 forState:UIControlStateNormal placeholderImage:[UIImage imageNamed:@"default_pic"]];
                [cell.photoButton2 addTarget:self action:@selector(showLookOnLinePic:) forControlEvents:UIControlEventTouchUpInside];
                cell.photoButton2.tag = 1118 + indexPath.row * 2 + 1;
            }
        } else {
            
            NSURL *imageURL1 = _imageNameArray[indexPath.row * 2];
            [cell.photoButton1 sd_setImageWithURL:imageURL1 forState:UIControlStateNormal placeholderImage:[UIImage imageNamed:@"default_pic"]];
            [cell.photoButton1 addTarget:self action:@selector(showLookOnLinePic:) forControlEvents:UIControlEventTouchUpInside];
            cell.photoButton1.tag = 1118 + indexPath.row * 2;
            
            NSURL *imageURL2 = _imageNameArray[indexPath.row * 2 + 1];
            [cell.photoButton2 sd_setImageWithURL:imageURL2 forState:UIControlStateNormal placeholderImage:[UIImage imageNamed:@"default_pic"]];
            [cell.photoButton2 addTarget:self action:@selector(showLookOnLinePic:) forControlEvents:UIControlEventTouchUpInside];
            cell.photoButton2.tag = 1118 + indexPath.row * 2 + 1;
        }
        
        return cell;
    } else if (indexPath.section == 2) {
        LookOnLineDealIntroCell *cell=[tableView dequeueReusableCellWithIdentifier:kLookOnLineDealIntroCell];
        if (!cell) {
            cell = [[LookOnLineDealIntroCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kLookOnLineDealIntroCell];
        }
        UIImage *image = [UIImage imageNamed:@"textbox"];
        UIImage *resizingName = [image resizableImageWithCapInsets:UIEdgeInsetsMake(1, 1, 24, 24) resizingMode:UIImageResizingModeStretch];
        cell.backImageView1.image = resizingName;
        cell.introLabel.text = @"处理说明";
        cell.contentTextView.text = [NSString stringWithFormat:@"%@", _lookOnLine.processNote];
        cell.contentTextView.userInteractionEnabled = NO;
        cell.commentLabel.text = @"评论";
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    } else {
        PictureCommentTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kPicCommentsTableCell];
        if (!cell) {
            cell = [[PictureCommentTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kPicCommentsTableCell];
        }
        NSDictionary *commentDict = _commentsArray[indexPath.row];
        
        cell.suggestLabel.text = [NSString stringWithFormat:@"%@", commentDict[@"comment"]];
        cell.peopleLabel.text = [NSString stringWithFormat:@"%@", commentDict[@"commentor_name"]];
        cell.dateLabel.text = [NSString stringWithFormat:@"%@", commentDict[@"commentTime"]];
        
        return cell;
    }
    
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}
- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}


#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.tableFooterView = self.footView;
        _tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 100.0;
        
        
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
       
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (UIView *)footView
{
    if (!_footView) {
        _footView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 55)];
        UIButton * resultButton = [[UIButton alloc] init];
        resultButton.backgroundColor = kNavigationBarColor;
        resultButton.frame = CGRectMake(20, 10, kScreenWidth - 40, 35);
        [resultButton setTitle:@"返回上一页" forState:UIControlStateNormal];
        [resultButton addTarget:self action:@selector(reportRestult:) forControlEvents:UIControlEventTouchUpInside];
        [_footView addSubview:resultButton];

    }
    return _footView;
}

//- (LookOnLineFootView *)footView
//{
//    if (!_footView) {
//        _footView = [[LookOnLineFootView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 180)];
//        _footView.contentTextView.userInteractionEnabled = NO;
//        _footView.contentTextView.text = [NSString stringWithFormat:@"%@", _lookOnLine.processNote];
//        _footView.placeholderLabel2.hidden = YES;
//        _footView.backgroundColor = [UIColor whiteColor];
//        [_footView.resultButton setTitle:@"返回上一页" forState:UIControlStateNormal];
//        [_footView.resultButton addTarget:self action:@selector(reportRestult:) forControlEvents:UIControlEventTouchUpInside];
//    }
//    return _footView;
//}


@end
