//
//  LookOnLineDealIntroCell.m
//  redstar
//
//  Created by admin on 16/2/22.
//  Copyright © 2016年 ZWF. All rights reserved.
//

#import "LookOnLineDealIntroCell.h"

@interface LookOnLineDealIntroCell ()

@end



@implementation LookOnLineDealIntroCell
- (UILabel *)introLabel
{
    if (!_introLabel) {
        _introLabel = [[UILabel alloc] init];
        _introLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _introLabel.font = [UIFont systemFontOfSize:15.0];
        _introLabel.textColor = kLightBlack;
        [self.contentView addSubview:_introLabel];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_introLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentView addConstraint:contentHeight];
    }
    return _introLabel;
    
}

- (UIImageView *)backImageView1
{
    if (!_backImageView1) {
        _backImageView1 = [[UIImageView alloc] init];
        _backImageView1.userInteractionEnabled = YES;
        _backImageView1.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_backImageView1];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.introLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_backImageView1 attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:90];
        [self.contentView addConstraint:contentHeight];
    }
    return _backImageView1;
}

- (UITextView *)contentTextView
{
    if (!_contentTextView) {
        _contentTextView = [[UITextView alloc] init];
        _contentTextView.font = [UIFont systemFontOfSize:15.0];
        _contentTextView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.backImageView1 addSubview:_contentTextView];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeTop multiplier:1.0 constant:1];
        [self.backImageView1 addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeLeft multiplier:1.0 constant:1];
        [self.backImageView1 addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeRight multiplier:1.0 constant:-1];
        [self.backImageView1 addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_contentTextView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-1];
        [self.backImageView1 addConstraint:contentHeight];
    }
    return _contentTextView;
}

- (UILabel *)commentLabel
{
    if (!_commentLabel) {
        _commentLabel = [[UILabel alloc] init];
        _commentLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _commentLabel.font = [UIFont systemFontOfSize:15.0];
        _commentLabel.textColor = kLightBlack;
        [self.contentView addSubview:_commentLabel];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_commentLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backImageView1 attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_commentLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_commentLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_commentLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentView addConstraint:contentHeight];
        
        NSLayoutConstraint *contentBottom = [NSLayoutConstraint constraintWithItem:_commentLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-2];
        [self.contentView addConstraint:contentBottom];
    }
    return _commentLabel;
}


@end
