//
//  AnnounceDetailFootView.m
//  redstar
//
//  Created by admin on 15/11/30.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "AnnounceDetailFootView.h"

@implementation AnnounceDetailFootView


- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup
{
    self.titleLabel.text = @"附件";
}

- (void)setAnnoDetail:(AnnounceDetailModel *)annoDetail
{
    _annoDetail = annoDetail;
    
    
}

- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.textColor = kNavigationBarColor;
        _titleLabel.font = [UIFont systemFontOfSize:13.0];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_titleLabel];
        
        NSLayoutConstraint *contentTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:20];
        [self addConstraint:contentTop];
        
        NSLayoutConstraint *contentLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:contentLeft];
        
        NSLayoutConstraint *contentRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:contentRight];
        
        NSLayoutConstraint *contentHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self addConstraint:contentHeight];
    }
    return _titleLabel;
}
@end
