//
//  AttachmentTableViewCell.m
//  redstar
//
//  Created by admin on 15/12/25.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "AttachmentTableViewCell.h"

@implementation AttachmentTableViewCell

- (UIButton *)nameBtn
{
    if (!_nameBtn) {
        _nameBtn = [[UIButton alloc] init];
        _nameBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_nameBtn setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        _nameBtn.titleLabel.font = [UIFont systemFontOfSize:15.0];
        _nameBtn.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft ;
        _nameBtn.layer.cornerRadius = 4.0;
        [self.contentView addSubview:_nameBtn];
        
        NSLayoutConstraint *lineViewTop = [NSLayoutConstraint constraintWithItem:_nameBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
        [self.contentView addConstraint:lineViewTop];
        
        NSLayoutConstraint *lineViewRight = [NSLayoutConstraint constraintWithItem:_nameBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.downloadBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-10];
        [self.contentView addConstraint:lineViewRight];
        
        NSLayoutConstraint *lineViewBottom = [NSLayoutConstraint constraintWithItem:_nameBtn attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-5];
        [self.contentView addConstraint:lineViewBottom];
        
        NSLayoutConstraint *lineViewLeft = [NSLayoutConstraint constraintWithItem:_nameBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:lineViewLeft];
        
        NSLayoutConstraint *lineViewHeight = [NSLayoutConstraint constraintWithItem:_nameBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:35];
        [self.contentView addConstraint:lineViewHeight];
        
    }
    return _nameBtn;
}

- (UIButton *)downloadBtn
{
    if (!_downloadBtn) {
        _downloadBtn = [[UIButton alloc] init];
        _downloadBtn.titleLabel.font = [UIFont systemFontOfSize:15.0];
        _downloadBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_downloadBtn setTitle:@"下载" forState:UIControlStateNormal];
        [_downloadBtn setTitle:@"已下载" forState:UIControlStateSelected];
        _downloadBtn.layer.cornerRadius = 4.0;
        [self.contentView addSubview:_downloadBtn];
        
        NSLayoutConstraint *lineViewTop = [NSLayoutConstraint constraintWithItem:_downloadBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:8];
        [self.contentView addConstraint:lineViewTop];
        
        NSLayoutConstraint *lineViewRight = [NSLayoutConstraint constraintWithItem:_downloadBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:lineViewRight];
        
        NSLayoutConstraint *lineViewBottom = [NSLayoutConstraint constraintWithItem:_downloadBtn attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-8];
        [self.contentView addConstraint:lineViewBottom];
        
        NSLayoutConstraint *lineViewWidth = [NSLayoutConstraint constraintWithItem:_downloadBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
        [self.contentView addConstraint:lineViewWidth];
    }
    return _downloadBtn;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
