//
//  HomeCellItem.m
//  redstar
//
//  Created by admin on 15/10/30.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "HomeCellItem.h"

@implementation HomeCellItem

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        self.imageView.contentMode = UIViewContentModeCenter;
        [self setTitleColor:kHomeItemTextColor forState:UIControlStateNormal];
        self.titleLabel.textAlignment = NSTextAlignmentCenter;
        self.titleLabel.font = [UIFont systemFontOfSize:15];
        [self setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        [self setTitleColor:[UIColor orangeColor] forState:UIControlStateSelected];
        
    }
    return self;
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    
    CGFloat btnW = self.width;
    CGFloat btnH = self.height;
    self.imageView.frame = CGRectMake((btnW - 45) / 2 , 13, 45, 45);
    
    CGFloat titleH = btnH - 55;
    CGFloat titleY = 61;
    self.titleLabel.frame = CGRectMake(0, titleY, btnW, titleH);
    
//    // 设置badgeView尺寸
//    self.badgeView.x = self.width - self.badgeView.width - HMMargin;
//    
//    self.badgeView.y = 0;
    
    
}
@end
