//
//  InspectDetailHeaderView.m
//  redstar
//
//  Created by admin on 15/11/12.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "InspectDetailHeaderView.h"

@implementation InspectDetailHeaderView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

#pragma mark - Private Methods
- (void)setup
{
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    titleLabel.textAlignment = NSTextAlignmentCenter;
    titleLabel.textColor = kAnnounceTextColor;
    titleLabel.backgroundColor = kSectionBackGroundColor;
    titleLabel.font = [UIFont systemFontOfSize:17.0];
    [self addSubview:titleLabel];
    
    NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [self addConstraint:titleLabelTop];
    
    NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [self addConstraint:titleLabelLeft];
    
    NSLayoutConstraint *titleLabelWidth = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self addConstraint:titleLabelWidth];
    
    NSLayoutConstraint *titleLabelHeight = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
    [self addConstraint:titleLabelHeight];
    
    _titleLabel = titleLabel;
    
    
    self.detailView.backgroundColor = [UIColor whiteColor];
    
    UILabel *classifyLabel = [[UILabel alloc] init];
    classifyLabel.translatesAutoresizingMaskIntoConstraints = NO;
    classifyLabel.textColor = kAnnounceTextColor;
    classifyLabel.backgroundColor = [UIColor clearColor];
    classifyLabel.font = [UIFont systemFontOfSize:15.0];
    classifyLabel.text = @"分类项目";
    [self addSubview:classifyLabel];
    
    NSLayoutConstraint *classifyTop = [NSLayoutConstraint constraintWithItem:classifyLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:245];
    [self addConstraint:classifyTop];
    
    NSLayoutConstraint *classifyLeft = [NSLayoutConstraint constraintWithItem:classifyLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [self addConstraint:classifyLeft];
    
    
    NSLayoutConstraint *classifyHeight = [NSLayoutConstraint constraintWithItem:classifyLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:39];
    [self addConstraint:classifyHeight];
}

- (void)setTaskDetail:(TaskDetailModel *)taskDetail
{
    _taskDetail = taskDetail;
    self.titleLabel.text = [NSString stringWithFormat:@"%@", taskDetail.name];
    self.detailView.shopnameLabel.text = [NSString stringWithFormat:@"%@", taskDetail.store_name];
    self.detailView.startDateLabel.text = [NSString stringWithFormat:@"%@", taskDetail.beginDate];
    self.detailView.overDateLabel.text = [NSString stringWithFormat:@"%@", taskDetail.endDate];
    if (taskDetail.questionCount == 0 || taskDetail.reportCount == 0) {
        self.detailView.multiplier = 0;
    } else {
        self.detailView.multiplier = (CGFloat)taskDetail.reportCount / taskDetail.questionCount;
    }
    
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyy-MM-dd"];
    // 当前时间
    NSDate *date = [NSDate date];
    NSTimeZone *zone = [NSTimeZone systemTimeZone];
    NSInteger interval = [zone secondsFromGMTForDate: date];
    NSDate *localeDate = [date  dateByAddingTimeInterval: interval];
    NSString *strDate = [dateFormatter stringFromDate:localeDate];
    NSDate *today = [dateFormatter dateFromString:strDate];
    NSLog(@"today = %@", today);
    // endTime
    NSDate *endTime = [dateFormatter dateFromString:[NSString stringWithFormat:@"%@", taskDetail.endDate]];
    NSLog(@"endTime = %@", endTime);
    NSCalendar *cal = [NSCalendar currentCalendar];
    unsigned int unitFlags = NSYearCalendarUnit | NSMonthCalendarUnit | NSDayCalendarUnit;
    NSDateComponents *d = [cal components:unitFlags fromDate:today toDate:endTime options:0];
    if (d.day > 0) {
        self.detailView.dayLabel.text = [NSString stringWithFormat:@"%ld", (long)d.day];
    } else {
        self.detailView.dayLabel.text = @"0";
    }
    
    
    if ([taskDetail.state isEqualToString:@"initial"]) {
        if (taskDetail.reportCount == 0 || taskDetail.questionCount == 0) {
            self.detailView.progressLabel.text = @"0%";
        } else {
            self.detailView.progressLabel.text = [NSString stringWithFormat:@"未处理 %.0f%%", (CGFloat)taskDetail.reportCount / taskDetail.questionCount * 100];
        }
        self.detailView.progressLabel.textColor = kProgressUnSettledColor;
        self.detailView.alreadyLabel.textColor = kProgressUnSettledColor;
        self.detailView.allLabel.textColor = kProgressUnSettledColor;
    } else if ([taskDetail.state isEqualToString:@"processing"]) {
        self.detailView.progressLabel.text = [NSString stringWithFormat:@"进行中 %.0f%%", (CGFloat)taskDetail.reportCount / taskDetail.questionCount * 100];
        self.detailView.progressLabel.textColor = kProgressDealWithColor;
        self.detailView.alreadyLabel.textColor = kProgressDealWithColor;
        self.detailView.allLabel.textColor = kProgressDealWithColor;

    } else if ([taskDetail.state isEqualToString:@"reported"]) {
        self.detailView.progressLabel.text = [NSString stringWithFormat:@"已上报 %.0f%%", (CGFloat)taskDetail.reportCount / taskDetail.questionCount * 100];
        self.detailView.progressLabel.textColor = kProgressDealWithColor;
        self.detailView.alreadyLabel.textColor = kProgressDealWithColor;
        self.detailView.allLabel.textColor = kProgressDealWithColor;
        
    } else if ([taskDetail.state isEqualToString:@"finished"]) {
        self.detailView.progressLabel.text = [NSString stringWithFormat:@"已评分 %.0f%%", (CGFloat)taskDetail.reportCount / taskDetail.questionCount * 100];
        self.detailView.progressLabel.textColor = kProgressDealWithColor;
        self.detailView.alreadyLabel.textColor = kProgressDealWithColor;
        self.detailView.allLabel.textColor = kProgressDealWithColor;
    } else if ([taskDetail.state isEqualToString:@"published"]) {
        self.detailView.progressLabel.text = [NSString stringWithFormat:@"已发布 %.0f%%", (CGFloat)taskDetail.reportCount / taskDetail.questionCount * 100];
        self.detailView.progressLabel.textColor = kProgressDealWithColor;
        self.detailView.alreadyLabel.textColor = kProgressDealWithColor;
        self.detailView.allLabel.textColor = kProgressDealWithColor;
    } else {
        self.detailView.progressLabel.text = [NSString stringWithFormat:@"已过期 %.0f%%", (CGFloat)taskDetail.reportCount / taskDetail.questionCount * 100];
        self.detailView.progressLabel.textColor = kProgressOverDueColor;
        self.detailView.alreadyLabel.textColor = kProgressOverDueColor;
        self.detailView.allLabel.textColor = kProgressOverDueColor;
    }
    self.detailView.allView.backgroundColor = kProgressViewAllBackColor;
    self.detailView.alreadyView.backgroundColor = kProgressViewAlreadyBackColor;
    
    self.detailView.alreadyLabel.text = [NSString stringWithFormat:@"%d", taskDetail.reportCount];
    self.detailView.allLabel.text = [NSString stringWithFormat:@"/%d", taskDetail.questionCount];

}



- (InspectDetailView *)detailView
{
    if (!_detailView) {
        _detailView = [[InspectDetailView alloc] init];
        _detailView.translatesAutoresizingMaskIntoConstraints = NO;
        
        [self addSubview:_detailView];
        
        NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:_detailView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:45];
        [self addConstraint:titleLabelTop];
        
        NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:_detailView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:titleLabelLeft];
        
        NSLayoutConstraint *titleLabelWidth = [NSLayoutConstraint constraintWithItem:_detailView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:titleLabelWidth];
        
        NSLayoutConstraint *titleLabelHeight = [NSLayoutConstraint constraintWithItem:_detailView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:200];
        [self addConstraint:titleLabelHeight];
    }
    return _detailView;
}

@end
