//
//  QuestionDetailViewController.m
//  redstar
//
//  Created by admin on 15/11/2.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "QuestionDetailViewController.h"
#import "QuestionDetailCell.h"
#import "QuestionCommentCell.h"
#import "QuestionDescribeCell.h"

#import "CommentView.h"
#import "HttpClient.h"
#import <MBProgressHUD.h>

#import "QuestionDetailModel.h"
#import "CommentModel.h"

#define kQuestionDetailCell @"QuestionDetailCell" // 问题详情
#define kQuestionCommentCell @"QuestionCommentCell" // 评论
#define kQuestionDescribeCell @"QuestionDescribeCell" // 问题描述
@interface QuestionDetailViewController ()<UITableViewDelegate, UITableViewDataSource, UIAlertViewDelegate, UITextViewDelegate>
@property (nonatomic, strong) UITableView *tableView;

@property (nonatomic, strong) UIView *backGroundView;
@property (nonatomic, strong) CommentView *commentView;
@property (nonatomic, strong) QuestionDetailModel *questionDetailModel;
@property (nonatomic, strong) NSMutableArray *allCommentArray;


@end

@implementation QuestionDetailViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    
    [self setupNav];
    
    // 问题详情
    [self requestQestionDetail];
    
    self.view.backgroundColor = kSectionBackGroundColor;
    

}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBar.hidden = NO;

    self.tabBarController.tabBar.hidden = YES;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Methods
- (void)requestQestionDetail
{
    self.allCommentArray = [NSMutableArray array];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    
    NSString *url = [NSString stringWithFormat:@"%@%@%@?userUuid=%@", kRedStarURL, kQuestionDetailURL, _questionUuid ,user_uuid];
    
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:url];
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    [httpClient getQuestionDetailWithParameters:nil completion:^(id response, NSError *error) {
        NSDictionary *dict = response[@"data"];
        NSLog(@"问题详情 = %@", dict);
        QuestionDetailModel *quesDetail = [[QuestionDetailModel alloc] init];
        [quesDetail setValuesForKeysWithDictionary:dict];
        _questionDetailModel = quesDetail;
        
        NSArray *commentArray = _questionDetailModel.comments;
        for (NSDictionary *dict in commentArray) {
            CommentModel *comment = [[CommentModel alloc] init];
            [comment setValuesForKeysWithDictionary:dict];
            [_allCommentArray addObject:comment];
        }
        [MBProgressHUD hideHUDForView:self.view animated:YES];
        [self.tableView reloadData];
    }];
}

- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"问题详情"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
    
}

// 返回上一页面
- (void)doBack:(UIBarButtonItem *)sender
{
    [self.navigationController popViewControllerAnimated:YES];
    
}

- (void)addComment:(UIButton *)sender
{
    NSArray *permissions = [[NSUserDefaults standardUserDefaults] objectForKey:@"permissions"];
    if ([permissions containsObject:@"500504"]) {
        if (!_backGroundView) {
            _backGroundView = [[UIView alloc] initWithFrame:self.view.bounds];
            UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeBackGroundView)];
            [_backGroundView addGestureRecognizer:tapGR];
        }
        if (!_commentView) {
            _commentView = [[CommentView alloc] init];
            _commentView.backgroundColor = [UIColor whiteColor];
        }
        _commentView.contentTextView.text = @"";
        _commentView.contentTextView.delegate = self;
        [_commentView.quitBtn addTarget:self action:@selector(closeBackGroundView) forControlEvents:UIControlEventTouchUpInside];
        [_commentView.sureBtn addTarget:self action:@selector(submitComment:) forControlEvents:UIControlEventTouchUpInside];
        [self.view insertSubview:_backGroundView aboveSubview:_tableView];
        [self.view insertSubview:_commentView aboveSubview:_backGroundView];
        
        _backGroundView.alpha = 0;
        _backGroundView.backgroundColor = [UIColor blackColor];
        
        CGRect toFrame = CGRectMake(0, self.view.frame.size.height - kCommentViewHeight, kScreenWidth, kCommentViewHeight);
        CGRect fromFrame = CGRectMake(0, kScreenHeight, kScreenWidth, kCommentViewHeight);
        
        _commentView.frame = fromFrame;
        [UIView animateWithDuration:0.3 animations:^{
            _backGroundView.alpha = 0.6;
            _commentView.frame = toFrame;
        }];

    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您没有添加评论的权限！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
    }
    
}




// 提交评论
- (void)submitComment:(UIButton *)sender
{
    
    NSDate *date = [NSDate date];
    NSTimeZone *zone = [NSTimeZone systemTimeZone];
    NSInteger interval = [zone secondsFromGMTForDate:date];
    NSDate *localeDate = [date  dateByAddingTimeInterval:interval];
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"YYYY-MM-dd+hh:mm:ss"];
    NSString *dateString = [dateFormatter stringFromDate:localeDate];
    
    
    NSString *operId = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_code"];
    NSString *operName = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_name"];
    
    NSString *url  = [NSString stringWithFormat:@"%@%@?time=%@&operId=%@&operName=%@", kRedStarURL, kAddCommentURL , dateString , operId, operName];
    url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
    NSLog(@"url = %@", url);
    
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:url];
    NSDictionary *parameters = @{@"entityType":@"question",
                                 @"entityUuid":_questionUuid,
                                 @"comment":_commentView.contentTextView.text};
    NSLog(@"parameters = %@", parameters);
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    [httpClient submitCommentWithParameters:parameters completion:^(id response, NSError *error) {
        NSLog(@"respo = %@, error = %@", response , error);
        if ([response[@"message"] isEqualToString:@"ok"]) {
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"添加评论成功" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
            alert.delegate = self;
            [alert show];
            [MBProgressHUD hideHUDForView:self.view animated:YES];
        } else {
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"警告" message:@"添加评论失败" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
            [alert show];
            [MBProgressHUD hideHUDForView:self.view animated:YES];
        }
    }];
    
    [self closeBackGroundView];
}

- (void)closeBackGroundView
{
    CGRect fromFrame = CGRectMake(0, kScreenHeight, kScreenWidth, kCommentViewHeight);
    [UIView animateWithDuration:0.3 animations:^{
        _backGroundView.alpha = .0f;
        _commentView.frame = fromFrame;
    } completion:^(BOOL finished) {
        [_backGroundView removeFromSuperview];
        [_commentView removeFromSuperview];
    }];
}

- (void)addZan:(ZanButton *)sender
{
    NSArray *permissions = [[NSUserDefaults standardUserDefaults] objectForKey:@"permissions"];
    if ([permissions containsObject:@"500505"]) {
        
        sender.selected = !sender.selected;
        
        NSDate *date = [NSDate date];
        NSTimeZone *zone = [NSTimeZone systemTimeZone];
        NSInteger interval = [zone secondsFromGMTForDate:date];
        NSDate *localeDate = [date  dateByAddingTimeInterval:interval];
        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        [dateFormatter setDateFormat:@"YYYY-MM-dd+hh:mm:ss"];
        NSString *dateString = [dateFormatter stringFromDate:localeDate];
        
        
        NSString *operId = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_code"];
        NSString *operName = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_name"];
        
        if (sender.selected) {
            // 点赞
            NSString *url = [NSString stringWithFormat:@"%@%@%@?time=%@&operId=%@&operName=%@", kRedStarURL, kAddLikeURL, _questionUuid, dateString, operId, operName];
            url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
            
            HttpClient *httpClient = [[HttpClient alloc] initWithUrl:url];
            [httpClient likeCountWithParameters:nil completion:^(id response, NSError *error) {
                if (response[@"success"]) {
                    int likeCount = [sender.titleLabel.text intValue];
                    [sender setTitle:[NSString stringWithFormat:@"%d", likeCount + 1] forState:UIControlStateNormal];
                } else {
                    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"警告" message:@"点赞失败！" delegate:self cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
                    [alert show];
                }
            }];
        } else {
            // 取消点赞
            NSString *url = [NSString stringWithFormat:@"%@%@%@?time=%@&operId=%@&operName=%@", kRedStarURL, kCancelLikeURL, _questionUuid, dateString, operId, operName];
            url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];
            
            HttpClient *httpClient = [[HttpClient alloc] initWithUrl:url];
            [httpClient likeCountWithParameters:nil completion:^(id response, NSError *error) {
                NSLog(@"取消点赞response = %@", response);
                if (response[@"success"]) {
                    int likeCount = [sender.titleLabel.text intValue];
                    [sender setTitle:[NSString stringWithFormat:@"%d", likeCount - 1] forState:UIControlStateNormal];
                } else {
                    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"警告" message:@"取消点赞失败！" delegate:self cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
                    [alert show];
                }
            }];
        }
    } else {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"您没有点赞的权限！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
        [alert show];
    }
}



#pragma mark - UItextDelegate
- (void)textViewDidBeginEditing:(UITextView *)textView
{
    [UIView animateWithDuration:0.3 animations:^{
        _commentView.frame = CGRectMake(0, self.view.frame.size.height - kCommentViewHeight - 173, kScreenWidth, kCommentViewHeight);
    }];
}

- (void)textViewDidEndEditing:(UITextView *)textView
{
    [UIView animateWithDuration:0.3 animations:^{
        _commentView.frame = CGRectMake(0, self.view.frame.size.height - kCommentViewHeight, kScreenWidth, kCommentViewHeight);
    }];
}

- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text
{
    if (![text isEqualToString:@""]) {
        _commentView.placeholderLabel2.hidden = YES;
    }
    
    if ([text isEqualToString:@""] && range.location == 0 && range.length == 1) {
        _commentView.placeholderLabel2.hidden = NO;
    }
    
    if ([text isEqualToString:@"\n"]) {
        [_commentView.contentTextView resignFirstResponder];
        if (textView.text.length != 0) {
            _commentView.placeholderLabel2.hidden = YES;
        } else {
            _commentView.placeholderLabel2.hidden = NO;
        }
        return NO;
    }
    
    return YES;
}

#pragma mark - UITableView Delegate/DataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 3;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (section == 0) {
        return 1;
    } else if (section == 1) {
        return 1;
    } else {
        return _allCommentArray.count;
    }
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
 
    if (indexPath.section == 0) {
        QuestionDetailCell *cell=[tableView dequeueReusableCellWithIdentifier:kQuestionDetailCell];
        if (!cell) {
            cell = [[QuestionDetailCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kQuestionDetailCell];
        }
        cell.questionDetail = self.questionDetailModel;
        [cell.thumbBtn addTarget:self action:@selector(addZan:) forControlEvents:UIControlEventTouchUpInside];
        return cell;

    } else if (indexPath.section == 1) {
        QuestionDescribeCell *cell=[tableView dequeueReusableCellWithIdentifier:kQuestionDescribeCell];
        if (!cell) {
            cell = [[QuestionDescribeCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kQuestionDescribeCell];
        }
        cell.questionDetail = self.questionDetailModel;
        return cell;

    } else {
        QuestionCommentCell *cell=[tableView dequeueReusableCellWithIdentifier:kQuestionCommentCell];
        if (!cell) {
            cell = [[QuestionCommentCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kQuestionCommentCell];
        }
        cell.commentModel = _allCommentArray[indexPath.row];
        return cell;
    }
}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    if (section == 0) {
        return CGFLOAT_MIN;
    } else if (section == 1) {
        return CGFLOAT_MIN;
    } else {
        return 50;
    }
    
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}



// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    if (section == 2) {
        // 创建sectionView
        UIView *sectionView = [[UIView alloc] init];
        sectionView.userInteractionEnabled = YES;
        sectionView.backgroundColor = kInspectSectionBackGroundColor;
        
        // 创建标题label
        UILabel *titleLabel = [[UILabel alloc] init];
        titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        titleLabel.textColor = kHomeSectionTitleTextColor;
        titleLabel.font = [UIFont systemFontOfSize:16.0];
        titleLabel.text = @"评论";
        [sectionView addSubview:titleLabel];
        
        NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:2];
        [sectionView addConstraint:titleLabelTop];
        
        NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [sectionView addConstraint:titleLabelLeft];
        
        NSLayoutConstraint *titleLabelWidth = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
        [sectionView addConstraint:titleLabelWidth];
        
        NSLayoutConstraint *titleLabelBottom = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [sectionView addConstraint:titleLabelBottom];
        
        // 创建标题label
        UIButton *titleBtn = [[UIButton alloc] init];
        titleBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [titleBtn setTitle:@"添加评论" forState:UIControlStateNormal];
        [titleBtn setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        [titleBtn addTarget:self action:@selector(addComment:) forControlEvents:UIControlEventTouchUpInside];
        titleBtn.titleLabel.font = [UIFont systemFontOfSize:14.0];
        titleBtn.layer.borderColor = kNavigationBarCGColor;
        titleBtn.layer.borderWidth = 1.0;
        titleBtn.layer.cornerRadius = 5;
        titleBtn.backgroundColor = [UIColor whiteColor];
        [sectionView addSubview:titleBtn];
        
        NSLayoutConstraint *titleBtnTop = [NSLayoutConstraint constraintWithItem:titleBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [sectionView addConstraint:titleBtnTop];
        
        NSLayoutConstraint *titleBtnRight = [NSLayoutConstraint constraintWithItem:titleBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [sectionView addConstraint:titleBtnRight];
        
        NSLayoutConstraint *titleBtnWidth = [NSLayoutConstraint constraintWithItem:titleBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:80];
        [sectionView addConstraint:titleBtnWidth];
        
        NSLayoutConstraint *titleBtnBottom = [NSLayoutConstraint constraintWithItem:titleBtn attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-10];
        [sectionView addConstraint:titleBtnBottom];
    
        
        return sectionView;
    }
    else {
        return nil;
    }
}

#pragma mark - UIAlertViewDelegate
-(void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex
{
    if (buttonIndex == 0) {
        
        NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
        NSString *url = [NSString stringWithFormat:@"%@%@%@?userUuid=%@", kRedStarURL, kQuestionDetailURL, _questionUuid ,user_uuid];
        
        HttpClient *httpClient = [[HttpClient alloc] initWithUrl:url];
        [MBProgressHUD showHUDAddedTo:self.view animated:YES];
        [httpClient getQuestionDetailWithParameters:nil completion:^(id response, NSError *error) {
            NSDictionary *dict = response[@"data"];
            NSLog(@"问题详情 = %@", dict);
            QuestionDetailModel *quesDetail = [[QuestionDetailModel alloc] init];
            [quesDetail setValuesForKeysWithDictionary:dict];
            _questionDetailModel = quesDetail;
            
            NSArray *commentArray = _questionDetailModel.comments;
            NSMutableArray *tempArray = [NSMutableArray array];
            for (NSDictionary *dict in commentArray) {
                CommentModel *comment = [[CommentModel alloc] init];
                [comment setValuesForKeysWithDictionary:dict];
                [tempArray addObject:comment];
            }
            _allCommentArray = tempArray;
            [self.tableView reloadData];
            [MBProgressHUD hideHUDForView:self.view animated:YES];

        }];
    }
}

#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 400.0;
        [_tableView registerClass:[QuestionDetailCell class] forCellReuseIdentifier:kQuestionDetailCell];
        [_tableView registerClass:[QuestionCommentCell class] forCellReuseIdentifier:kQuestionCommentCell];
        [_tableView registerClass:[QuestionDescribeCell class] forCellReuseIdentifier:kQuestionDescribeCell];
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}








@end
