//
//  QuestionDescribeCell.m
//  redstar
//
//  Created by admin on 15/11/3.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "QuestionDescribeCell.h"
#import <UIImageView+WebCache.h>

@interface QuestionDescribeCell ()
@property (nonatomic, strong) NSLayoutConstraint *picConstraint;
@end

@implementation QuestionDescribeCell
#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

#pragma mark - Private Methods
- (void)setup
{
    self.titleLabel.textColor = kDetailCellDescribeTextColor;
    _titleLabel.text = @"问题与建议描述";
    
    self.pictureLabel.textColor = kDetailCellDescribeTextColor;
    _pictureLabel.text = @"照片";
    
    self.pictureView.backgroundColor = [UIColor whiteColor];
    
    self.feedbackLabel.textColor = kDetailCellDescribeTextColor;
    self.feedbackBackView.backgroundColor = kQuestionFeedBackColor;

}

- (void)setQuestionDetail:(QuestionDetailModel *)questionDetail
{
    _questionDetail = questionDetail;
    
    // 问题与描述
    NSString *describeStr = [NSString stringWithFormat:@"%@", questionDetail.content];
    NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc] initWithString:describeStr];
    NSMutableParagraphStyle *paragraphStyle1 = [[NSMutableParagraphStyle alloc] init];
    paragraphStyle1.alignment = NSTextAlignmentLeft;
    paragraphStyle1.lineSpacing = 6;  //行自定义行高度
    [attributedString addAttribute:NSParagraphStyleAttributeName value:paragraphStyle1 range:NSMakeRange(0, [describeStr length])];
    self.describeLabel.attributedText = attributedString;
    
    self.pictureView.backgroundColor = [UIColor whiteColor];
    
    CGFloat imageMaginX = 20;
    CGFloat imageMaginY = 10;
    CGFloat imageW = (kScreenWidth - imageMaginX * 3) / 2;
    CGFloat imageH = 110;
    
    int count = (int)questionDetail.attachments.count;
    int k ;
    if (count % 2 == 0) {
        k = count / 2;
    } else {
        k = (count + 1) / 2;
    }

    self.picConstraint.constant = imageMaginY + (imageMaginY + imageH) * k;
    [self.pictureView setNeedsUpdateConstraints];
    
    for (int i = 0; i < count; i++) {
        UIImageView *imageView = [[UIImageView alloc] init];
        imageView.translatesAutoresizingMaskIntoConstraints = NO;
        NSDictionary *imageDict = questionDetail.attachments[i];
        NSURL *imageURL = [NSURL URLWithString:[NSString stringWithFormat:@"%@%@", kRedStarURL, imageDict[@"fileUrl"]]];
        [imageView sd_setImageWithURL:imageURL placeholderImage:[UIImage imageNamed:@"default_pic"]];
        [self.pictureView addSubview:imageView];
        
        int j = 0;
        if ((i + 1) % 2 == 0) {
            j = count / 2;
        } else {
            j = (count + 1) / 2;
        }
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.pictureView attribute:NSLayoutAttributeTop multiplier:1.0 constant:imageMaginY + (j - 1) * (imageH + imageMaginY)];
        [self.pictureView addConstraint:titleTop];
        
        if ((i + 1) % 2 == 0) {
            // 左边
            NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.pictureView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:imageMaginX + imageW + imageMaginX];
            [self.pictureView addConstraint:titleLeft];
        } else {
            // 左边
            NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.pictureView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:imageMaginX];
            [self.pictureView addConstraint:titleLeft];
        }
       
        
        // 右边
        NSLayoutConstraint *titleWidth = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:imageW];
        [self.pictureView addConstraint:titleWidth];
        
        // 高度
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:imageH];
        [self.pictureView addConstraint:titleHeight];
    }
    
    // 反馈
    
    if (questionDetail.feedback == nil || questionDetail.feedback == NULL || [questionDetail.feedback isEqual:[NSNull null]]) {
        self.answerLabel.text = @"";
    } else {
        NSString *answerStr = [NSString stringWithFormat:@"%@", questionDetail.feedback];
        NSMutableAttributedString *answerAttrStr = [[NSMutableAttributedString alloc] initWithString:answerStr];
        NSMutableParagraphStyle *paragraphStyle2 = [[NSMutableParagraphStyle alloc] init];
        paragraphStyle2.alignment = NSTextAlignmentLeft;
        paragraphStyle2.lineSpacing = 6;  //行自定义行高度
        [answerAttrStr addAttribute:NSParagraphStyleAttributeName value:paragraphStyle2 range:NSMakeRange(0, answerStr.length)];
        self.answerLabel.attributedText = answerAttrStr;
    }
    
    // 解决人
    if (questionDetail.resolveUser_name == nil || questionDetail.resolveUser_name == NULL || [questionDetail.resolveUser_name isEqual:[NSNull null]]) {
        self.peopleLabel.text = [NSString stringWithFormat:@"问题解决负责人："];
    } else {
        self.peopleLabel.text = [NSString stringWithFormat:@"问题解决负责人：%@", questionDetail.resolveUser_name];
    }
    
    
    if (questionDetail.resolveTime == nil || questionDetail.resolveTime == NULL || [questionDetail.resolveTime isEqual:[NSNull null]]) {
        self.dateLabel.text = [NSString stringWithFormat:@"反馈时间："];
    } else {
        self.dateLabel.text = [NSString stringWithFormat:@"反馈时间：%@", questionDetail.resolveTime];
    }
}

#pragma mark - lazy loading
- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.font = [UIFont systemFontOfSize:15.0];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_titleLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:titleRight];
        
        // 高度
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:titleHeight];
    }
    return _titleLabel;
}

- (UILabel *)describeLabel
{
    if (!_describeLabel) {
        _describeLabel = [[UILabel alloc] init];
        _describeLabel.textColor = kdetailCellTitleColor;
        _describeLabel.font = [UIFont systemFontOfSize:15.0];
        _describeLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _describeLabel.numberOfLines = 0;
        [_describeLabel sizeToFit];
        [self.contentView addSubview:_describeLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_describeLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_describeLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_describeLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:titleRight];
        
    }
    return _describeLabel;
}

- (UILabel *)pictureLabel
{
    if (!_pictureLabel) {
        _pictureLabel = [[UILabel alloc] init];
        _pictureLabel.font = [UIFont systemFontOfSize:15.0];
        _pictureLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_pictureLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.describeLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:titleRight];
        
        // 高度
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_pictureLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentView addConstraint:titleHeight];
        
    }
    return _pictureLabel;

}

- (UIView *)pictureView
{
    if (!_pictureView) {
        _pictureView = [[UIView alloc] init];
        _pictureView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_pictureView];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_pictureView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.pictureLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_pictureView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_pictureView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleRight];
        
        // 高度
        self.picConstraint = [NSLayoutConstraint constraintWithItem:_pictureView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:130];
        [self.contentView addConstraint:_picConstraint];
        
    }
    return _pictureView;
}

- (UILabel *)feedbackLabel
{
    if (!_feedbackLabel) {
        _feedbackLabel = [[UILabel alloc] init];
        _feedbackLabel.font = [UIFont systemFontOfSize:15.0];
        _feedbackLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _feedbackLabel.text = @"问题反馈";

        [self.contentView addSubview:_feedbackLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_feedbackLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.pictureView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_feedbackLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_feedbackLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:titleRight];
        
        // 高度
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_feedbackLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:30];
        [self.contentView addConstraint:titleHeight];
        
    }
    return _feedbackLabel;
}

- (UIView *)feedbackBackView
{
    if (!_feedbackBackView) {
        _feedbackBackView = [[UIView alloc] init];
        _feedbackBackView.translatesAutoresizingMaskIntoConstraints = NO;
        _feedbackBackView.layer.cornerRadius = 5;
        _feedbackBackView.layer.borderWidth = 1;
        _feedbackBackView.layer.borderColor = kQuestionFeedBackTitleCGColor;
        [self.contentView addSubview:_feedbackBackView];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_feedbackBackView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.feedbackLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_feedbackBackView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_feedbackBackView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:titleRight];
        
        // 高度
        NSLayoutConstraint *titleBootom = [NSLayoutConstraint constraintWithItem:_feedbackBackView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-15];
        [self.contentView addConstraint:titleBootom];
        
       
        
    }
    return _feedbackBackView;
}

- (UILabel *)answerLabel
{
    if (!_answerLabel) {
        _answerLabel = [[UILabel alloc] init];
        [_answerLabel sizeToFit];
        _answerLabel.font = [UIFont systemFontOfSize:15.0];
        _answerLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _answerLabel.textColor = kQuestionFeedBackTitleColor;
        _answerLabel.numberOfLines = 0;
        [self.feedbackBackView addSubview:_answerLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_answerLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.feedbackBackView attribute:NSLayoutAttributeTop multiplier:1.0 constant:12];
        [self.feedbackBackView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_answerLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.feedbackBackView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:10];
        [self.feedbackBackView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_answerLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.feedbackBackView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-10];
        [self.feedbackBackView addConstraint:titleRight];
        
    }
    return _answerLabel;
}

- (UILabel *)peopleLabel
{
    if (!_peopleLabel) {
        _peopleLabel = [[UILabel alloc] init];
        _peopleLabel.font = [UIFont systemFontOfSize:15.0];
        _peopleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _peopleLabel.textColor = kDetailCellDescribeTextColor;
        _peopleLabel.numberOfLines = 0;
        [self.feedbackBackView addSubview:_peopleLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.answerLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
        [self.feedbackBackView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.feedbackBackView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:10];
        [self.feedbackBackView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.feedbackBackView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-10];
        [self.feedbackBackView addConstraint:titleRight];
        
        // 右边
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.feedbackBackView addConstraint:titleHeight];
        
    }
    return _peopleLabel;
}

- (UILabel *)dateLabel
{
    if (!_dateLabel) {
        _dateLabel = [[UILabel alloc] init];
        _dateLabel.font = [UIFont systemFontOfSize:15.0];
        _dateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _dateLabel.textColor = kDetailCellDescribeTextColor;
        _dateLabel.numberOfLines = 0;
        [self.feedbackBackView addSubview:_dateLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.peopleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.feedbackBackView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.feedbackBackView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:10];
        [self.feedbackBackView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.feedbackBackView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-10];
        [self.feedbackBackView addConstraint:titleRight];
        
        // 右边
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.feedbackBackView addConstraint:titleHeight];
        
        NSLayoutConstraint *titleBottom = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.feedbackBackView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-10];
        [self.feedbackBackView addConstraint:titleBottom];
        
    }
    return _dateLabel;
}

@end
