//
//  QuestionCommentCell.m
//  redstar
//
//  Created by admin on 15/11/3.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "QuestionCommentCell.h"

@implementation QuestionCommentCell
#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

#pragma mark - Private Methods
- (void)setup
{
    
}

- (void)setCommentModel:(CommentModel *)commentModel
{
    _commentModel = commentModel;
    self.suggestLabel.text = [NSString stringWithFormat:@"%@", commentModel.comment];
    self.peopleLabel.text = [NSString stringWithFormat:@"%@", commentModel.commentor_name];
    self.dateLabel.text = [NSString stringWithFormat:@"%@", commentModel.commentTime];
}



#pragma mark - lazy loading
- (UILabel *)suggestLabel
{
    if (!_suggestLabel) {
        _suggestLabel = [[UILabel alloc] init];
        _suggestLabel.font = [UIFont systemFontOfSize:15.0];
        _suggestLabel.textColor = kLightBlack;
        _suggestLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _suggestLabel.numberOfLines = 0;
        [self.contentView addSubview:_suggestLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_suggestLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:12];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_suggestLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_suggestLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:titleRight];
        
    }
    return _suggestLabel;
}

- (UILabel *)peopleLabel
{
    if (!_peopleLabel) {
        _peopleLabel = [[UILabel alloc] init];
        _peopleLabel.font = [UIFont systemFontOfSize:15.0];
        _peopleLabel.textColor = kLightGray;
        _peopleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_peopleLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.suggestLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:7];
        [self.contentView addConstraint:titleTop];
        
        // 左边
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        // 右边
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.dateLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-10];
        [self.contentView addConstraint:titleRight];
        
        
        
        // 高度
        NSLayoutConstraint *titleBottom = [NSLayoutConstraint constraintWithItem:_peopleLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-10];
        [self.contentView addConstraint:titleBottom];
    }
    return _peopleLabel;
}

- (UILabel *)dateLabel
{
    if (!_dateLabel) {
        _dateLabel = [[UILabel alloc] init];
        _dateLabel.font = [UIFont systemFontOfSize:15.0];
        _dateLabel.textColor = kLightGray;
        _dateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_dateLabel];
        
        // 顶端
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.suggestLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:7];
        [self.contentView addConstraint:titleTop];
        
        // 右边
        NSLayoutConstraint *titleWidth = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:150];
        [self.contentView addConstraint:titleWidth];
        
        
        // 高度
        NSLayoutConstraint *titleBottom = [NSLayoutConstraint constraintWithItem:_dateLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-10];
        [self.contentView addConstraint:titleBottom];
    }
    return _dateLabel;
}


@end
