//
//  OnLineCompleteViewController.m
//  redstar
//
//  Created by admin on 15/11/29.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "OnLineCompleteViewController.h"
#import "OnLineCompleteHeadView.h"
#import "OnLineCompleteCell.h"

#define kOnLineCompleteCell @"onLineCompleteCell"

@interface OnLineCompleteViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) OnLineCompleteHeadView *headerView;
@end

@implementation OnLineCompleteViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    [self setupNav];
    
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
}

#pragma mark - Private Mothods
- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"任务完成情况一览"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
}

- (void)doBack:(id)sender
{
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - UITableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 10;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    OnLineCompleteCell *cell = [tableView dequeueReusableCellWithIdentifier:kOnLineCompleteCell];
    if (!cell) {
        cell = [[OnLineCompleteCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kOnLineCompleteCell];
    }
    cell.iconImageView.image = [UIImage imageNamed:@"default_pic"];
    cell.shopName.text = @"上海真北店";
    cell.reportTime.text = @"上报时间：2015-10-02 12:10:16";
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 45;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    UIView *sectionView = [[UIView alloc] init];
    sectionView.backgroundColor = kSectionBackGroundColor;
    UILabel *shopList = [[UILabel alloc] init];
    shopList.translatesAutoresizingMaskIntoConstraints = NO;
    shopList.text = [NSString stringWithFormat:@"商场列表（5/10）"];
    shopList.textColor = kNavigationBarColor;
    shopList.font = [UIFont systemFontOfSize:16.0];
    sectionView.layer.borderWidth = 0.5;
    sectionView.layer.borderColor = kSeparateLineCGColor;
    [sectionView addSubview:shopList];
    
    NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:shopList attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:titleLabelTop];
    
    NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:shopList attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [sectionView addConstraint:titleLabelLeft];
    
    NSLayoutConstraint *titleLabelRight = [NSLayoutConstraint constraintWithItem:shopList attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
    [sectionView addConstraint:titleLabelRight];
    
    NSLayoutConstraint *titleLabelBottom = [NSLayoutConstraint constraintWithItem:shopList attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:titleLabelBottom];
    return sectionView;
}



#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.tableHeaderView = self.headerView;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 200.0;
        [_tableView registerClass:[OnLineCompleteCell class] forCellReuseIdentifier:kOnLineCompleteCell];
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (OnLineCompleteHeadView *)headerView
{
    if (!_headerView) {
        _headerView = [[OnLineCompleteHeadView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 123)];
        _tableView.backgroundColor = [UIColor whiteColor];
    }
    return _headerView;
}

@end
