//
//  OnLineCompleteHeadView.m
//  redstar
//
//  Created by admin on 15/11/29.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "OnLineCompleteHeadView.h"

@interface OnLineCompleteHeadView ()
@property (nonatomic, strong) UILabel *startDate; // 商店名称
@property (nonatomic, strong) UILabel *overDate; // 截止时间
@property (nonatomic, strong) UILabel *taskContent;

@end


@implementation OnLineCompleteHeadView
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup
{
    self.titleLabel.text = @"2015年十一促销临时抽查";

    self.startDate.text = @"发起时间";
    self.overDate.text = @"截止时间";
    self.taskContent.text = @"任务内容";
    
    self.startDateLabel.text = @"2015-09-30 12:20:12";
    self.overDateLabel.text = @"2015-10-03";
    
    self.unfoldBtn.titleLabel.font = [UIFont systemFontOfSize:13.0];
    self.arrowImageView.image = [UIImage imageNamed:@"grey-trilateral_down"];
    //self.taskContentLabel.text = @"王XX 集团X领导";
}
- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _titleLabel.textColor = kAnnounceTextColor;
        _titleLabel.font = [UIFont systemFontOfSize:18.0];
        [self addSubview:_titleLabel];
        
        NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self addConstraint:titleLabelTop];
        
        NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:titleLabelLeft];
        
        NSLayoutConstraint *titleLabelWidth = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self addConstraint:titleLabelWidth];
        
        NSLayoutConstraint *titleLabelHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:27];
        [self addConstraint:titleLabelHeight];
    }
    return _titleLabel;
}

- (UILabel *)startDate
{
    if (!_startDate) {
        _startDate = [[UILabel alloc] init];
        _startDate.font = [UIFont systemFontOfSize:15.0];
        _startDate.textColor = kOnLineCompleteHeaderTextColor;
        _startDate.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_startDate];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self addConstraint:Left];
        
        NSLayoutConstraint *Width = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self addConstraint:Width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_startDate attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self  addConstraint:Height];
    }
    return _startDate;
}


- (UILabel *)overDate
{
    if (!_overDate) {
        _overDate = [[UILabel alloc] init];
        _overDate.font = [UIFont systemFontOfSize:15.0];
        _overDate.textColor = kOnLineCompleteHeaderTextColor;
        _overDate.translatesAutoresizingMaskIntoConstraints = NO;
        [self  addSubview:_overDate];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.startDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self  addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self  attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self  addConstraint:Left];
        
        NSLayoutConstraint *Width = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self  addConstraint:Width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_overDate attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self  addConstraint:Height];
    }
    return _overDate;
}

- (UILabel *)taskContent
{
    if (!_taskContent) {
        _taskContent = [[UILabel alloc] init];
        _taskContent.font = [UIFont systemFontOfSize:15.0];
        _taskContent.textColor = kOnLineCompleteHeaderTextColor;
        _taskContent.translatesAutoresizingMaskIntoConstraints = NO;
        [self  addSubview:_taskContent];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_taskContent attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self  addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_taskContent attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self  attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self  addConstraint:Left];
        
        NSLayoutConstraint *Width = [NSLayoutConstraint constraintWithItem:_taskContent attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:65];
        [self  addConstraint:Width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_taskContent attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self  addConstraint:Height];
    }
    return _taskContent;
}

- (UILabel *)startDateLabel
{
    if (!_startDateLabel) {
        _startDateLabel = [[UILabel alloc] init];
        _startDateLabel.font = [UIFont systemFontOfSize:15.0];
        _startDateLabel.textColor = kLightBlack;
        _startDateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_startDateLabel];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_startDateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_startDateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.startDate attribute:NSLayoutAttributeRight multiplier:1.0 constant:15];
        [self addConstraint:Left];
        
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_startDateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self addConstraint:Height];
    }
    return _startDateLabel;
}

- (UILabel *)overDateLabel
{
    if (!_overDateLabel) {
        _overDateLabel = [[UILabel alloc] init];
        _overDateLabel.font = [UIFont systemFontOfSize:15.0];
        _overDateLabel.textColor = kLightBlack;
        _overDateLabel.textAlignment = NSTextAlignmentLeft;
        _overDateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_overDateLabel];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_overDateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.startDateLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:Top];
        
        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_overDateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:100];
        [self addConstraint:Left];
        
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_overDateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self addConstraint:Height];
    }
    return _overDateLabel;
}


- (UIButton *)unfoldBtn
{
    if (!_unfoldBtn) {
        _unfoldBtn = [[UIButton alloc] init];
        [_unfoldBtn setTitle:@"展开" forState:UIControlStateNormal];
        [_unfoldBtn setTitleColor:kLightGray forState:UIControlStateNormal];
        _unfoldBtn.tag = 2001;
        _unfoldBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [self  addSubview:_unfoldBtn];
        
        NSLayoutConstraint *overDateTop = [NSLayoutConstraint constraintWithItem:_unfoldBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:2];
        [self  addConstraint:overDateTop];
        
        NSLayoutConstraint *overDateWidth = [NSLayoutConstraint constraintWithItem:_unfoldBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:32];
        [self  addConstraint:overDateWidth];
        
        NSLayoutConstraint *overDateRight = [NSLayoutConstraint constraintWithItem:_unfoldBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.arrowImageView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self  addConstraint:overDateRight];
        
        NSLayoutConstraint *overDateHeight = [NSLayoutConstraint constraintWithItem:_unfoldBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self  addConstraint:overDateHeight];
    }
    return _unfoldBtn;
}

- (UIImageView *)arrowImageView
{
    if (!_arrowImageView) {
        _arrowImageView = [[UIImageView alloc] init];
        _arrowImageView.translatesAutoresizingMaskIntoConstraints = NO;
        [self  addSubview:_arrowImageView];
        
        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDate attribute:NSLayoutAttributeBottom multiplier:1.0 constant:10];
        [self  addConstraint:Top];
        
        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self  attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self  addConstraint:Right];
        
        NSLayoutConstraint *width = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:11];
        [self  addConstraint:width];
        
        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:8];
        [self  addConstraint:Height];
    }
    return _arrowImageView;
}


//- (UILabel *)taskContentLabel
//{
//    if (!_taskContentLabel) {
//        _taskContentLabel = [[UILabel alloc] init];
//        _taskContentLabel.font = [UIFont systemFontOfSize:15.0];
//        _taskContentLabel.textColor = kLightBlack;
//        _taskContentLabel.textAlignment = NSTextAlignmentLeft;
//        _taskContentLabel.translatesAutoresizingMaskIntoConstraints = NO;
//        [self addSubview:_taskContentLabel];
//        
//        NSLayoutConstraint *Top = [NSLayoutConstraint constraintWithItem:_taskContentLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.overDateLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:5];
//        [self addConstraint:Top];
//        
//        NSLayoutConstraint *Left = [NSLayoutConstraint constraintWithItem:_taskContentLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:100];
//        [self addConstraint:Left];
//        
//        NSLayoutConstraint *Right = [NSLayoutConstraint constraintWithItem:_taskContentLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
//        [self addConstraint:Right];
//        
//        NSLayoutConstraint *Height = [NSLayoutConstraint constraintWithItem:_taskContentLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
//        [self addConstraint:Height];
//    }
//    return _taskContentLabel;
//}


@end
