//
//  RootTabBarController.m
//  redstar
//
//  Created by admin on 15/11/3.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RootTabBarController.h"

#import "HomeViewController.h"
#import "AnnounceViewController.h"
#import "FunctionViewController.h"
#import "MineViewController.h"

#import <AFNetworking.h>
#import "CommonFunc.h"

@interface RootTabBarController ()
@end

@implementation RootTabBarController

- (void)viewDidLoad
{
    [self setupTabbar];
        
    self.delegate = self;
    
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.parentViewController.tabBarController.tabBar.hidden = YES;

}

- (void)viewDidDisappear:(BOOL)animated
{
    self.parentViewController.tabBarController.tabBar.hidden = YES;

}


//
- (void)setupTabbar
{
    // 跳转到tabbarController
    
    HomeViewController *home = (HomeViewController *)[self setUpOneChildViewController:[[HomeViewController alloc] init] title:@"首页" imageName:@"home_unchecked" selImageName:@"home_checked"];
    UINavigationController *homeNav = [[UINavigationController alloc] initWithRootViewController:home];
    [homeNav.navigationBar setBarTintColor:kNavigationBarColor];
    [homeNav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
    
    
    FunctionViewController *function = (FunctionViewController *)[self setUpOneChildViewController:[[FunctionViewController alloc] init] title:@"功能" imageName:@"function_uncheck" selImageName:@"function_check"];
    UINavigationController *functionNav = [[UINavigationController alloc] initWithRootViewController:function];
    [functionNav.navigationBar setBarTintColor:kNavigationBarColor];
    [functionNav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
    
    AnnounceViewController *announce = (AnnounceViewController *)[self setUpOneChildViewController:[[AnnounceViewController alloc] init] title:@"公告" imageName:@"notice_unchecked" selImageName:@"notice_checked"];
    announce.tabBarItem.tag = 3928;
    
    MineViewController *mine = (MineViewController *)[self setUpOneChildViewController:[[MineViewController alloc] init] title:@"我的" imageName:@"aboutme_unchecked" selImageName:@"aboutme_checke"];
    mine.tabBarItem.tag = 18274;
    
    
    [[UITabBarItem appearance] setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:
                                                       kNavigationBarColor, NSForegroundColorAttributeName,
                                                       nil] forState:UIControlStateSelected];

    self.viewControllers = @[homeNav, functionNav, announce, mine];
}



// 添加一个控制器的属性
- (UIViewController *)setUpOneChildViewController:(UIViewController *)vc title:(NSString *)title imageName:(NSString *)imageName selImageName:(NSString *)selImageName
{
    // 添加TabBar按钮的图片文字
    vc.title = title;
    vc.tabBarItem.image = [UIImage imageNamed:imageName];
    UIImage *selImage = [UIImage imageNamed:selImageName];
    selImage = [selImage imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
    vc.tabBarItem.selectedImage = selImage;
    
    return vc;
    
    
}

#pragma mark - UITabBarController Delegate

- (BOOL)tabBarController:(UITabBarController *)tabBarController shouldSelectViewController:(UIViewController *)viewController {
    if (viewController.tabBarItem.tag == 18274) {
        MineViewController *vc = (MineViewController *)[self setUpOneChildViewController:[[MineViewController alloc] init] title:@"我的" imageName:@"aboutme_unchecked" selImageName:@"aboutme_checke"];
        vc.hidesBottomBarWhenPushed = YES;
        [((UINavigationController *)tabBarController.selectedViewController) pushViewController:vc animated:YES];
        
        return NO;
    } else if (viewController.tabBarItem.tag == 3928) {
        AnnounceViewController *announce = (AnnounceViewController *)[self setUpOneChildViewController:[[AnnounceViewController alloc] init] title:@"公告" imageName:@"notice_unchecked" selImageName:@"notice_checked"];
        announce.hidesBottomBarWhenPushed = YES;
        [((UINavigationController *)tabBarController.selectedViewController) pushViewController:announce animated:YES];
        return NO;
    }
    
    
    return YES;
}


@end
