//
//  SearchViewController.m
//  redstar
//
//  Created by admin on 15/12/2.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "SearchViewController.h"
#import "InspectListViewController.h"
#import "RankingListViewController.h"
#import "OnLineViewController.h"
#import "PictureViewController.h"
#import "QuestionViewController.h"

#import "HomeCellItem.h"

#import "PictureTableCell.h"
#define kHomePictureListCell @"homePictureListCell"
#import "PictureStoryViewController.h"

#import "HomeTitleTableCell.h"
#define kHomeTitleTableCell @"homeTitleTableCell"
#import "RankingListCell.h"
#define kHomeRankingListCell @"homeRankingListsCell"
#import "RankDetailViewController.h"
#import "RankListModel.h"
#import "RankCommentCell.h"

#import "QuestionListTableCell.h"
#define kHomeQuestionListTableCell @"homeQuestionListTableCell"
#import "QuestionModel.h"
#import "QuestionDetailViewController.h"
#define kQuestionTag 387428

#import "InspectListCell.h"
#define kHomeInspectListCell @"homeInspectListsCell"
#import "InspectTaskViewController.h"
#import "TaskListModel.h"

#import "SpotCheckOnLineViewController.h"

#import "LookOnLineViewController.h"

#import "StandardViewController.h"

#import "HttpClient.h"
#import <MBProgressHUD.h>

#import <MJRefresh.h>
#import "SearchViewController.h"

@interface SearchViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;

@property (nonatomic, strong) NSMutableArray *titleArray; // 问题与知识
@property (nonatomic, strong) NSMutableArray *allQuestionArray; // 问题与知识
@property (nonatomic, strong) NSMutableArray *taskListDataArray; // 问题与知识
@property (nonatomic, strong) NSMutableArray *allRankListArray;
@end

@implementation SearchViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    //NSMutableArray *titleArray = [[NSUserDefaults standardUserDefaults] objectForKey:@"function"];
    NSArray *titleArray = [NSArray arrayWithObjects:@"口碑巡检",@"口碑排名",@"问题知识", nil];
    self.titleArray = [NSMutableArray arrayWithArray:titleArray];
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:self.customStr];
    customLab.textAlignment = NSTextAlignmentCenter;
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }

    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    if ([self.titleArray containsObject:@"口碑巡检"]) {
        self.taskListDataArray = [NSMutableArray array];
        if (_taskListDataArray.count == 0) {
            [_titleArray removeObject:@"口碑巡检"];
        }
        [self requestAllTaskList];

    }
    
    if ([self.titleArray containsObject:@"口碑排名"]) {
        self.allRankListArray = [NSMutableArray array];
        if (_allRankListArray.count == 0) {
            [_titleArray removeObject:@"口碑排名"];
        }
        [self requestAllRankList];
    }
    
    if ([self.titleArray containsObject:@"问题知识"]) {
        self.allQuestionArray = [NSMutableArray array];
        if (_allRankListArray.count == 0) {
            [_titleArray removeObject:@"问题知识"];
        }
        [self requestAllQuestion];
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBar.hidden = NO;
    self.tabBarController.tabBar.hidden = YES;
    
}

#pragma mark - Prative Methods
// 更多按钮点击事件
- (void)moreButtonClick:(UIButton *)sender
{
    
    if (_titleArray.count == 5) {
        UIButton *button = (UIButton *)sender;
        UINavigationController *nav;
        
        if (button.tag - 332892 == 0) {
            InspectListViewController *inspectListVC = [[InspectListViewController alloc] init];
            nav = [[UINavigationController alloc] initWithRootViewController:inspectListVC];
        } else  {
            QuestionViewController *questionVC = [[QuestionViewController alloc] init];
            nav = [[UINavigationController alloc] initWithRootViewController:questionVC];
        }
        [nav.navigationBar setBarTintColor:kNavigationBarColor];
        [nav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
        [self presentViewController:nav animated:YES completion:nil];
    } else {
        
        UIButton *button = (UIButton *)sender;
        UINavigationController *nav;
        
        if (button.tag - 332892 == 0) {
            InspectListViewController *inspectListVC = [[InspectListViewController alloc] init];
            nav = [[UINavigationController alloc] initWithRootViewController:inspectListVC];
        } else if (button.tag - 332892 == 1) {
            RankingListViewController *rankingListVC = [[RankingListViewController alloc] init];
            nav = [[UINavigationController alloc] initWithRootViewController:rankingListVC];
            
        } else {
            QuestionViewController *questionVC = [[QuestionViewController alloc] init];
            nav = [[UINavigationController alloc] initWithRootViewController:questionVC];
            
            
        }
        
        [nav.navigationBar setBarTintColor:kNavigationBarColor];
        [nav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
        [self presentViewController:nav animated:YES completion:nil];
    }
}

- (void)requestAllTaskList
{
    
    NSString *url3 = [NSString stringWithFormat:@"%@%@", kRedStarURL, kInspectListURL];
    HttpClient *httpCilent3 = [[HttpClient alloc] initWithUrl:url3];
    NSDictionary *parameters3 = @{
                                  @"keyword":self.customStr,
                                  @"userUuid":[[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"],
                                  @"queryOrders":@[@{@"field":@"lastModifyInfo"}],
                                  @"pageNumber":@(0),
                                  @"pageSize":@(10)
                                  };
    [httpCilent3 getInspectListWithParameters:parameters3 completion:^(id response, NSError *error) {
        NSLog(@"巡检列表%@", response);
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        NSMutableArray *inspectTempArr = [NSMutableArray array];
        for (NSDictionary *dict in dataArray) {
            TaskListModel *taskList = [[TaskListModel alloc] init];
            [taskList setValuesForKeysWithDictionary:dict];
            [inspectTempArr addObject:taskList];
        }
        _taskListDataArray = inspectTempArr;
        
        if (_taskListDataArray.count != 0) {
            if (![_titleArray containsObject:@"口碑巡检"]) {
                [_titleArray addObject:@"口碑巡检"];
            }
        }
        
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];
        
    }];

}

- (void)requestAllRankList
{
    NSString *url1 = [NSString stringWithFormat:@"%@%@", kRedStarURL, kRankingListURL];
    HttpClient *httpCilent1 = [[HttpClient alloc] initWithUrl:url1];
    NSDictionary *parameters1 = @{
                                  @"praiseUuid":@"5a7417015157efa6015158f52be8004e",
                                  @"statisMode":@(0),
                                  @"keyword":self.customStr
                                 };
    [httpCilent1 getRankingListWithParameters:parameters1 completion:^(id response, NSError *error) {
        NSLog(@"口碑排名response = %@", response);
        if ([(NSArray *)response[@"data"] count] == 0) {
            return;
        }
        NSArray *dataArray = response[@"data"];
        
        NSMutableArray *rankTempArr = [NSMutableArray array];
        for (NSDictionary *ListDict in dataArray) {
            RankListModel *rankList = [RankListModel rankListModelWithDict:ListDict];
            [rankTempArr addObject:rankList];
        }
        _allRankListArray = (NSMutableArray *)[self sortRankListWithRankListArray:rankTempArr];
        
        for (int i = 0 ; i < _allRankListArray.count; i++) {
            RankListModel *rank = _allRankListArray[i];
            if (i == 0) {
                rank.index = i + 1;
            } else {
                RankListModel *prevRank = _allRankListArray[i-1];
                rank.index = rank.score == prevRank.score ? prevRank.index: i + 1;
            }
        }
        
        if (_allRankListArray.count != 0) {
            if (![_titleArray containsObject:@"口碑排名"]) {
                [_titleArray addObject:@"口碑排名"];
            }
        }
        
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];
    }];
    
}

- (NSArray *)sortRankListWithRankListArray:(NSMutableArray *)allRanking
{
    NSArray *sortedArray = [allRanking sortedArrayUsingComparator:^NSComparisonResult(RankListModel *p1, RankListModel *p2){
       // return [p2.score compare:p1.score];
        return [@(p2.score) compare:@(p1.score)];

    }];
    return sortedArray;
}

- (void)requestAllQuestion
{
    NSString *url2 = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    NSDictionary *parameters2 = @{
                                  @"keyword":self.customStr,
                                  @"user":user_uuid,
                                  @"scope":@"all",
                                  @"pageNumber":@(0),
                                  @"pageSize":@(10)
                                  };
    __block SearchViewController *weakSelf = self;
    HttpClient *httpClient2 = [[HttpClient alloc] initWithUrl:url2];
    [httpClient2 getQuestionListWithParameters:parameters2 completion:^(id response, NSError *error) {
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSLog(@"问题与知识列表recods = %@", response);
        
        NSMutableArray *questionTempArr = [NSMutableArray array];
        
        for (NSDictionary *questionDict in recordsDict) {
            QuestionModel *question = [[QuestionModel alloc] init];
            [question setValuesForKeysWithDictionary:questionDict];
            [questionTempArr addObject:question];
        }
        
        weakSelf.allQuestionArray = questionTempArr;
        
        if (_allQuestionArray.count != 0) {
            if (![_titleArray containsObject:@"问题知识"]) {
                [_titleArray addObject:@"问题知识"];
            }
        }
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];
    }];

}


// 返回上一页面
- (void)doBack:(UIBarButtonItem *)sender
{
    [self.navigationController popViewControllerAnimated:YES];
}


#pragma mark - TableView Delegate/DataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return _titleArray.count;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSUInteger s1 = [_titleArray indexOfObject:@"口碑巡检"];
    NSUInteger s2 = [_titleArray indexOfObject:@"口碑排名"];
    NSUInteger s3 = [_titleArray indexOfObject:@"问题知识"];
    if ([_titleArray[section] isEqualToString:@"口碑巡检"] && section == s1) {
        return _taskListDataArray.count;
    } else if ([_titleArray[section] isEqualToString:@"口碑排名"] && section == s2) {
        return _allRankListArray.count + 1;
    } else if ([_titleArray[section] isEqualToString:@"问题知识"] && section == s3) {
        return _allQuestionArray.count;
    } else {
        return 0;
    }
    
}


// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    NSUInteger s1 = [_titleArray indexOfObject:@"口碑巡检"];
    NSUInteger s2 = [_titleArray indexOfObject:@"口碑排名"];
    NSUInteger s3 = [_titleArray indexOfObject:@"问题知识"];
    if ([_titleArray[indexPath.section] isEqualToString:@"口碑巡检"] && indexPath.section == s1) {
        InspectListCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomeInspectListCell];
        if (!cell) {
            cell = [[InspectListCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeInspectListCell];
        }
        TaskListModel *taskList = _taskListDataArray[indexPath.row];
        cell.taskList = taskList;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.allView.backgroundColor = kProgressViewAllBackColor;
        UIImage *image = [UIImage imageNamed:@"progress-bar"];
        image = [image resizableImageWithCapInsets:UIEdgeInsetsZero resizingMode:UIImageResizingModeTile];
        cell.alreadyView.image = image;
        return cell;
    } else if ([_titleArray[indexPath.section] isEqualToString:@"口碑排名"] && indexPath.section == s2) {
        if (indexPath.row == 0) {
            HomeTitleTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomeTitleTableCell];
            if (!cell) {
                cell = [[HomeTitleTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeTitleTableCell];
            }
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            return cell;
        } else {
            RankingListCell *cell = [tableView dequeueReusableCellWithIdentifier:kHomeRankingListCell];
            if (!cell) {
                cell = [[RankingListCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeRankingListCell];
            }
            RankListModel *rankList = _allRankListArray[indexPath.row - 1];
            cell.rankList = rankList;
            cell.gradeImageView.image = [UIImage imageNamed:[NSString stringWithFormat:@"medal_0%d", rankList.index]];
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            return cell;
        }
    } else if ([_titleArray[indexPath.section] isEqualToString:@"问题知识"] && indexPath.section == s3) {
        // 问题与知识
        QuestionListTableCell *cell = [tableView dequeueReusableCellWithIdentifier:kHomeQuestionListTableCell];
        if (!cell) {
            cell = [[QuestionListTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeQuestionListTableCell];
        }
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        QuestionModel *question = _allQuestionArray[indexPath.row];
        cell.question = question;
        return cell;
    } else {
        return nil;
    }
}

// cell点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (_titleArray.count == 5) {
        if (indexPath.section == 0) {
            InspectTaskViewController *inspectTaskVC = [[InspectTaskViewController alloc] init];
            TaskListModel *taskList = self.taskListDataArray[indexPath.row];
            inspectTaskVC.uuid = taskList.uuid;
            inspectTaskVC.store_uuid = taskList.store_uuid;
            inspectTaskVC.multiplier = (CGFloat)taskList.reportCount / taskList.questionCount ;
            self.hidesBottomBarWhenPushed = YES;
            [self.navigationController pushViewController:inspectTaskVC animated:YES];
        } else {
            QuestionDetailViewController *questionDetailVC = [[QuestionDetailViewController alloc] init];
            QuestionModel *question = self.allQuestionArray[indexPath.row];
            questionDetailVC.questionUuid = question.uuid;
            self.hidesBottomBarWhenPushed = YES;
            [self.navigationController pushViewController:questionDetailVC animated:YES];
        }
    } else {
        
        if (indexPath.section == 0) {
            InspectTaskViewController *inspectTaskVC = [[InspectTaskViewController alloc] init];
            TaskListModel *taskList = self.taskListDataArray[indexPath.row];
            inspectTaskVC.uuid = taskList.uuid;
            inspectTaskVC.store_uuid = taskList.store_uuid;
            inspectTaskVC.multiplier = (CGFloat)taskList.reportCount / taskList.questionCount ;
            self.hidesBottomBarWhenPushed = YES;
            [self.navigationController pushViewController:inspectTaskVC animated:YES];
            
        } else if (indexPath.section == 1) {
            
            if (indexPath.row == 0) {
                NSLog(@"不能点击");
            } else {
                RankListModel *rankList = _allRankListArray[indexPath.row - 1];
                RankDetailViewController *rankDetailVC = [[RankDetailViewController alloc] init];
                rankDetailVC.indexRow = indexPath.section - 2;
                rankDetailVC.uuid = rankList.uuid;
                rankDetailVC.store_uuid = rankList.store_uuid;
                rankDetailVC.storeAddress = rankList.storeAddress;
                rankDetailVC.storePictures = rankList.storePictures;
                self.hidesBottomBarWhenPushed = YES;
                [self.navigationController pushViewController:rankDetailVC animated:YES];
            }
            
            
        } else {
            QuestionDetailViewController *questionDetailVC = [[QuestionDetailViewController alloc] init];
            QuestionModel *question = self.allQuestionArray[indexPath.row];
            questionDetailVC.questionUuid = question.uuid;
            self.hidesBottomBarWhenPushed = YES;
            [self.navigationController pushViewController:questionDetailVC animated:YES];
            
            
            
        }
    }
}


// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 36;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 10;
}

// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    
    // 创建sectionView
    UIView *sectionView = [[UIView alloc] init];
    sectionView.userInteractionEnabled = YES;
    sectionView.backgroundColor = [UIColor whiteColor];
    
    UIView *lineView = [[UIView alloc] init];
    lineView.translatesAutoresizingMaskIntoConstraints = NO;
    lineView.backgroundColor = kSeparateLineColor;
    [sectionView addSubview:lineView];
    
    NSLayoutConstraint *lineTop = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:lineTop];
    
    NSLayoutConstraint *lineLeft = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:lineLeft];
    
    NSLayoutConstraint *lineRight = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [sectionView addConstraint:lineRight];
    
    NSLayoutConstraint *lineHeight = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:0.5];
    [sectionView addConstraint:lineHeight];
    
    // 创建标题label
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    titleLabel.textColor = kPictureCellDetailsColor;
    titleLabel.font = [UIFont systemFontOfSize:17.0];
    titleLabel.text = _titleArray[section];
    
    
    [sectionView addSubview:titleLabel];
    
    
    // 查看更多按钮
    UIButton *moreButton = [[UIButton alloc] init];
    moreButton.tag = 332892 + section;
    moreButton.translatesAutoresizingMaskIntoConstraints = NO;
    [moreButton setTitle:@"更多" forState:UIControlStateNormal];
    [moreButton setTitleColor:kMoreButtonTextColor forState:UIControlStateNormal];
    [moreButton addTarget:self action:@selector(moreButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    moreButton.titleLabel.font = [UIFont systemFontOfSize:13.0];
    [sectionView addSubview:moreButton];
    
    // 箭头Iamge
    UIImageView *arrowIamgeView = [[UIImageView alloc] init];
    arrowIamgeView.image = [UIImage imageNamed:@"arrow_right"];
    arrowIamgeView.translatesAutoresizingMaskIntoConstraints = NO;
    [sectionView addSubview:arrowIamgeView];
    
    NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:3];
    [sectionView addConstraint:titleLabelTop];
    
    NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [sectionView addConstraint:titleLabelLeft];
    
    NSLayoutConstraint *titleLabelRight = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:moreButton attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:titleLabelRight];
    
    NSLayoutConstraint *titleLabelBottom = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:titleLabelBottom];
    
    
    
    
    
    // moreButton布局
    NSLayoutConstraint *moreButtonTop = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:3];
    [sectionView addConstraint:moreButtonTop];
    
    NSLayoutConstraint *moreButtonRight = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:arrowIamgeView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:moreButtonRight];
    
    NSLayoutConstraint *moreButtonWidth = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:35];
    [sectionView addConstraint:moreButtonWidth];
    
    NSLayoutConstraint *moreButtonBottom = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:moreButtonBottom];
    
    // arrowIamgeView布局
    NSLayoutConstraint *arrowIamgeViewTop = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:13];
    [sectionView addConstraint:arrowIamgeViewTop];
    
    NSLayoutConstraint *arrowIamgeViewRight = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
    [sectionView addConstraint:arrowIamgeViewRight];
    
    NSLayoutConstraint *arrowIamgeViewWidth = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:7];
    [sectionView addConstraint:arrowIamgeViewWidth];
    
    NSLayoutConstraint *arrowIamgeViewHeight = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:12];
    [sectionView addConstraint:arrowIamgeViewHeight];
    
    
    return sectionView;
}


- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 300.0;
        _tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 40)];
        [_tableView registerClass:[PictureTableCell class] forCellReuseIdentifier:kHomePictureListCell];
        [_tableView registerClass:[HomeTitleTableCell class] forCellReuseIdentifier:kHomeTitleTableCell];
        [_tableView registerClass:[RankingListCell class] forCellReuseIdentifier:kHomeRankingListCell];
        [_tableView registerClass:[QuestionListTableCell class] forCellReuseIdentifier:kHomeQuestionListTableCell];
        
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
