//
//  OnLineResultDetailCell.m
//  redstar
//
//  Created by admin on 15/12/9.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "OnLineResultDetailCell.h"

#import <UIButton+WebCache.h>

@implementation OnLineResultDetailCell
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setupScrollView];
    }
    return self;
}

- (void)setupScrollView
{
    int imageCount = 4;
    
    CGFloat marginW = 5.0;
    CGFloat imageViewW = 90 + 2 * marginW;
    CGFloat imageViewH = self.showScrollView.bounds.size.height - 4;
    
   
    self.showScrollView.contentSize = CGSizeMake(imageCount *imageViewW, imageViewH + 4);
    
    for (int i = 0; i < imageCount; i++) {
        UIButton *button = [[UIButton alloc] init];
        // 这是真正的
        //  NSDictionary *dict = (NSDictionary *)self.storePictures[i];
        // 这是假的
        NSDictionary *dict = [NSDictionary dictionary];

        NSURL *imageUrl = [NSURL URLWithString:[NSString stringWithFormat:@"%@%@", kRedStarURL ,dict[@"fileUrl"]]];
        [button sd_setImageWithURL:imageUrl forState:UIControlStateNormal placeholderImage:[UIImage imageNamed:@"default_pic"]];
        button.frame = CGRectMake(i * imageViewW + 2, 2, imageViewW - 2 * marginW, imageViewH);
        //[button addTarget:self action:@selector(showBigPic:) forControlEvents:UIControlEventTouchUpInside];
        [self.showScrollView addSubview:button];
    }
}


- (UILabel *)shopNameLabel
{
    if (!_shopNameLabel) {
        _shopNameLabel = [[UILabel alloc] init];
        _shopNameLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _shopNameLabel.textColor = kDetailSection0TitleColor;
        _shopNameLabel.font = [UIFont systemFontOfSize:18.0];
        
        [self.contentView addSubview:_shopNameLabel];
        // label
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_shopNameLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleTop];
        
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_shopNameLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:titleLeft];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_shopNameLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:titleRight];
        
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_shopNameLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:46];
        [self.contentView addConstraint:titleHeight];
    }
    return _shopNameLabel;
}

- (UIView *)whiteView
{
    if (!_whiteView) {
        _whiteView = [[UIView alloc] init];
        _whiteView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_whiteView];
        // label
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_whiteView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.shopNameLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleTop];
        
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_whiteView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleLeft];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_whiteView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleRight];
        
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_whiteView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:110];
        [self.contentView addConstraint:titleHeight];
        
        NSLayoutConstraint *titleBottom = [NSLayoutConstraint constraintWithItem:_whiteView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:titleBottom];
    }
    return _whiteView;
}

- (UILabel *)addressLabel
{
    if (!_addressLabel) {
        _addressLabel = [[UILabel alloc] init];
        _addressLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _addressLabel.textColor = kLightGray;
        _addressLabel.font = [UIFont systemFontOfSize:14.0];
        [self.whiteView addSubview:_addressLabel];
        // label
        NSLayoutConstraint *titleTop = [NSLayoutConstraint constraintWithItem:_addressLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.whiteView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.whiteView addConstraint:titleTop];
        
        NSLayoutConstraint *titleLeft = [NSLayoutConstraint constraintWithItem:_addressLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.whiteView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.whiteView addConstraint:titleLeft];
        
        NSLayoutConstraint *titleRight = [NSLayoutConstraint constraintWithItem:_addressLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.whiteView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.whiteView addConstraint:titleRight];
        
        NSLayoutConstraint *titleHeight = [NSLayoutConstraint constraintWithItem:_addressLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:35];
        [self.whiteView addConstraint:titleHeight];
    }
    return _addressLabel;
}


- (UIScrollView *)showScrollView
{
    if (!_showScrollView) {
        _showScrollView = [[UIScrollView alloc] initWithFrame:CGRectMake(20, 35, kScreenWidth - 40, 70)];
        _showScrollView.showsHorizontalScrollIndicator = NO;
        _showScrollView.showsVerticalScrollIndicator = NO;
        [self.whiteView addSubview:_showScrollView];
        
    }
    return _showScrollView;
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
