//
//  HomeTitleTableCell.m
//  redstar
//
//  Created by admin on 15/11/16.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "HomeTitleTableCell.h"

@implementation HomeTitleTableCell
#pragma mark - System Methods
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup
{
    // 商场
    UILabel *shoppingLabel = [[UILabel alloc] init];
    shoppingLabel.text = @"商场名称";
    shoppingLabel.textAlignment = NSTextAlignmentCenter;
    shoppingLabel.textColor = kRankHeadTitleTextColor;
    shoppingLabel.font = [UIFont systemFontOfSize:17.0];
    shoppingLabel.translatesAutoresizingMaskIntoConstraints = NO;
    [self.contentView addSubview:shoppingLabel];
    
    // 总分
    UILabel *scoreLabel = [[UILabel alloc] init];
    scoreLabel.text = @"总分";
    scoreLabel.textAlignment = NSTextAlignmentCenter;
    scoreLabel.textColor = kRankHeadTitleTextColor;
    scoreLabel.font = [UIFont systemFontOfSize:17.0];
    scoreLabel.translatesAutoresizingMaskIntoConstraints = NO;
    [self.contentView addSubview:scoreLabel];
    
    // 排名
    UILabel *gradeLabel = [[UILabel alloc] init];
    gradeLabel.text = @"排名";
    gradeLabel.textAlignment = NSTextAlignmentCenter;
    gradeLabel.textColor = kRankHeadTitleTextColor;
    gradeLabel.font = [UIFont systemFontOfSize:17.0];
    gradeLabel.translatesAutoresizingMaskIntoConstraints = NO;
    [self.contentView addSubview:gradeLabel];
    
    //
    NSLayoutConstraint *shoppingTop = [NSLayoutConstraint constraintWithItem:shoppingLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
    [self.contentView addConstraint:shoppingTop];
    
    NSLayoutConstraint *shoppingLeft = [NSLayoutConstraint constraintWithItem:shoppingLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [self.contentView addConstraint:shoppingLeft];
    
    NSLayoutConstraint *shoppingRight = [NSLayoutConstraint constraintWithItem:shoppingLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:scoreLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [self.contentView addConstraint:shoppingRight];
    
    NSLayoutConstraint *shoppingBottom = [NSLayoutConstraint constraintWithItem:shoppingLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self.contentView addConstraint:shoppingBottom];
    
    NSLayoutConstraint *shoppingWidth = [NSLayoutConstraint constraintWithItem:shoppingLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:scoreLabel attribute:NSLayoutAttributeWidth multiplier:1.2 constant:0];
    [self.contentView addConstraint:shoppingWidth];
    
    //
    NSLayoutConstraint *scoreTop = [NSLayoutConstraint constraintWithItem:scoreLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
    [self.contentView addConstraint:scoreTop];
    
    NSLayoutConstraint *scoreRight = [NSLayoutConstraint constraintWithItem:scoreLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:gradeLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [self.contentView addConstraint:scoreRight];
    
    NSLayoutConstraint *scoreWidth = [NSLayoutConstraint constraintWithItem:scoreLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:gradeLabel attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
    [self.contentView addConstraint:scoreWidth];
    
    NSLayoutConstraint *scoreBottom = [NSLayoutConstraint constraintWithItem:scoreLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self.contentView addConstraint:scoreBottom];
    
    //
    NSLayoutConstraint *gradeTop = [NSLayoutConstraint constraintWithItem:gradeLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:5];
    [self.contentView addConstraint:gradeTop];
    
    NSLayoutConstraint *gradeRight = [NSLayoutConstraint constraintWithItem:gradeLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self.contentView addConstraint:gradeRight];
    
    NSLayoutConstraint *gradeBottom = [NSLayoutConstraint constraintWithItem:gradeLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self.contentView addConstraint:gradeBottom];
    
    NSLayoutConstraint *shoppingHheight = [NSLayoutConstraint constraintWithItem:gradeLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.2 constant:30];
    [self.contentView addConstraint:shoppingHheight];
}


- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
