//
//  PictureViewController.m
//  redstar
//
//  Created by admin on 15/11/1.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "PictureViewController.h"
#import "MenuButton.h"
#import "PictureTableCell.h"

#import "PictureStoryViewController.h"
#import "AddPictureViewController.h"

#import "TaxisView.h"
#import "ScreenView.h"
#import "MenuView.h"


#define kPictureTableViewCell @"pictureTabelViewCell"

@interface PictureViewController () <UITableViewDelegate, UITableViewDataSource, ScreenTableDelegate, TaxisViewDelegate, InspectTableViewDelegate>
@property (nonatomic, strong) MenuView *menuView;

@property (nonatomic, strong) TaxisView *taxisView;
@property (nonatomic, strong) ScreenView *screenView;
@property (nonatomic, strong) MenuButton *selctedButton;

@property (nonatomic, strong) UIView *bgView;
@property (nonatomic, assign) NSInteger selectRow;
@property (nonatomic, assign) NSInteger timeSelectNum;



@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSArray *test1Array;
@property (nonatomic, strong) NSArray *test2Array;
@property (nonatomic, strong) NSArray *test3Array;

@end

@implementation PictureViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self setupNav];
    
    [self setupTableView];
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    
    // 初始化
    self.test1Array = [NSArray arrayWithObjects:@"【服务口碑现场】第二期",@"讲述红星人自己的故事",@"【服务口碑现场】第一期", nil];
    self.test2Array = [NSArray arrayWithObjects:@"把第一次客户投诉变成商场服务提升的契机，变成商场服务提升的契机。",@"变成商场服务提升的契机，变成商场服务提升的契机。",@"把第一次客户投诉变成商场服务提升的契机，变成商场服务提升的契机。", nil];
    self.test3Array = [NSArray arrayWithObjects:@"2015-08-26",@"2015-08-09",@"2015-07-31", nil];
}


#pragma mark - Private Methods

- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"图说口碑"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *rightButton = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, 60, 20)];
    [rightButton setTitle:@"我要新增" forState:UIControlStateNormal];
    [rightButton addTarget:self action:@selector(addClick:) forControlEvents:UIControlEventTouchUpInside];
    [rightButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    rightButton.titleLabel.font = [UIFont systemFontOfSize:15];
    UIBarButtonItem *rightButtonItem = [[UIBarButtonItem alloc] initWithCustomView:rightButton];
    self.navigationItem.rightBarButtonItem = rightButtonItem;
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
}

-(void)doBack:(id)sender
{
    [self.navigationController dismissViewControllerAnimated:YES completion:nil];
}

- (void)setupTableView
{
    [self.tableView registerClass:[PictureTableCell class] forCellReuseIdentifier:kPictureTableViewCell];
}

- (void)addClick:(UIButton *)sender
{
    AddPictureViewController *addPic = [[AddPictureViewController alloc] init];
    [self.navigationController pushViewController:addPic animated:YES];
}

- (void)dropCilck:(MenuButton *)sender
{
    sender.isDrop = !sender.isDrop;
    
    if (_selctedButton.tag == sender.tag) {
        
        
        if (sender.isDrop) {
            if (sender.tag == 4001) {
                [self showRedView];
            } else {
                [self showGreenView];
            }
            sender.selected = YES;
            
        } else {
            if (sender.tag == 4001) {
                [self closeRedView];
            } else {
                [self closeGreenView];
            }
            sender.selected = NO;
            
        }
    } else {
        // 前一次选中的按钮 选中状态置为NO
        _selctedButton.selected = NO;
        _selctedButton.isDrop = NO;
        // 进行选中状态为NO 的操作
        //   2.判断当前是否有bgView 有->移除， 没有->跳过
        if (_bgView) {
            // _bgView存在
            [_bgView removeFromSuperview];
            _bgView = nil;
        }
        
        if (_taxisView) {
            [_taxisView removeFromSuperview];
            _taxisView = nil;
        }
        
        if (_screenView) {
            [_screenView removeFromSuperview];
            _screenView = nil;
        }
        
        
        // 将当前选中的按钮设置 选中状态为YES;
        sender.selected = YES;
        // 对选中按钮 进行相关操作
        _selctedButton = (MenuButton *)sender;
        
        if (sender.tag == 4001) {
            [self showRedView];
        } else {
            [self showGreenView];
        }
    }
}

- (void)showRedView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] initWithFrame:CGRectMake(0, 45, kScreenWidth,  kScreenHeight - 45)];
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeRedView)];
        [_bgView addGestureRecognizer:tapGR];
    }
    if (!_taxisView) {
        _taxisView = [[TaxisView alloc] init];
        _taxisView.backgroundColor = [UIColor whiteColor];
    }
    
    _taxisView.delegate = self;
    [self.view addSubview:_bgView];
    [self.view insertSubview:_taxisView aboveSubview:_bgView];
    
    _bgView.alpha = 0;
    _bgView.backgroundColor = [UIColor blackColor];
    
    CGRect toFrame = CGRectMake(0, 45, kScreenWidth, kTaxisViewHeight);
    CGRect fromFrame = CGRectMake(0, -kTaxisViewHeight, kScreenWidth, kTaxisViewHeight);
    _taxisView.alpha = 0.0;
    _taxisView.frame = toFrame;
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = 0.6;
        _taxisView.alpha = 1.0;
//        _taxisView.frame = toFrame;
    }];
    
}

- (void)closeRedView
{
    _selctedButton.isDrop = NO;
    _selctedButton.selected = NO;
    [_selctedButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    CGRect fromFrame = CGRectMake(0, -kTaxisViewHeight, kScreenWidth, kTaxisViewHeight);
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = .0f;
        //_taxisView.frame = fromFrame;
        _taxisView.alpha = 0.0;
    } completion:^(BOOL finished) {
        [_bgView removeFromSuperview];
        [_taxisView removeFromSuperview];
    }];
}


- (void)showGreenView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] initWithFrame:CGRectMake(0,64 + 45, kScreenWidth,  kScreenHeight - 64 - 45)];
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeGreenView)];
        [_bgView addGestureRecognizer:tapGR];
    }
    if (!_screenView) {
        _screenView = [[ScreenView alloc] initWithTitleArray:[NSArray arrayWithObjects:@"待解决", @"已解决",@"已作废",nil]];
        _screenView.delegate = self;
        _screenView.inspectTableView.inspectDelegate = self;
        _screenView.backgroundColor = [UIColor whiteColor];
    }
    
    
    [self.view addSubview:_bgView];
    [self.view insertSubview:_screenView aboveSubview:_bgView];
    
    _bgView.alpha = 0;
    _bgView.backgroundColor = [UIColor blackColor];
    
    CGRect toFrame = CGRectMake(0, 45, kScreenWidth, kScreenViewHeight);
    CGRect fromFrame = CGRectMake(0, -kScreenViewHeight, kScreenWidth, kScreenViewHeight);
    
    _screenView.frame = fromFrame;
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = 0.6;
        _screenView.frame = toFrame;
    }];
    
}

- (void)closeGreenView
{
    _selctedButton.isDrop = NO;
    _selctedButton.selected = NO;
    [_selctedButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    CGRect fromFrame = CGRectMake(0, -kScreenViewHeight, kScreenWidth, kScreenViewHeight);
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = .0f;
        _screenView.frame = fromFrame;
    } completion:^(BOOL finished) {
        [_bgView removeFromSuperview];
        [_screenView removeFromSuperview];
    }];
}



#pragma mark - UITableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _test1Array.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    PictureTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kPictureTableViewCell];
    if (!cell) {
        cell = [[PictureTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kPictureTableViewCell];
    }
    cell.titleLabel.text = _test1Array[indexPath.row];
    cell.detailsLabel.text = _test2Array[indexPath.row];
    cell.dateLabel.text = [NSString stringWithFormat:@"发布时间: %@", _test3Array[indexPath.row]];
    [cell.thumbBtn setTitle:@"220" forState:UIControlStateNormal];
    [cell.commentBtn setTitle:@"18" forState:UIControlStateNormal];
    return cell;
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 123;
}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 45;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 0;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"该功能正在努力开发中！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
    [alert show];

//    PictureStoryViewController *storyVC = [[PictureStoryViewController alloc] init];
//    [self.navigationController pushViewController:storyVC animated:YES];
}

// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    // 创建sectionView
    UIView *sectionView = [[UIView alloc] init];
    sectionView.userInteractionEnabled = YES;
    sectionView.backgroundColor = kInspectSectionBackGroundColor;
    
    UIView *lineView = [[UIView alloc] init];
    lineView.translatesAutoresizingMaskIntoConstraints = NO;
    lineView.backgroundColor = kSeparateLineColor;
    [sectionView addSubview:lineView];
    
    NSLayoutConstraint *lineTop = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:lineTop];
    
    NSLayoutConstraint *lineLeft = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:-0.5];
    [sectionView addConstraint:lineLeft];
    
    NSLayoutConstraint *lineWidth = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:1];
    [sectionView addConstraint:lineWidth];
    
    NSLayoutConstraint *lineBottom = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:lineBottom];
    
    MenuButton *taxiButton = [[MenuButton alloc] init];
    taxiButton.translatesAutoresizingMaskIntoConstraints = NO;
    [taxiButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    [taxiButton setImage:[UIImage imageNamed:@"sort_icon"] forState:UIControlStateNormal];
    taxiButton.titleLabel.font = [UIFont systemFontOfSize:14.0];
    [taxiButton setTitle:@"排序" forState:UIControlStateNormal];
    [sectionView addSubview:taxiButton];
    
    MenuButton *screenButton = [[MenuButton alloc] init];
    screenButton.translatesAutoresizingMaskIntoConstraints = NO;
    [screenButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    [screenButton setImage:[UIImage imageNamed:@"filter_icon"] forState:UIControlStateNormal];
    screenButton.titleLabel.font = [UIFont systemFontOfSize:14.0];
    [screenButton setTitle:@"筛选" forState:UIControlStateNormal];
    [sectionView addSubview:screenButton];
    
    taxiButton.tag = 4001;
    [taxiButton addTarget:self action:@selector(dropCilck:) forControlEvents:UIControlEventTouchUpInside];
    [screenButton addTarget:self action:@selector(dropCilck:) forControlEvents:UIControlEventTouchUpInside];
    
    // taxiButton布局
    NSLayoutConstraint *taxiButtonTop = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonTop];
    
    NSLayoutConstraint *taxiButtonLeft = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonLeft];
    
    NSLayoutConstraint *taxiButtonWidth = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:screenButton attribute:NSLayoutAttributeWidth multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonWidth];
    
    NSLayoutConstraint *taxiButtonBottom = [NSLayoutConstraint constraintWithItem:taxiButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:taxiButtonBottom];
    
    // screenButton布局
    NSLayoutConstraint *screenButtonTop = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonTop];
    
    NSLayoutConstraint *screenButtonRight = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonRight];
    
    NSLayoutConstraint *screenButtonLeft = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:taxiButton attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonLeft];
    
    NSLayoutConstraint *screenButtonBottom = [NSLayoutConstraint constraintWithItem:screenButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:screenButtonBottom];
    
    return sectionView;
}

#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStylePlain];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
