//
//  SpotCheckOnLineViewController.m
//  redstar
//
//  Created by admin on 15/11/29.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "SpotCheckOnLineViewController.h"
#import "OnLineViewController.h"
#import "TaxisView.h"
#import "ScreenView.h"
#import "MenuView.h"
#import "OnLineCompleteViewController.h"

#import "InspectListCell.h"
#define kInspectListTableViewcellIndeterfor @"inspectListTableViewcellIndeterfor"
@interface SpotCheckOnLineViewController ()<UITableViewDelegate, UITableViewDataSource,ScreenTableDelegate, TaxisViewDelegate, InspectTableViewDelegate>
@property (nonatomic, strong) MenuView *menuView;
@property (nonatomic, strong) UITableView *tableView;

@property (nonatomic, strong) TaxisView *taxisView;
@property (nonatomic, strong) ScreenView *screenView;
@property (nonatomic, strong) MenuButton *selctedButton;

@property (nonatomic, strong) UIView *bgView;
@property (nonatomic, assign) NSInteger selectRow;
@property (nonatomic, assign) NSInteger timeSelectNum;

@end

@implementation SpotCheckOnLineViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor whiteColor];
    
    if ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7.0) {
        self.edgesForExtendedLayout = UIRectEdgeNone;
        self.extendedLayoutIncludesOpaqueBars = NO;
        self.modalPresentationCapturesStatusBarAppearance = NO;
        self.navigationController.navigationBar.translucent = NO;
    }
    
    [self setupNav];
    
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [self.menuView.taxiButton addTarget:self action:@selector(dropCilck:) forControlEvents:UIControlEventTouchUpInside];
    [self.menuView.screenButton addTarget:self action:@selector(dropCilck:) forControlEvents:UIControlEventTouchUpInside];
    self.tabBarController.tabBar.hidden = YES;
}

- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    [self.menuView removeFromSuperview];
    self.menuView = nil;
}


#pragma mark - Private Mothods
- (void)setupNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"抽查任务列表"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *rightButton = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, 60, 20)];
    [rightButton setTitle:@"新增任务" forState:UIControlStateNormal];
    [rightButton addTarget:self action:@selector(addSpotCheckTaskClick:) forControlEvents:UIControlEventTouchUpInside];
    [rightButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    rightButton.titleLabel.font = [UIFont systemFontOfSize:15];
    UIBarButtonItem *rightButtonItem = [[UIBarButtonItem alloc] initWithCustomView:rightButton];
    self.navigationItem.rightBarButtonItem = rightButtonItem;
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
}

- (void)doBack:(id)sender
{
    [self.navigationController dismissViewControllerAnimated:YES completion:nil];
}

- (void)addSpotCheckTaskClick:(UIButton *)sender
{
    OnLineViewController *onlineVC = [[OnLineViewController alloc] init];
    [self.navigationController pushViewController:onlineVC animated:YES];
}

- (void)dropCilck:(MenuButton *)sender
{
    sender.isDrop = !sender.isDrop;
    
    if (_selctedButton.tag == sender.tag) {
        
        
        if (sender.isDrop) {
            if (sender.tag == 4001) {
                [self showRedView];
            } else {
                [self showGreenView];
            }
            sender.selected = YES;
            
        } else {
            if (sender.tag == 4001) {
                [self closeRedView];
            } else {
                [self closeGreenView];
            }
            sender.selected = NO;
            
        }
    } else {
        // 前一次选中的按钮 选中状态置为NO
        _selctedButton.selected = NO;
        _selctedButton.isDrop = NO;
        // 进行选中状态为NO 的操作
        //   2.判断当前是否有bgView 有->移除， 没有->跳过
        if (_bgView) {
            // _bgView存在
            [_bgView removeFromSuperview];
            _bgView = nil;
        }
        
        if (_taxisView) {
            [_taxisView removeFromSuperview];
            _taxisView = nil;
        }
        
        if (_screenView) {
            [_screenView removeFromSuperview];
            _screenView = nil;
        }
        
        
        // 将当前选中的按钮设置 选中状态为YES;
        sender.selected = YES;
        // 对选中按钮 进行相关操作
        _selctedButton = (MenuButton *)sender;
        
        if (sender.tag == 4001) {
            [self showRedView];
        } else {
            [self showGreenView];
        }
    }
}

- (void)showRedView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] initWithFrame:self.view.bounds];
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeRedView)];
        [_bgView addGestureRecognizer:tapGR];
    }
    if (!_taxisView) {
        _taxisView = [[TaxisView alloc] init];
        _taxisView.backgroundColor = [UIColor whiteColor];
    }
    
    _taxisView.delegate = self;
    [self.view addSubview:_bgView];
    [self.view insertSubview:_taxisView aboveSubview:_bgView];
    
    _bgView.alpha = 0;
    _bgView.backgroundColor = [UIColor blackColor];
    
    CGRect toFrame = CGRectMake(0, 45, kScreenWidth, kTaxisViewHeight);
    CGRect fromFrame = CGRectMake(0, -kTaxisViewHeight, kScreenWidth, kTaxisViewHeight);
    
    _taxisView.frame = fromFrame;
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = 0.6;
        _taxisView.frame = toFrame;
    }];
    
}

- (void)closeRedView
{
    _selctedButton.isDrop = NO;
    _selctedButton.selected = NO;
    [_selctedButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    CGRect fromFrame = CGRectMake(0, -kTaxisViewHeight, kScreenWidth, kTaxisViewHeight);
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = .0f;
        _taxisView.frame = fromFrame;
    } completion:^(BOOL finished) {
        [_bgView removeFromSuperview];
        [_taxisView removeFromSuperview];
    }];
}


- (void)showGreenView
{
    if (!_bgView) {
        _bgView = [[UIView alloc] initWithFrame:self.view.bounds];
        UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeGreenView)];
        [_bgView addGestureRecognizer:tapGR];
    }
    if (!_screenView) {
        _screenView = [[ScreenView alloc] initWithTitleArray:[NSArray arrayWithObjects:@"待解决", @"已解决",@"已作废",nil]];
        _screenView.delegate = self;
        _screenView.inspectTableView.inspectDelegate = self;
        _screenView.backgroundColor = [UIColor whiteColor];
    }
    [_screenView.resetBtn addTarget:self action:@selector(resetClick:) forControlEvents:UIControlEventTouchUpInside];
    [_screenView.submitBtn addTarget:self action:@selector(submitClick:) forControlEvents:UIControlEventTouchUpInside];
    
    [self.view addSubview:_bgView];
    [self.view insertSubview:_screenView aboveSubview:_bgView];
    
    _bgView.alpha = 0;
    _bgView.backgroundColor = [UIColor blackColor];
    
    CGRect toFrame = CGRectMake(0, 45, kScreenWidth, kScreenViewHeight);
    CGRect fromFrame = CGRectMake(0, -kScreenViewHeight, kScreenWidth, kScreenViewHeight);
    
    _screenView.frame = fromFrame;
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = 0.6;
        _screenView.frame = toFrame;
    }];
    
}

- (void)closeGreenView
{
    _selctedButton.isDrop = NO;
    _selctedButton.selected = NO;
    [_selctedButton setTitleColor:kInspectSectionButtonTextColor forState:UIControlStateNormal];
    CGRect fromFrame = CGRectMake(0, -kScreenViewHeight, kScreenWidth, kScreenViewHeight);
    [UIView animateWithDuration:0.3 animations:^{
        _bgView.alpha = .0f;
        _screenView.frame = fromFrame;
    } completion:^(BOOL finished) {
        [_bgView removeFromSuperview];
        [_screenView removeFromSuperview];
    }];
}

// 重置按钮
- (void)resetClick:(UIButton *)sender
{
    NSInteger selectedIndex = 0;
    NSIndexPath *selectedIndexPath = [NSIndexPath indexPathForRow:selectedIndex inSection:0];
    [_screenView.tableView selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    
    _screenView.textView.text = @"";
    
    NSInteger timeIndex = 0;
    NSIndexPath *timeIndexPath = [NSIndexPath indexPathForRow:timeIndex inSection:0];
    [_screenView.tableView selectRowAtIndexPath:timeIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    _selectRow = 0;
}
// 提交按钮
- (void)submitClick:(UIButton *)sender
{
    
}

#pragma mark - InspectTableViewDelegate
- (void)inspectTableViewDidSelectWithRow:(NSInteger)row
{
    _selectRow = row;
}

#pragma mark - TaxisDelegate
- (void)timeChange:(UIButton *)sender
{
    [self closeRedView];
}

#pragma mark - ScreenTableDelegate
- (void)tableViewDidSelectRow:(NSInteger)row
{
    _timeSelectNum = row;
}



#pragma mark - UITableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 7;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    InspectListCell *cell=[tableView dequeueReusableCellWithIdentifier:kInspectListTableViewcellIndeterfor];
    if (!cell) {
        cell = [[InspectListCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kInspectListTableViewcellIndeterfor];
    }
    cell.titleLabel.text = @"9月中旬卫生临时抽查";
    cell.startDate.text = @"起始时间：2015-09-21 15:23:21"; // 起
    cell.overDate.text = @"截止时间：2015-09-30"; // 截止
    
    NSString *str = [NSString stringWithFormat:@"巡检进度：进行中"];
    NSMutableAttributedString *strAttr = [[NSMutableAttributedString alloc] initWithString:str];
    [strAttr addAttributes:@{NSForegroundColorAttributeName:kCellDetailColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(0,5)];
    [strAttr addAttributes:@{NSForegroundColorAttributeName:kProgressDealWithColor,NSFontAttributeName:[UIFont systemFontOfSize:14.0f]} range:NSMakeRange(5,str.length - 5)];
    [cell.progressLabel setAttributedText:strAttr];
    
    CGFloat already = 5;
    CGFloat all = 10;
    cell.multiplier = already / all;

    cell.alreadyLabel.text = [NSString stringWithFormat:@"%.0f",already];
    cell.alreadyLabel.textColor = kProgressDealWithColor;
    
    cell.allLabel.text = [NSString stringWithFormat:@"/%.0f",all];
    cell.allLabel.textColor = kProgressDealWithColor;
    
    cell.allView.backgroundColor = kProgressViewAllBackColor;
    
    UIImage *image = [UIImage imageNamed:@"progress-bar"];
    image = [image resizableImageWithCapInsets:UIEdgeInsetsZero resizingMode:UIImageResizingModeTile];
    cell.alreadyView.image = image;
    
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    
    return cell;
}

// cell的点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示" message:@"该功能正在努力开发中！" delegate:self cancelButtonTitle:nil otherButtonTitles:@"确定", nil];
    [alert show];
//    OnLineCompleteViewController *completeVC = [[OnLineCompleteViewController alloc] init];
//    [self.navigationController pushViewController:completeVC animated:YES];
}


// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 0;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 0;
}

#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStylePlain];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.tableFooterView = [[UIView alloc] init];
        [_tableView registerClass:[InspectListCell class] forCellReuseIdentifier:kInspectListTableViewcellIndeterfor];
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 200.0;
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:45];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (MenuView *)menuView
{
    if (!_menuView) {
        _menuView = [[MenuView alloc] init];
        _menuView.translatesAutoresizingMaskIntoConstraints = NO;
        _menuView.backgroundColor = kInspectSectionBackGroundColor;
        UIWindow *window = [[UIApplication sharedApplication].windows lastObject];
        [window addSubview:_menuView];
        
        NSLayoutConstraint *menuTop = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:window attribute:NSLayoutAttributeTop multiplier:1.0 constant:64];
        [window addConstraint:menuTop];
        
        NSLayoutConstraint *menuLeft = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:window attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [window addConstraint:menuLeft];
        
        NSLayoutConstraint *menuRight = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:window attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [window addConstraint:menuRight];
        
        NSLayoutConstraint *menuHeight = [NSLayoutConstraint constraintWithItem:_menuView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:45];
        [window addConstraint:menuHeight];
    }
    return _menuView;
}


@end
